/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.io.terminal.NTerminalModeOp;
import net.thevpc.nuts.runtime.standalone.text.EscapeOutputStream;
import net.thevpc.nuts.runtime.standalone.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.standalone.text.FilterFormatOutputStream;
import net.thevpc.nuts.runtime.standalone.text.FormatOutputStream;
import net.thevpc.nuts.runtime.standalone.text.SimpleWriterOutputStream;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NUnsupportedEnumException;

public class ExtendedFormatAwarePrintWriter
extends PrintWriter
implements ExtendedFormatAware {
    private final NWorkspace workspace;
    private final NSystemTerminalBase term;
    private Object base = null;

    public ExtendedFormatAwarePrintWriter(Writer out, NSystemTerminalBase term, NWorkspace workspace) {
        super(out);
        this.base = out;
        this.workspace = workspace;
        this.term = term;
    }

    public ExtendedFormatAwarePrintWriter(Writer out, boolean autoFlush, NSystemTerminalBase term, NWorkspace workspace) {
        super(out, autoFlush);
        this.base = out;
        this.workspace = workspace;
        this.term = term;
    }

    public ExtendedFormatAwarePrintWriter(OutputStream out, NSystemTerminalBase term, NWorkspace workspace) {
        super(out);
        this.base = out;
        this.term = term;
        this.workspace = workspace;
    }

    public ExtendedFormatAwarePrintWriter(OutputStream out, boolean autoFlush, NSystemTerminalBase term, NWorkspace workspace) {
        super(out, autoFlush);
        this.base = out;
        this.workspace = workspace;
        this.term = term;
    }

    @Override
    public NTerminalModeOp getModeOp() {
        if (this.base instanceof ExtendedFormatAware) {
            return ((ExtendedFormatAware)this.base).getModeOp();
        }
        return NTerminalModeOp.NOP;
    }

    @Override
    public ExtendedFormatAware convert(NTerminalModeOp other) {
        if (other == null || other == this.getModeOp()) {
            return this;
        }
        if (this.base instanceof ExtendedFormatAware) {
            return ((ExtendedFormatAware)this.base).convert(other);
        }
        switch (other) {
            case NOP: {
                return this;
            }
            case FORMAT: {
                return new FormatOutputStream(new SimpleWriterOutputStream(this, this.term, this.workspace), this.term);
            }
            case FILTER: {
                return new FilterFormatOutputStream(new SimpleWriterOutputStream(this, this.term, this.workspace), this.term);
            }
            case ESCAPE: {
                return new EscapeOutputStream(new SimpleWriterOutputStream(this, this.term, this.workspace), this.term);
            }
            case UNESCAPE: {
                return new EscapeOutputStream(new SimpleWriterOutputStream(this, this.term, this.workspace), this.term);
            }
        }
        throw new NUnsupportedEnumException(other);
    }

    @Override
    public void flush() {
        super.flush();
    }

    @Override
    public PrintWriter format(String format, Object ... args) {
        return this.format(null, format, args);
    }

    @Override
    public ExtendedFormatAwarePrintWriter format(Locale l, String format, Object ... args) {
        if (l == null) {
            this.print(NText.of(NMsg.ofC(format, args)));
        } else {
            this.print(NText.of(NMsg.ofC(format, args)));
        }
        return this;
    }
}

