/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.runtime.standalone.text.AlphabetNTitleNumber;
import net.thevpc.nuts.runtime.standalone.text.BulletNTitleNumber;
import net.thevpc.nuts.runtime.standalone.text.IntNTitleNumber;
import net.thevpc.nuts.text.NTitleNumber;
import net.thevpc.nuts.text.NTitleSequence;

public class DefaultNTitleSequence
implements NTitleSequence {
    private NTitleNumberAndSep[] value;
    private String end;
    private String start;
    private String stringPattern;

    private static boolean hasBullets(String s) {
        if (s.isEmpty()) {
            return false;
        }
        for (char c : s.toCharArray()) {
            if (!DefaultNTitleSequence.isBullet(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasAlphaNum(String s) {
        for (char c : s.toCharArray()) {
            if (!DefaultNTitleSequence.isAlphaNum(c)) continue;
            return true;
        }
        return false;
    }

    private static boolean isBullet(char c) {
        return c == '*' || c == '-' || c == '+';
    }

    private static boolean isSep(char c) {
        return c == '.' || c == '-' || c == '_' || c == '/';
    }

    private static boolean isAlphaNum(char c) {
        return c == '0' || c == '1' || c == 'a' || c == 'A';
    }

    public DefaultNTitleSequence(String pattern) {
        if (pattern.isEmpty()) {
            pattern = "1.";
        }
        this.stringPattern = pattern;
        StringBuilder end = new StringBuilder();
        StringBuilder start = new StringBuilder();
        ArrayList<NTitleNumberAndSep> p = new ArrayList<NTitleNumberAndSep>();
        char[] charArray = pattern.toCharArray();
        String lastSep = null;
        block8: for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            switch (c) {
                case '0': 
                case '1': {
                    if (end.length() == 0) {
                        if (lastSep == null) {
                            if (i + 1 < charArray.length && DefaultNTitleSequence.isSep(charArray[i + 1])) {
                                lastSep = String.valueOf(charArray[i + 1]);
                            } else if (p.size() > 0 && ((NTitleNumberAndSep)p.get((int)0)).n instanceof IntNTitleNumber) {
                                lastSep = ".";
                            } else if (p.size() == 0) {
                                lastSep = ".";
                            }
                        }
                        p.add(new NTitleNumberAndSep(new IntNTitleNumber(0), lastSep));
                        lastSep = null;
                        continue block8;
                    }
                    end.append(c);
                    continue block8;
                }
                case 'A': {
                    if (end.length() == 0) {
                        if (lastSep == null) {
                            if (i + 1 < charArray.length && DefaultNTitleSequence.isSep(charArray[i + 1])) {
                                lastSep = String.valueOf(charArray[i + 1]);
                            } else if (p.size() > 0 && ((NTitleNumberAndSep)p.get((int)0)).n instanceof AlphabetNTitleNumber) {
                                lastSep = "-";
                            } else if (p.size() == 0) {
                                lastSep = "-";
                            }
                        }
                        p.add(new NTitleNumberAndSep(AlphabetNTitleNumber.ofUpperCased(), lastSep));
                        lastSep = null;
                        continue block8;
                    }
                    end.append(c);
                    continue block8;
                }
                case 'a': {
                    if (end.length() == 0) {
                        if (lastSep == null) {
                            if (i + 1 < charArray.length && DefaultNTitleSequence.isSep(charArray[i + 1])) {
                                lastSep = String.valueOf(charArray[i + 1]);
                            } else if (p.size() > 0 && ((NTitleNumberAndSep)p.get((int)0)).n instanceof AlphabetNTitleNumber) {
                                lastSep = "-";
                            } else if (p.size() == 0) {
                                lastSep = "-";
                            }
                        }
                        p.add(new NTitleNumberAndSep(AlphabetNTitleNumber.ofLowerCased(), lastSep));
                        lastSep = null;
                        continue block8;
                    }
                    end.append(c);
                    continue block8;
                }
                case '*': 
                case '+': {
                    if (end.length() == 0) {
                        p.add(new NTitleNumberAndSep(BulletNTitleNumber.ofBullet(c), lastSep));
                        lastSep = null;
                        continue block8;
                    }
                    end.append(c);
                    continue block8;
                }
                case '-': {
                    if (end.length() == 0) {
                        if (p.isEmpty() || ((NTitleNumberAndSep)p.get((int)(p.size() - 1))).n.isBullet()) {
                            p.add(new NTitleNumberAndSep(BulletNTitleNumber.ofBullet(c), lastSep));
                            lastSep = null;
                            continue block8;
                        }
                        if (lastSep == null) {
                            lastSep = String.valueOf(c);
                            continue block8;
                        }
                        lastSep = lastSep + String.valueOf(c);
                        continue block8;
                    }
                    end.append(c);
                    continue block8;
                }
                case '.': 
                case '/': 
                case '_': {
                    if (end.length() == 0) {
                        if (lastSep == null) {
                            lastSep = String.valueOf(c);
                            continue block8;
                        }
                        lastSep = lastSep + String.valueOf(c);
                        continue block8;
                    }
                    end.append(c);
                    continue block8;
                }
                default: {
                    if (p.isEmpty()) {
                        start.append(c);
                        continue block8;
                    }
                    end.append(c);
                }
            }
        }
        if (lastSep != null) {
            end.append(lastSep);
        }
        this.value = p.toArray(new NTitleNumberAndSep[0]);
        this.start = start.toString();
        this.end = end.toString();
    }

    public DefaultNTitleSequence() {
        this("");
    }

    protected DefaultNTitleSequence(NTitleNumberAndSep[] pattern, String start, String end, String stringPattern) {
        this.value = pattern;
        this.start = start;
        this.end = end;
        this.stringPattern = stringPattern;
    }

    private NTitleNumber numberAt(int level, NTitleNumberAndSep[] pattern) {
        int a;
        int mm = Math.min(this.value.length, pattern.length);
        for (int i = a = Math.min(level, mm - 1); i >= 0; --i) {
            if (i < this.value.length && this.value[i] != null) {
                return this.value[i].n;
            }
            if (i >= pattern.length || pattern[i] == null) continue;
            return pattern[i].n;
        }
        return new IntNTitleNumber(0);
    }

    @Override
    public NTitleSequence next(int level) {
        int i;
        if (level <= 0) {
            throw new IllegalArgumentException("invalid level. must be >= 1");
        }
        int max = Math.max(level, this.value.length);
        NTitleNumberAndSep[] pattern = new NTitleNumberAndSep[max];
        for (i = level; i < this.value.length; ++i) {
            pattern[i] = new NTitleNumberAndSep(this.value[i].n, this.value[i].sep);
        }
        for (i = 0; i < level; ++i) {
            NTitleNumber nn = this.numberAt(i, pattern);
            if (nn.isNone()) {
                nn = nn.first();
            }
            pattern[i] = new NTitleNumberAndSep(nn, this.getSepAt(i));
        }
        NTitleNumber nn = this.numberAt(level, pattern);
        pattern[level - 1].n = nn.next();
        pattern[level - 1].sep = this.getSepAt(level - 1);
        for (int i2 = level; i2 < pattern.length; ++i2) {
            pattern[i2].n = this.value[i2].n.none();
            pattern[i2].sep = this.value[i2].sep;
        }
        return this.newInstance(pattern);
    }

    private String getSepAt(int i) {
        if (i >= this.value.length) {
            i = this.value.length - 1;
        }
        if (i >= 0) {
            return this.value[i].sep;
        }
        return ".";
    }

    private int depth() {
        for (int i = 0; i < this.value.length; ++i) {
            if (!this.value[i].n.isNone()) continue;
            return i;
        }
        return this.value.length;
    }

    @Override
    public NTitleNumber getNumber(int index) {
        if (index >= 0 && index < this.value.length) {
            if (this.value[index] == null || this.value[index].n.isNone()) {
                return null;
            }
            return this.value[index].n;
        }
        return null;
    }

    @Override
    public int size() {
        return this.value.length;
    }

    public List<NTitleNumber> getPattern() {
        NTitleNumber[] pattern = new NTitleNumber[this.value.length];
        for (int i = 0; i < pattern.length; ++i) {
            pattern[i] = this.value[i].n.none();
        }
        return new ArrayList<NTitleNumber>(Arrays.asList(pattern));
    }

    public List<NTitleNumber> getValue() {
        ArrayList<NTitleNumber> ok = new ArrayList<NTitleNumber>();
        for (int i = 0; i < this.value.length && this.value[i] != null && !this.value[i].n.isNone(); ++i) {
            ok.add(this.value[i].n);
        }
        return ok;
    }

    protected NTitleSequence newInstance(NTitleNumberAndSep[] newValue) {
        return new DefaultNTitleSequence(newValue, this.start, this.end, this.stringPattern);
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        int maxBullet = -1;
        int minBullet = -1;
        for (i = 0; i < this.value.length; ++i) {
            NTitleNumberAndSep e = this.value[i];
            if (e.n.isNone() || !e.n.isBullet()) continue;
            if (minBullet < 0) {
                minBullet = i;
            }
            maxBullet = i;
        }
        if (maxBullet > 0) {
            int j = maxBullet - minBullet + 2;
            for (int i2 = 0; i2 < j; ++i2) {
                sb.append(' ');
            }
            NTitleNumberAndSep h = this.value[maxBullet];
            sb.append(h.n);
        } else {
            for (i = 0; i < this.value.length; ++i) {
                NTitleNumberAndSep h = this.value[i];
                if (h.n.isNone()) break;
                if (i > 0 && h.sep != null) {
                    sb.append(h.sep);
                }
                sb.append(h.n);
            }
            if (sb.length() > 0) {
                sb.insert(0, this.start);
                sb.append(this.end);
            }
        }
        return sb.toString();
    }

    private static class NTitleNumberAndSep {
        NTitleNumber n;
        String sep;

        public NTitleNumberAndSep(NTitleNumber n, String sep) {
            this.n = n;
            this.sep = sep;
        }

        public String toString() {
            return "NutsTitleNumberAndSep{n=" + this.n + ", sep='" + this.sep + '\'' + '}';
        }
    }
}

