/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.text.NTextNodeCollector;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextParser;
import net.thevpc.nuts.text.NTextVisitor;

public abstract class AbstractNTextNodeParser
implements NTextParser {
    protected int bufferSize = 4096;

    @Override
    public long parseIncremental(char buf, NTextVisitor visitor) {
        return this.parseIncremental(new char[]{buf}, visitor);
    }

    @Override
    public long parse(InputStream in, NTextVisitor visitor) {
        return this.parse(new BufferedReader(new InputStreamReader(in)), visitor);
    }

    @Override
    public long parse(Reader in, NTextVisitor visitor) {
        int count = 0;
        char[] buffer = new char[this.bufferSize];
        while (true) {
            int r;
            try {
                r = in.read(buffer);
                if (r <= 0) {
                    break;
                }
            }
            catch (IOException ex) {
                throw new NIOException(ex);
            }
            this.parseIncremental(buffer, 0, r, visitor);
        }
        this.parseRemaining(visitor);
        return count;
    }

    @Override
    public NText parse(InputStream in) {
        NTextNodeCollector doc = new NTextNodeCollector();
        this.parse(in, (NTextVisitor)doc);
        return doc.getRootOrEmpty();
    }

    @Override
    public NText parse(Reader in) {
        NTextNodeCollector doc = new NTextNodeCollector();
        this.parse(in, (NTextVisitor)doc);
        return doc.getRootOrEmpty();
    }

    @Override
    public NText parse(File in) {
        return this.parse(NPath.of(in));
    }

    @Override
    public NText parse(Path in) {
        return this.parse(NPath.of(in));
    }

    @Override
    public NText parse(URL in) {
        return this.parse(NPath.of(in));
    }

    @Override
    public NText parse(NInputSource in) {
        NTextNodeCollector doc = new NTextNodeCollector();
        try (InputStream is = in.getInputStream();){
            this.parse(is, (NTextVisitor)doc);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return doc.getRootOrEmpty();
    }

    @Override
    public long parseIncremental(byte[] buf, NTextVisitor visitor) {
        return this.parseIncremental(buf, 0, buf.length, visitor);
    }

    @Override
    public long parseIncremental(char[] buf, NTextVisitor visitor) {
        return this.parseIncremental(new String(buf), visitor);
    }

    @Override
    public long parseIncremental(String buf, NTextVisitor visitor) {
        return this.parseIncremental(buf.getBytes(), visitor);
    }

    @Override
    public NText parseIncremental(byte[] buf) {
        NTextNodeCollector doc = new NTextNodeCollector();
        this.parseIncremental(buf, 0, buf.length, (NTextVisitor)doc);
        return doc.getRootOrEmpty();
    }

    @Override
    public NText parseIncremental(char[] buf) {
        NTextNodeCollector doc = new NTextNodeCollector();
        this.parseIncremental(new String(buf), (NTextVisitor)doc);
        return doc.getRootOrEmpty();
    }

    @Override
    public NText parseIncremental(String buf) {
        NTextNodeCollector doc = new NTextNodeCollector();
        this.parseIncremental(buf.getBytes(), (NTextVisitor)doc);
        return doc.getRootOrEmpty();
    }

    @Override
    public NText parseIncremental(char buf) {
        NTextNodeCollector doc = new NTextNodeCollector();
        this.parseIncremental(buf, (NTextVisitor)doc);
        return doc.getRootOrEmpty();
    }

    @Override
    public NText parseIncremental(byte[] buf, int off, int len) {
        NTextNodeCollector doc = new NTextNodeCollector();
        this.parseIncremental(buf, off, len, (NTextVisitor)doc);
        return doc.getRootOrEmpty();
    }

    @Override
    public NText parseIncremental(char[] buf, int off, int len) {
        NTextNodeCollector doc = new NTextNodeCollector();
        this.parseIncremental(buf, off, len, (NTextVisitor)doc);
        return doc.getRootOrEmpty();
    }

    @Override
    public NText parseRemaining() {
        NTextNodeCollector doc = new NTextNodeCollector();
        this.parseRemaining(doc);
        return doc.getRootOrNull();
    }

    @Override
    public long parseIncremental(byte[] buf, int off, int len, NTextVisitor visitor) {
        if (len == 0) {
            return 0L;
        }
        String raw = new String(buf, off, len);
        char[] c = raw.toCharArray();
        return this.parseIncremental(c, 0, c.length, visitor);
    }
}

