/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.text;

import java.util.ArrayList;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NMsgSupplier;
import net.thevpc.nuts.text.NTerminalCmd;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextAnchor;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextCmd;
import net.thevpc.nuts.text.NTextCode;
import net.thevpc.nuts.text.NTextInclude;
import net.thevpc.nuts.text.NTextLink;
import net.thevpc.nuts.text.NTextList;
import net.thevpc.nuts.text.NTextPlain;
import net.thevpc.nuts.text.NTextStyled;
import net.thevpc.nuts.text.NTextTitle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NUnsupportedEnumException;

public abstract class AbstractNMsgFormatHelper {
    protected NMsg m;
    protected NTexts txt;
    protected NText nText;
    protected Locale locale;
    protected NSession session;
    protected String smsg;
    protected Object[] params;

    public AbstractNMsgFormatHelper(NMsg m, NTexts txt) {
        this.m = m;
        this.txt = txt;
        Object msg = m.getMessage();
        this.smsg = (String)msg;
        this.nText = txt.of(this.smsg);
        this.session = NSession.of();
        String sLocale = this.session.getLocale().orDefault();
        this.locale = NBlankable.isBlank(sLocale) ? null : new Locale(sLocale);
        this.params = m.getParams();
        if (this.params == null) {
            this.params = new Object[0];
        }
    }

    public Object resolvePlaceholder(Object any) {
        if (any instanceof NMsg) {
            return ((NMsg)any).withPlaceholders(this.m.getPlaceholders());
        }
        if (any instanceof NMsg.Placeholder) {
            Object v;
            String n = ((NMsg.Placeholder)any).getName();
            Function<String, ?> h = this.m.getPlaceholders();
            if (h != null && (v = h.apply(n)) != null) {
                return v;
            }
        }
        if (any instanceof NMsgSupplier) {
            return ((NMsgSupplier)any).apply(this.m);
        }
        if (any instanceof Supplier && any.getClass().isSynthetic()) {
            return ((Supplier)any).get();
        }
        return any;
    }

    public NText format() {
        return this.convertCurrent(this.nText);
    }

    private String convertPlain(String t) {
        return this.convertCurrent(this.txt.ofPlain(t)).filteredText();
    }

    private NText convertCurrent(NText t) {
        switch (t.type()) {
            case PLAIN: {
                String ss = ((NTextPlain)t).getValue();
                return this.formatPlain(ss);
            }
            case CODE: {
                NTextCode c = (NTextCode)t;
                return this.txt.ofCode(this.convertPlain(c.getValue()), c.getQualifier(), c.getSeparator());
            }
            case LINK: {
                NTextLink c = (NTextLink)t;
                return this.txt.ofLink(this.convertPlain(c.getValue()), c.getSeparator());
            }
            case ANCHOR: {
                NTextAnchor c = (NTextAnchor)t;
                return this.txt.ofAnchor(this.convertPlain(c.getValue()), c.getSeparator());
            }
            case INCLUDE: {
                NTextInclude c = (NTextInclude)t;
                return this.txt.ofInclude(this.convertPlain(c.getText()), c.getSeparator());
            }
            case TITLE: {
                NTextTitle c = (NTextTitle)t;
                return this.txt.ofTitle(this.convertCurrent(c.getChild()), c.getLevel());
            }
            case COMMAND: {
                NTextCmd c = (NTextCmd)t;
                NTerminalCmd tc = c.getCommand();
                ArrayList<String> newArgs = new ArrayList<String>();
                for (String arg : tc.getArgs()) {
                    newArgs.add(this.convertPlain(arg));
                }
                return this.txt.ofCommand(NTerminalCmd.of(tc.getName(), newArgs.toArray(new String[0])));
            }
            case STYLED: {
                NTextStyled c = (NTextStyled)t;
                return this.txt.ofStyled(this.convertCurrent(c.getChild()), c.getStyles());
            }
            case LIST: {
                NTextList c = (NTextList)t;
                ArrayList<NText> rr = new ArrayList<NText>();
                for (NText child : c.getChildren()) {
                    rr.add(this.convertCurrent(child));
                }
                return this.txt.ofList(rr);
            }
            case BUILDER: {
                NTextBuilder c = (NTextBuilder)t;
                return this.convertCurrent(c.build());
            }
        }
        throw new NUnsupportedEnumException(t.type());
    }

    protected abstract NText formatPlain(String var1);
}

