/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.store;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorParser;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.concurrent.NLock;
import net.thevpc.nuts.core.NLocationKey;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryConfig;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceOptionsConfig;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.elem.NElementWriter;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NPathPermission;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.id.util.CoreNIdUtils;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.FolderObjectIterator;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.InstallInfoConfig;
import net.thevpc.nuts.runtime.standalone.repository.index.NanoDBNIdSerializer;
import net.thevpc.nuts.runtime.standalone.store.AbstractNWorkspaceStore;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigApi;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigBoot;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigMain;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigRuntime;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigSecurity;
import net.thevpc.nuts.runtime.standalone.workspace.config.compat.CompatUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.compat.NVersionCompat;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDB;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.file.NanoDBOnDisk;
import net.thevpc.nuts.text.NDescriptorFormat;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NFunction;
import net.thevpc.nuts.util.NIteratorBuilder;

public class NWorkspaceStoreOnDisk
extends AbstractNWorkspaceStore {
    private NanoDB db;
    private NanoDB cacheb;

    @Override
    public NanoDB cacheDB() {
        if (this.cacheb == null) {
            this.cacheb = new NanoDBOnDisk(NPath.ofIdStore(NWorkspace.of().getApiId().builder().setVersion("SHARED").build(), NStoreType.CACHE).resolve("cachedb").toFile().get());
            this.cacheb.getSerializers().setSerializer(NId.class, () -> new NanoDBNIdSerializer());
        }
        return this.cacheb;
    }

    @Override
    public NanoDB varDB() {
        if (this.db == null) {
            this.db = new NanoDBOnDisk(NPath.ofIdStore(NWorkspace.of().getApiId().builder().setVersion("SHARED").build(), NStoreType.VAR).resolve("vardb").toFile().get());
            this.db.getSerializers().setSerializer(NId.class, () -> new NanoDBNIdSerializer());
        }
        return this.db;
    }

    @Override
    public boolean isValidWorkspaceFolder() {
        Path file = NWorkspace.of().getWorkspaceLocation().toPath().get().resolve("nuts-workspace.json");
        return Files.isRegularFile(file, new LinkOption[0]);
    }

    @Override
    public NWorkspaceConfigBoot loadWorkspaceConfigBoot() {
        return this.loadWorkspaceConfigBoot(NWorkspace.of().getWorkspaceLocation());
    }

    @Override
    public void saveWorkspaceConfigBoot(NWorkspaceConfigBoot value) {
        Path file = NWorkspace.of().getWorkspaceLocation().toPath().get().resolve("nuts-workspace.json");
        this.storeObject(value, file.toString());
    }

    @Override
    public void saveConfigSecurity(NWorkspaceConfigSecurity value) {
        NPath configVersionSpecificLocation = NPath.ofIdStore(NWorkspace.of().getApiId(), NStoreType.CONF);
        NPath file = configVersionSpecificLocation.resolve("nuts-security-config.json");
        this.storeObject(value, file.toString());
    }

    @Override
    public void saveConfigMain(NWorkspaceConfigMain value) {
        NPath configVersionSpecificLocation = NPath.ofIdStore(NWorkspace.of().getApiId(), NStoreType.CONF);
        NPath file = configVersionSpecificLocation.resolve("nuts-main-config.json");
        this.storeObject(value, file.toString());
    }

    @Override
    public void saveConfigApi(NWorkspaceConfigApi value) {
        NPath apiVersionSpecificLocation = NPath.ofIdStore(NWorkspace.of().getApiId(), NStoreType.CONF);
        NPath afile = apiVersionSpecificLocation.resolve("nuts-api-boot-config.json");
        this.storeObject(value, afile.toString());
    }

    @Override
    public void saveConfigRuntime(NWorkspaceConfigRuntime value) {
        NWorkspace workspace = NWorkspace.of();
        NPath conf = NPath.ofWorkspaceStore(NStoreType.CONF).resolve("id").resolve(workspace.getDefaultIdBasedir(workspace.getRuntimeId()));
        NPath file = conf.resolve("nuts-runtime-boot-config.json");
        this.storeObject(value, file.toString());
    }

    public void storeObject(Object anyObject, String file) {
        NElementWriter.ofJson().write(anyObject, NPath.of(file));
    }

    @Override
    public NWorkspaceConfigBoot loadWorkspaceConfigBoot(NPath workspacePath) {
        Path file = workspacePath.toPath().get().resolve("nuts-workspace.json");
        byte[] bytes = CompatUtils.readAllBytes(file);
        if (bytes == null) {
            return null;
        }
        try {
            Map a_config0 = NElementParser.ofJson().parse(bytes, Map.class);
            NVersion version = NVersion.get((String)a_config0.get("configVersion")).ifBlankEmpty().orNull();
            if (version == null && (version = NVersion.get((String)a_config0.get("createApiVersion")).ifBlankEmpty().orNull()) == null) {
                version = Nuts.getVersion();
            }
            return NVersionCompat.of(version).parseConfig(bytes);
        }
        catch (Exception ex) {
            NWorkspaceStoreOnDisk._LOG().log(NMsg.ofC("erroneous workspace config file. Unable to load file %s : %s", file, ex).asError(ex));
            throw new NIOException(NMsg.ofC("unable to load config file %s", file), (Throwable)ex);
        }
    }

    @Override
    public NWorkspaceConfigApi loadConfigApi(NId apiId) {
        NPath path;
        byte[] bytes;
        NWorkspace workspace = NWorkspace.of();
        if (apiId == null) {
            apiId = workspace.getApiId();
        }
        NWorkspaceConfigApi c = (bytes = CompatUtils.readAllBytes(path = NPath.ofIdStore(apiId, NStoreType.CONF).resolve("nuts-api-boot-config.json"))) == null ? null : NElementParser.ofJson().parse(bytes, NWorkspaceConfigApi.class);
        return c;
    }

    @Override
    public NWorkspaceConfigRuntime loadConfigRuntime() {
        NWorkspace workspace = NWorkspace.of();
        NPath path = NPath.ofIdStore(workspace.getRuntimeId(), NStoreType.CONF).resolve("nuts-runtime-boot-config.json");
        byte[] bytes = CompatUtils.readAllBytes(path);
        NWorkspaceConfigRuntime c = bytes == null ? null : NElementParser.ofJson().parse(bytes, NWorkspaceConfigRuntime.class);
        return c;
    }

    @Override
    public NWorkspaceConfigSecurity loadConfigSecurity(NId apiId) {
        NPath path;
        byte[] bytes;
        NWorkspace workspace = NWorkspace.of();
        if (apiId == null) {
            apiId = workspace.getApiId();
        }
        NWorkspaceConfigSecurity c = (bytes = CompatUtils.readAllBytes(path = NPath.ofIdStore(apiId, NStoreType.CONF).resolve("nuts-security-config.json"))) == null ? null : NElementParser.ofJson().parse(bytes, NWorkspaceConfigSecurity.class);
        return c;
    }

    @Override
    public NWorkspaceConfigMain loadConfigMain(NId apiId) {
        NPath path;
        byte[] bytes;
        NWorkspace workspace = NWorkspace.of();
        if (apiId == null) {
            apiId = workspace.getApiId();
        }
        NWorkspaceConfigMain c = (bytes = CompatUtils.readAllBytes(path = NPath.ofIdStore(apiId, NStoreType.CONF).resolve("nuts-main-config.json"))) == null ? null : NElementParser.ofJson().parse(bytes, NWorkspaceConfigMain.class);
        return c;
    }

    @Override
    public boolean saveRepoConfig(NRepository repository, NRepositoryConfig config) {
        NPath file = repository.config().getStoreLocation().resolve("nuts-repository.json");
        boolean created = false;
        if (!file.exists()) {
            created = true;
        }
        repository.config().getStoreLocation().mkdirs();
        NElementWriter.ofJson().write((Object)config, file);
        return created;
    }

    @Override
    public NRepositoryConfig loadRepoConfig(String location, String name) {
        NWorkspace workspace = NWorkspace.of();
        NPath file = NPath.of(location).resolve("nuts-repository.json");
        NRepositoryConfig conf = null;
        if (file.isRegularFile() && file.getPermissions().contains(NPathPermission.CAN_READ)) {
            byte[] bytes = file.readBytes();
            try {
                int buildNumber;
                Map a_config0 = NElementParser.ofJson().parse(bytes, Map.class);
                NVersion version = NVersion.get((String)a_config0.get("configVersion")).orNull();
                if (version == null || version.isBlank()) {
                    version = workspace.getApiVersion();
                }
                if ((buildNumber = CoreNUtils.getApiVersionOrdinalNumber(version)) < 506) {
                    // empty if block
                }
                conf = NElementParser.ofJson().parse(file, NRepositoryConfig.class);
            }
            catch (RuntimeException ex) {
                if (workspace.getBootOptions().getRecover().orElse(false).booleanValue()) {
                    this.onLoadRepositoryError(file, name, null, ex);
                }
                throw ex;
            }
        }
        return conf;
    }

    private void onLoadRepositoryError(NPath file, String name, String uuid, Throwable ex) {
        NWorkspace workspace = NWorkspace.of();
        if (workspace.isReadOnly()) {
            throw new NIOException(NMsg.ofC("error loading repository %s", file), ex);
        }
        String fileName = "nuts-repository" + (name == null ? "" : "-" + name) + (uuid == null ? "" : "-" + uuid) + "-" + Instant.now().toString();
        NWorkspaceStoreOnDisk._LOG().log(NMsg.ofC("erroneous repository config file. Unable to load file %s : %s", file, ex).asError());
        NPath logError = NPath.ofIdStore(workspace.getApiId(), NStoreType.LOG).resolve("invalid-config");
        try {
            logError.mkParentDirs();
        }
        catch (Exception ex1) {
            throw new NIOException(NMsg.ofC("unable to log repository error while loading config file %s : %s", file, ex1), ex);
        }
        NPath newfile = logError.resolve(fileName + ".json");
        NWorkspaceStoreOnDisk._LOG().log(NMsg.ofC("erroneous repository config file will be replaced by a fresh one. Old config is copied to %s", newfile).asError());
        try {
            Files.move(file.toPath().get(), newfile.toPath().get(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new NIOException(NMsg.ofC("nable to load and re-create repository config file %s : %s", file, e), ex);
        }
        try (PrintStream o = new PrintStream(logError.resolve(fileName + ".error").getOutputStream());){
            o.printf("workspace.path:%s%n", workspace.getWorkspaceLocation());
            o.printf("repository.path:%s%n", file);
            o.printf("workspace.options:%s%n", workspace.getBootOptions().toCmdLine(new NWorkspaceOptionsConfig().setCompact(false)));
            for (NStoreType storeType : NStoreType.values()) {
                o.printf("location." + storeType.id() + ":%s%n", NPath.ofWorkspaceStore(storeType));
            }
            o.printf("java.class.path:%s%n", System.getProperty("java.class.path"));
            o.println();
            ex.printStackTrace(o);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void saveInstallInfoConfig(InstallInfoConfig installInfoConfig) {
        NWorkspace workspace = NWorkspace.of();
        NPath path = NPath.ofIdStore(installInfoConfig.getId(), NStoreType.CONF).resolve("nuts-install.json");
        NElementWriter.ofJson().write((Object)installInfoConfig, path);
    }

    @Override
    public Iterator<NVersion> searchInstalledVersions(NId id) {
        NPath installFolder = NPath.ofIdStore(id.builder().setVersion("ANY").build(), NStoreType.CONF).getParent();
        if (installFolder.isDirectory()) {
            final NVersionFilter filter0 = id.getVersion().filter();
            return NIteratorBuilder.of(installFolder.stream().iterator()).map(NFunction.of(new Function<NPath, NVersion>(){

                @Override
                public NVersion apply(NPath folder) {
                    NVersion vv;
                    if (folder.isDirectory() && folder.resolve("nuts-install.json").isRegularFile() && filter0.acceptVersion(vv = NVersion.get(folder.getName()).get())) {
                        return vv;
                    }
                    return null;
                }
            }).redescribe((Supplier)NElementDescribables.ofDesc("FileToVersion"))).notNull().iterator();
        }
        return NIteratorBuilder.emptyIterator();
    }

    @Override
    public Iterator<InstallInfoConfig> searchInstalledVersions() {
        NPath rootFolder = NPath.ofWorkspaceStore(NStoreType.CONF).resolve("id");
        return new FolderObjectIterator<InstallInfoConfig>("InstallInfoConfig", rootFolder, null, -1, new FolderObjectIterator.FolderIteratorModel<InstallInfoConfig>(){

            @Override
            public boolean isObjectFile(NPath pathname) {
                return pathname.getName().equals("nuts-install.json");
            }

            @Override
            public InstallInfoConfig parseObject(NPath path) {
                try {
                    InstallInfoConfig u = NElementParser.ofJson().parse(path, InstallInfoConfig.class);
                    if (u != null && u.getId() != null) {
                        return NWorkspaceStoreOnDisk.this.loadInstallInfoConfig(u.getId());
                    }
                }
                catch (Exception ex) {
                    NWorkspaceStoreOnDisk._LOG().log(NMsg.ofC("unable to parse %s", path).asError(ex));
                }
                return null;
            }
        });
    }

    @Override
    public void deleteInstallInfoConfig(NId id) {
        this.remove(id, "nuts-install.json");
    }

    public void remove(NId id, String name) {
        NPath path = this.getPath(id, name);
        path.delete();
    }

    public NPath getPath(NId id, String name) {
        return NPath.ofIdStore(id, NStoreType.CONF).resolve(name);
    }

    @Override
    public InstallInfoConfig loadInstallInfoConfig(NId id) {
        CoreNIdUtils.checkShortId(id);
        NWorkspace workspace = NWorkspace.of();
        NPath path = this.getPath(id, "nuts-install.json");
        if (path.isRegularFile()) {
            InstallInfoConfig c = NLock.ofIdPath(id, "nuts-install.json").callWith(() -> NElementParser.ofJson().parse(path, InstallInfoConfig.class), 3L, CoreNUtils.LOCK_TIME_UNIT).orNull();
            if (c != null) {
                NId idOk;
                boolean changeStatus = false;
                NVersion v = c.getConfigVersion();
                if (NBlankable.isBlank(v)) {
                    c.setInstalled(true);
                    c.setConfigVersion(NVersion.get("0.5.8").get());
                    changeStatus = true;
                }
                if ((idOk = c.getId()) == null) {
                    if (id != null) {
                        c.setId(id);
                        changeStatus = true;
                    } else {
                        NId idOk2 = this.pathToId(path);
                        if (idOk2 != null) {
                            c.setId(idOk2);
                            changeStatus = true;
                        } else {
                            return null;
                        }
                    }
                }
                if (changeStatus && !workspace.isReadOnly()) {
                    NLock.ofPath(path).callWith(() -> {
                        NWorkspaceStoreOnDisk._LOG().log(NMsg.ofC("install-info upgraded %s", path).asConfig());
                        c.setConfigVersion(workspace.getApiVersion());
                        NElementWriter.ofJson().write((Object)c, path);
                        return null;
                    }, 3L, CoreNUtils.LOCK_TIME_UNIT).get();
                }
            }
            return c;
        }
        return null;
    }

    public NId pathToId(NPath path) {
        NPath rootFolder = NPath.ofWorkspaceStore(NStoreType.CONF).resolve("id");
        String p = path.toString().substring(rootFolder.toString().length());
        List<String> split = StringTokenizerUtils.split(p, "/\\");
        if (split.size() >= 4) {
            return NIdBuilder.of().setGroupId(String.join((CharSequence)".", split.subList(0, split.size() - 3))).setArtifactId(split.get(split.size() - 3)).setVersion(split.get(split.size() - 2)).build();
        }
        return null;
    }

    @Override
    public String loadInstalledDefaultVersion(NId id) {
        NPath pp = NPath.ofIdStore(id.builder().setVersion("ANY").build(), NStoreType.CONF).resolveSibling("default-version");
        String defaultVersion = "";
        if (pp.isRegularFile()) {
            try {
                defaultVersion = new String(pp.readBytes()).trim();
            }
            catch (Exception ex) {
                defaultVersion = "";
            }
        }
        return defaultVersion;
    }

    @Override
    public void saveInstalledDefaultVersion(NId id) {
        String version = id.getVersion().getValue();
        NPath pp = NPath.ofIdStore(id.builder().setVersion("ANY").build(), NStoreType.CONF).resolveSibling("default-version");
        if (NBlankable.isBlank(version)) {
            if (pp.isRegularFile()) {
                pp.delete();
            }
        } else {
            pp.mkParentDirs();
            pp.writeString(version.trim(), new NPathOption[0]);
        }
    }

    private static NLog _LOG() {
        return NLog.of(NWorkspaceStoreOnDisk.class);
    }

    @Override
    public void saveLocationKey(NLocationKey k, Object value) {
        NPath path = NWorkspace.of().getStoreLocation(k);
        if (value == null) {
            path.delete();
        } else if (value instanceof String) {
            path.mkParentDirs().writeString((String)value, new NPathOption[0]);
        } else if (value instanceof NDescriptor) {
            try {
                NDescriptorFormat.of((NDescriptor)value).setNtf(false).print(path);
            }
            catch (Exception ex) {
                NWorkspaceStoreOnDisk._LOG().log(NMsg.ofC("failed to print %s", path).asFineFail(ex));
            }
        } else {
            NElementWriter.ofJson().write(value, path);
        }
    }

    @Override
    public <T> T loadLocationKey(NLocationKey k, Class<T> type) {
        NPath path = NWorkspace.of().getStoreLocation(k);
        NWorkspaceStoreOnDisk.invalidateIfObsolete(k, path);
        if (path.isRegularFile()) {
            if (String.class.equals(type)) {
                return (T)path.readString();
            }
            if (NDescriptor.class.equals(type)) {
                return (T)NDescriptorParser.of().parse(path).orNull();
            }
            return NElementParser.ofJson().parse(path, type);
        }
        return null;
    }

    @Override
    public boolean deleteLocationKey(NLocationKey k) {
        NPath path = NWorkspace.of().getStoreLocation(k);
        if (path.isRegularFile()) {
            path.delete();
            return true;
        }
        return false;
    }

    private static void invalidateIfObsolete(NLocationKey k, NPath cachePath) {
        try {
            if (k.getStoreType() == NStoreType.CACHE && cachePath.isRegularFile() && CoreIOUtils.isObsoletePath(cachePath)) {
                cachePath.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

