/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.store;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.core.NLocationKey;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryConfig;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.InstallInfoConfig;
import net.thevpc.nuts.runtime.standalone.repository.index.NanoDBNIdSerializer;
import net.thevpc.nuts.runtime.standalone.store.AbstractNWorkspaceStore;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigApi;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigBoot;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigMain;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigRuntime;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigSecurity;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDB;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.mem.NanoDBInMemory;

public class NWorkspaceStoreInMemory
extends AbstractNWorkspaceStore {
    private NWorkspaceConfigBoot storedConfigBoot;
    private NWorkspaceConfigSecurity storedConfigSecurity;
    private NWorkspaceConfigMain storedConfigMain;
    private NWorkspaceConfigApi storedConfigApi;
    private Map<NVersion, NWorkspaceConfigApi> storedConfigApiByVersion = new HashMap<NVersion, NWorkspaceConfigApi>();
    private Map<NVersion, NWorkspaceConfigSecurity> storedConfigSecurityByVersion = new HashMap<NVersion, NWorkspaceConfigSecurity>();
    private Map<NVersion, NWorkspaceConfigMain> storedConfigMainByVersion = new HashMap<NVersion, NWorkspaceConfigMain>();
    private Map<String, NRepositoryConfig> repoConfigMap = new HashMap<String, NRepositoryConfig>();
    private NWorkspaceConfigRuntime storedConfigRuntime;
    private NanoDB varDB;
    private NanoDB cacheDB;
    private HashMap<NLocationKey, Object> locationKeyToObjectConfMap = new HashMap();
    private Map<NId, Map<NId, InstallInfoConfig>> shortToLongToInstallInfoConfigMap = new HashMap<NId, Map<NId, InstallInfoConfig>>();
    private Map<NId, String> shortToDefaultVersionMap = new HashMap<NId, String>();

    @Override
    public NanoDB cacheDB() {
        if (this.cacheDB == null) {
            this.cacheDB = new NanoDBInMemory();
            this.cacheDB.getSerializers().setSerializer(NId.class, () -> new NanoDBNIdSerializer());
        }
        return this.cacheDB;
    }

    @Override
    public NanoDB varDB() {
        if (this.varDB == null) {
            this.varDB = new NanoDBInMemory();
            this.varDB.getSerializers().setSerializer(NId.class, () -> new NanoDBNIdSerializer());
        }
        return this.varDB;
    }

    @Override
    public boolean isValidWorkspaceFolder() {
        return this.storedConfigBoot != null;
    }

    @Override
    public NWorkspaceConfigBoot loadWorkspaceConfigBoot() {
        return this.storedConfigBoot == null ? null : this.storedConfigBoot.copy();
    }

    @Override
    public void saveWorkspaceConfigBoot(NWorkspaceConfigBoot value) {
        this.storedConfigBoot = value == null ? null : value.copy();
    }

    @Override
    public void saveConfigSecurity(NWorkspaceConfigSecurity value) {
        this.storedConfigSecurity = value == null ? null : value.copy();
    }

    @Override
    public void saveConfigMain(NWorkspaceConfigMain value) {
        this.storedConfigMain = value == null ? null : value.copy();
    }

    @Override
    public void saveConfigApi(NWorkspaceConfigApi value) {
        this.storedConfigApi = value == null ? null : value.copy();
    }

    @Override
    public void saveConfigRuntime(NWorkspaceConfigRuntime value) {
        this.storedConfigRuntime = value == null ? null : value.copy();
    }

    @Override
    public NWorkspaceConfigBoot loadWorkspaceConfigBoot(NPath workspacePath) {
        if (Objects.equals(workspacePath, NWorkspace.of().getLocation())) {
            return this.storedConfigBoot;
        }
        return null;
    }

    @Override
    public NWorkspaceConfigApi loadConfigApi(NId apiId) {
        if (apiId == null) {
            apiId = NWorkspace.of().getApiId();
        }
        if (apiId.equals(NWorkspace.of().getApiId())) {
            return this.storedConfigApi;
        }
        return this.storedConfigApiByVersion.get(apiId.getVersion());
    }

    @Override
    public NWorkspaceConfigRuntime loadConfigRuntime() {
        return this.storedConfigRuntime == null ? null : this.storedConfigRuntime.copy();
    }

    @Override
    public NWorkspaceConfigSecurity loadConfigSecurity(NId apiId) {
        if (apiId == null) {
            apiId = NWorkspace.of().getApiId();
        }
        if (apiId.equals(NWorkspace.of().getApiId())) {
            return this.storedConfigSecurity;
        }
        return this.storedConfigSecurityByVersion.get(apiId.getVersion());
    }

    @Override
    public NWorkspaceConfigMain loadConfigMain(NId apiId) {
        if (apiId == null) {
            apiId = NWorkspace.of().getApiId();
        }
        if (apiId.equals(NWorkspace.of().getApiId())) {
            return this.storedConfigMain;
        }
        return this.storedConfigMainByVersion.get(apiId.getVersion());
    }

    @Override
    public boolean saveRepoConfig(NRepository repository, NRepositoryConfig config) {
        NRepositoryConfig old = this.repoConfigMap.put(repository.config().getStoreLocation().toString(), config.copy());
        return old == null;
    }

    @Override
    public NRepositoryConfig loadRepoConfig(String location, String name) {
        NRepositoryConfig y = this.repoConfigMap.get(location);
        return y == null ? null : y.copy();
    }

    @Override
    public void saveInstallInfoConfig(InstallInfoConfig installInfoConfig) {
        Map longToInstallInfoConfigMap = this.shortToLongToInstallInfoConfigMap.computeIfAbsent(installInfoConfig.getId().getShortId(), r -> new HashMap());
        longToInstallInfoConfigMap.put(installInfoConfig.getId().getLongId(), installInfoConfig);
    }

    @Override
    public InstallInfoConfig loadInstallInfoConfig(NId id) {
        Map<NId, InstallInfoConfig> longToInstallInfoConfigMap = this.shortToLongToInstallInfoConfigMap.get(id.getShortId());
        if (longToInstallInfoConfigMap != null) {
            return longToInstallInfoConfigMap.get(id.getLongId());
        }
        return null;
    }

    @Override
    public void deleteInstallInfoConfig(NId id) {
        Map<NId, InstallInfoConfig> longToInstallInfoConfigMap = this.shortToLongToInstallInfoConfigMap.get(id.getShortId());
        if (longToInstallInfoConfigMap != null) {
            longToInstallInfoConfigMap.remove(id.getLongId());
        }
    }

    @Override
    public Iterator<InstallInfoConfig> searchInstalledVersions() {
        return this.shortToLongToInstallInfoConfigMap.values().stream().flatMap(x -> x.values().stream()).iterator();
    }

    @Override
    public Iterator<NVersion> searchInstalledVersions(NId id) {
        Map<NId, InstallInfoConfig> nIdInstallInfoConfigMap = this.shortToLongToInstallInfoConfigMap.get(id.getShortId());
        if (nIdInstallInfoConfigMap != null) {
            return nIdInstallInfoConfigMap.values().stream().map(x -> x.getId().getVersion()).iterator();
        }
        return Collections.emptyIterator();
    }

    @Override
    public String loadInstalledDefaultVersion(NId id) {
        return this.shortToDefaultVersionMap.get(id.getShortId());
    }

    @Override
    public void saveInstalledDefaultVersion(NId id) {
        this.shortToDefaultVersionMap.put(id.getShortId(), id.getVersion().getValue());
    }

    @Override
    public void saveLocationKey(NLocationKey k, Object value) {
        this.locationKeyToObjectConfMap.put(k, value);
    }

    @Override
    public <T> T loadLocationKey(NLocationKey k, Class<T> type) {
        Object obj = this.locationKeyToObjectConfMap.get(k);
        if (obj == null) {
            return null;
        }
        return (T)obj;
    }

    @Override
    public boolean deleteLocationKey(NLocationKey k) {
        return this.locationKeyToObjectConfMap.remove(k) != null;
    }
}

