/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.session;

import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.thevpc.nuts.app.NApp;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.cmdline.NCmdLineConfigurable;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.command.NExecutionType;
import net.thevpc.nuts.command.NFetchStrategy;
import net.thevpc.nuts.command.NInstallListener;
import net.thevpc.nuts.concurrent.NCallable;
import net.thevpc.nuts.concurrent.NScopedValue;
import net.thevpc.nuts.core.NBootOptions;
import net.thevpc.nuts.core.NConfirmationMode;
import net.thevpc.nuts.core.NListener;
import net.thevpc.nuts.core.NRepositoryListener;
import net.thevpc.nuts.core.NRunAs;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceListener;
import net.thevpc.nuts.core.NWorkspaceOptions;
import net.thevpc.nuts.elem.NArrayElementBuilder;
import net.thevpc.nuts.elem.NElementFormat;
import net.thevpc.nuts.internal.NScopedWorkspace;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminal;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.log.NLogConfig;
import net.thevpc.nuts.log.NLogUtils;
import net.thevpc.nuts.runtime.standalone.elem.builder.DefaultNArrayElementBuilder;
import net.thevpc.nuts.runtime.standalone.io.terminal.AbstractNTerminal;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.util.NPropertiesHolder;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.xtra.time.ProgressOptions;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NIterableFormat;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NCopiable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NObservableMapListener;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NUnsupportedOperationException;

public class DefaultNSession
implements Cloneable,
NSession,
NCopiable {
    protected NWorkspace workspace = null;
    protected List<String> outputFormatOptions = new ArrayList<String>();
    private NTerminal terminal;
    private NPropertiesHolder properties = new NPropertiesHolder();
    private Map<Class, LinkedHashSet<NListener>> listeners = new HashMap<Class, LinkedHashSet<NListener>>();
    private String dependencySolver;
    private Boolean trace;
    private Boolean bot;
    private Boolean previewRepo;
    private String debug;
    private NRunAs runAs;
    private NExecutionType executionType;
    private Boolean dry;
    private Boolean showStacktrace;
    private Level logTermLevel;
    private Level logFileLevel;
    private NConfirmationMode confirm = null;
    private NContentType outputFormat;
    private NArrayElementBuilder eout;
    private NFetchStrategy fetchStrategy = null;
    private Boolean cached;
    private Boolean indexed;
    private Boolean transitive;
    private Boolean gui;
    private String progressOptions;
    private String errLinePrefix;
    private String outLinePrefix;
    private Instant expireTime;
    private String locale;
    private boolean iterableOut;

    public DefaultNSession(NWorkspace workspace) {
        this.workspace = workspace;
        this.copyFrom(NWorkspace.of().getBootOptions().toWorkspaceOptions());
    }

    public DefaultNSession(NWorkspace workspace, NWorkspaceOptions options) {
        this.workspace = workspace;
        if (options != null) {
            this.copyFrom(options);
        }
    }

    @Override
    public void runWith(Runnable runnable) {
        if (runnable != null) {
            NScopedWorkspace.runWith(this.workspace, () -> {
                NScopedValue<NSession> nSessions = NWorkspaceExt.of().sessionScopes();
                nSessions.runWith(this, runnable);
            });
        }
    }

    @Override
    public <T> T callWith(NCallable<T> callable) {
        if (callable != null) {
            return (T)NScopedWorkspace.callWith(this.workspace, () -> {
                NScopedValue<NSession> nSessions = NWorkspaceExt.of().sessionScopes();
                return nSessions.callWith(this, callable);
            });
        }
        return null;
    }

    @Override
    public void close() {
    }

    @Override
    public final NSession configure(boolean skipUnsupported, String ... args) {
        NId appId = NApp.of().getId().orNull();
        String appName = appId == null ? "app" : appId.getArtifactId();
        return (NSession)NCmdLineConfigurable.configure(this, skipUnsupported, args, appName);
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg a = cmdLine.peek().orNull();
        if (a != null) {
            boolean active = a.isUncommented();
            switch (a.key()) {
                case "-T": 
                case "--output-format-option": {
                    a = cmdLine.nextEntry().get();
                    if (active) {
                        this.addOutputFormatOptions(a.getStringValue().orElse(""));
                    }
                    return true;
                }
                case "-O": 
                case "--output-format": {
                    a = cmdLine.nextEntry().get();
                    if (!active) break;
                    String t = a.getStringValue().orElse("");
                    int i = NStringUtils.firstIndexOf(t, ' ', ';', ':', '=');
                    if (i > 0) {
                        this.setOutputFormat(NContentType.valueOf(t.substring(0, i).toUpperCase()));
                        this.addOutputFormatOptions(t.substring(i + 1).toUpperCase());
                        break;
                    }
                    this.setOutputFormat(NContentType.valueOf(t.toUpperCase()));
                    break;
                }
                case "--tson": {
                    a = cmdLine.next().get();
                    if (!active) break;
                    this.setOutputFormat(NContentType.TSON);
                    this.addOutputFormatOptions(a.getStringValue().orNull());
                    break;
                }
                case "--yaml": {
                    a = cmdLine.next().get();
                    if (!active) break;
                    this.setOutputFormat(NContentType.YAML);
                    this.addOutputFormatOptions(a.getStringValue().orNull());
                    break;
                }
                case "--json": {
                    a = cmdLine.next().get();
                    if (active) {
                        this.setOutputFormat(NContentType.JSON);
                        this.addOutputFormatOptions(a.getStringValue().orNull());
                    }
                    return true;
                }
                case "--props": {
                    a = cmdLine.next().get();
                    if (active) {
                        this.setOutputFormat(NContentType.PROPS);
                        this.addOutputFormatOptions(a.getStringValue().orNull());
                    }
                    return true;
                }
                case "--plain": {
                    a = cmdLine.next().get();
                    if (active) {
                        this.setOutputFormat(NContentType.PLAIN);
                        this.addOutputFormatOptions(a.getStringValue().orNull());
                    }
                    return true;
                }
                case "--table": {
                    a = cmdLine.next().get();
                    if (active) {
                        this.setOutputFormat(NContentType.TABLE);
                        this.addOutputFormatOptions(a.getStringValue().orNull());
                    }
                    return true;
                }
                case "--tree": {
                    a = cmdLine.next().get();
                    if (active) {
                        this.setOutputFormat(NContentType.TREE);
                        this.addOutputFormatOptions(a.getStringValue().orNull());
                    }
                    return true;
                }
                case "--xml": {
                    a = cmdLine.next().get();
                    if (active) {
                        this.setOutputFormat(NContentType.XML);
                        this.addOutputFormatOptions(a.getStringValue().orNull());
                    }
                    return true;
                }
                case "-y": 
                case "--yes": {
                    if (active) {
                        this.setConfirm(NConfirmationMode.YES);
                    }
                    cmdLine.skip();
                    return true;
                }
                case "--ask": {
                    if (active) {
                        this.setConfirm(NConfirmationMode.ASK);
                    }
                    cmdLine.skip();
                    return true;
                }
                case "-n": 
                case "--no": {
                    if (active) {
                        this.setConfirm(NConfirmationMode.NO);
                    }
                    cmdLine.skip();
                    return true;
                }
                case "--error": {
                    if (active) {
                        this.setConfirm(NConfirmationMode.ERROR);
                    }
                    cmdLine.skip();
                    return true;
                }
                case "--trace": {
                    NArg v = cmdLine.nextFlag().get();
                    if (active) {
                        this.setTrace(v.getBooleanValue().get());
                    }
                    return true;
                }
                case "--solver": {
                    a = cmdLine.nextEntry().get();
                    if (!active) break;
                    String s = a.getStringValue().get();
                    this.setDependencySolver(s);
                    break;
                }
                case "--progress": {
                    NArg v = cmdLine.next().get();
                    if (active) {
                        String s = a.getStringValue().orNull();
                        if (a.isNegated()) {
                            s = NBlankable.isBlank(s) ? "false" : "false," + s;
                            this.setProgressOptions(s);
                        } else {
                            this.setProgressOptions(s);
                        }
                        this.setProgressOptions(s);
                    }
                    return true;
                }
                case "--debug": {
                    a = cmdLine.next().get();
                    if (active) {
                        if (a.getStringValue().isBlank()) {
                            this.setDebug(String.valueOf(a.isEnabled()));
                        } else if (a.isNegated()) {
                            this.setDebug(String.valueOf(NLiteral.of(a.getStringValue().get()).asBoolean().ifEmpty(true).orElse(false) == false));
                        } else {
                            this.setDebug(a.getStringValue().get());
                        }
                    }
                    return true;
                }
                case "-f": 
                case "--fetch": {
                    a = cmdLine.nextEntry().get();
                    if (active) {
                        this.setFetchStrategy((NFetchStrategy)a.getStringValue().flatMap(NFetchStrategy::parse).get());
                    }
                    return true;
                }
                case "-a": 
                case "--anywhere": {
                    a = cmdLine.nextFlag().get();
                    if (active && a.getBooleanValue().get().booleanValue()) {
                        this.setFetchStrategy(NFetchStrategy.ANYWHERE);
                    }
                    return true;
                }
                case "-F": 
                case "--offline": {
                    a = cmdLine.nextFlag().get();
                    if (active && a.getBooleanValue().get().booleanValue()) {
                        this.setFetchStrategy(NFetchStrategy.OFFLINE);
                    }
                    return true;
                }
                case "--online": {
                    a = cmdLine.nextFlag().get();
                    if (active && a.getBooleanValue().get().booleanValue()) {
                        this.setFetchStrategy(NFetchStrategy.ONLINE);
                    }
                    return true;
                }
                case "--remote": {
                    a = cmdLine.nextFlag().get();
                    if (active && a.getBooleanValue().get().booleanValue()) {
                        this.setFetchStrategy(NFetchStrategy.REMOTE);
                    }
                    return true;
                }
                case "-c": 
                case "--color": {
                    a = cmdLine.next().get();
                    if (active) {
                        NTerminalMode v = null;
                        if (a.isFlagOption()) {
                            v = a.isNegated() ? NTerminalMode.INHERITED : NTerminalMode.FORMATTED;
                        } else {
                            v = a.getStringValue().flatMap(NTerminalMode::parse).ifEmpty(NTerminalMode.FORMATTED).get();
                            if (v == NTerminalMode.DEFAULT) {
                                v = NTerminalMode.INHERITED;
                            }
                        }
                        this.getTerminal().setOut(this.getTerminal().out().setTerminalMode(v));
                        this.getTerminal().setErr(this.getTerminal().err().setTerminalMode(v));
                    }
                    return true;
                }
                case "-B": 
                case "--bot": {
                    a = cmdLine.nextFlag().get();
                    if (active) {
                        this.setBot(a.getBooleanValue().get());
                        if (this.isBot()) {
                            this.getTerminal().setOut(this.getTerminal().out().setTerminalMode(NTerminalMode.FILTERED));
                            this.getTerminal().setErr(this.getTerminal().err().setTerminalMode(NTerminalMode.FILTERED));
                        }
                    }
                    return true;
                }
                case "-U": 
                case "--preview-repo": {
                    a = cmdLine.nextFlag().get();
                    if (active) {
                        this.setPreviewRepo(a.getBooleanValue().get());
                    }
                    return true;
                }
                case "--dry": 
                case "-D": {
                    a = cmdLine.nextFlag().get();
                    if (active) {
                        this.setDry(a.getBooleanValue().get());
                    }
                    return true;
                }
                case "--out-line-prefix": {
                    a = cmdLine.nextEntry().get();
                    if (active) {
                        this.setOutLinePrefix(a.getStringValue().get());
                    }
                    return true;
                }
                case "--err-line-prefix": {
                    a = cmdLine.nextEntry().get();
                    if (active) {
                        this.setErrLinePrefix(a.getStringValue().get());
                    }
                    return true;
                }
                case "--line-prefix": {
                    a = cmdLine.nextEntry().get();
                    if (active) {
                        this.setOutLinePrefix(a.getStringValue().get());
                        this.setErrLinePrefix(a.getStringValue().get());
                    }
                    return true;
                }
                case "--embedded": 
                case "-b": {
                    a = cmdLine.nextFlag().get();
                    if (active && a.getBooleanValue().get().booleanValue()) {
                        this.setExecutionType(NExecutionType.EMBEDDED);
                    }
                    return true;
                }
                case "--gui": {
                    a = cmdLine.nextFlag().get();
                    if (active) {
                        this.setGui(a.getBooleanValue().get());
                    }
                    return true;
                }
                case "--external": 
                case "--spawn": 
                case "-x": {
                    a = cmdLine.nextFlag().get();
                    if (active && a.getBooleanValue().get().booleanValue()) {
                        this.setExecutionType(NExecutionType.SPAWN);
                    }
                    return true;
                }
                case "--system": {
                    a = cmdLine.nextFlag().get();
                    if (active && a.getBooleanValue().get().booleanValue()) {
                        this.setExecutionType(NExecutionType.SYSTEM);
                    }
                    return true;
                }
                case "--current-user": {
                    a = cmdLine.nextFlag().get();
                    if (active && a.getBooleanValue().get().booleanValue()) {
                        this.setRunAs(NRunAs.currentUser());
                    }
                    return true;
                }
                case "--as-root": {
                    a = cmdLine.nextFlag().get();
                    if (active && a.getBooleanValue().get().booleanValue()) {
                        this.setRunAs(NRunAs.root());
                    }
                    return true;
                }
                case "--sudo": {
                    a = cmdLine.nextFlag().get();
                    if (active && a.getBooleanValue().get().booleanValue()) {
                        this.setRunAs(NRunAs.sudo());
                    }
                    return true;
                }
                case "--as-user": {
                    a = cmdLine.nextEntry().get();
                    if (active) {
                        this.setRunAs(NRunAs.user(a.getStringValue().get()));
                    }
                    return true;
                }
                case "--verbose": 
                case "--log-verbose": 
                case "--log-finest": 
                case "--log-finer": 
                case "--log-fine": 
                case "--log-info": 
                case "--log-warning": 
                case "--log-severe": 
                case "--log-config": 
                case "--log-all": 
                case "--log-off": 
                case "--log-term-verbose": 
                case "--log-term-finest": 
                case "--log-term-finer": 
                case "--log-term-fine": 
                case "--log-term-info": 
                case "--log-term-warning": 
                case "--log-term-severe": 
                case "--log-term-config": 
                case "--log-term-all": 
                case "--log-term-off": 
                case "--log-file-verbose": 
                case "--log-file-finest": 
                case "--log-file-finer": 
                case "--log-file-fine": 
                case "--log-file-info": 
                case "--log-file-warning": 
                case "--log-file-severe": 
                case "--log-file-config": 
                case "--log-file-all": 
                case "--log-file-off": 
                case "--log-file-size": 
                case "--log-file-name": 
                case "--log-file-base": 
                case "--log-file-count": {
                    if (active) {
                        this.parseLogLevel(cmdLine, active);
                    }
                    return true;
                }
                case "-?": 
                case "-h": 
                case "--help": {
                    boolean enabled = a.isUncommented();
                    cmdLine.skip();
                    if (enabled) {
                        if (cmdLine.isExecMode()) {
                            NApp.of().printHelp();
                        }
                        cmdLine.skipAll();
                        throw new NExecutionException(NMsg.ofPlain("help"), 0);
                    }
                    return true;
                }
                case "--skip-event": {
                    boolean enabled = a.isUncommented();
                    switch (NApp.of().getMode()) {
                        case INSTALL: 
                        case UNINSTALL: 
                        case UPDATE: {
                            if (!enabled) break;
                            cmdLine.skip();
                            throw new NExecutionException(NMsg.ofPlain("skip-event"), 0);
                        }
                    }
                    return true;
                }
                case "--version": {
                    boolean enabled = a.isUncommented();
                    cmdLine.skip();
                    if (enabled) {
                        if (cmdLine.isExecMode()) {
                            this.out().println(NId.getForClass(this.getClass()).get().getVersion());
                            cmdLine.skipAll();
                        }
                        throw new NExecutionException(NMsg.ofPlain("version"), 0);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public NOptional<Boolean> getTrace() {
        return NOptional.ofNamed(this.trace, "trace").withDefault((Boolean)((Object)((Supplier<Boolean>)() -> NWorkspace.of().getBootOptions().getTrace().orElse(true))));
    }

    @Override
    public Boolean getTrace(boolean withDefaults) {
        if (!withDefaults) {
            return this.trace;
        }
        boolean b = this.isBot();
        if (b) {
            return false;
        }
        return this.trace != null ? this.trace : false;
    }

    @Override
    public boolean isTrace() {
        return this.getTrace(true);
    }

    @Override
    public NSession trace() {
        return this.setTrace(true);
    }

    @Override
    public NSession setTrace(Boolean trace) {
        this.trace = trace;
        return this;
    }

    @Override
    public boolean isPlainTrace() {
        return this.isTrace() && !this.isIterableOut() && this.getOutputFormat().orDefault() == NContentType.PLAIN;
    }

    @Override
    public boolean isIterableTrace() {
        return this.isTrace() && this.isIterableOut();
    }

    @Override
    public boolean isStructuredTrace() {
        return this.isTrace() && !this.isIterableOut() && (this.isBot() || this.getOutputFormat().orDefault() != NContentType.PLAIN);
    }

    @Override
    public boolean isIterableOut() {
        return this.iterableOut;
    }

    @Override
    public NSession setIterableOut(boolean iterableOut) {
        this.iterableOut = iterableOut;
        return this;
    }

    @Override
    public boolean isStructuredOut() {
        return !this.isIterableOut() && (this.isBot() || this.getOutputFormat().orDefault() != NContentType.PLAIN);
    }

    @Override
    public NArrayElementBuilder getElemOut() {
        return this.eout;
    }

    @Override
    public NSession setElemOut(NArrayElementBuilder eout) {
        this.eout = eout;
        return this;
    }

    @Override
    public boolean isPlainOut() {
        return !this.isBot() && this.getOutputFormat().orDefault() == NContentType.PLAIN;
    }

    @Override
    public NOptional<Boolean> getBot() {
        return NOptional.ofNamed(this.bot, "bot").withDefault((Boolean)((Object)((Supplier<Boolean>)() -> NWorkspace.of().getBootOptions().getBot().orElse(false))));
    }

    @Override
    public NOptional<Boolean> getPreviewRepo() {
        return NOptional.ofNamed(this.previewRepo, "previewRepo").withDefault((Boolean)((Object)((Supplier<Boolean>)() -> NWorkspace.of().getBootOptions().getPreviewRepo().orElse(NWorkspaceExt.of().getModel().configModel.getStoredConfigMain().isEnablePreviewRepositories()))));
    }

    @Override
    public boolean isPreviewRepo() {
        return this.getPreviewRepo().orDefault();
    }

    @Override
    public boolean isBot() {
        return this.getBot().orDefault();
    }

    @Override
    public NSession setBot(Boolean bot) {
        this.bot = bot;
        return this;
    }

    @Override
    public NSession setPreviewRepo(Boolean bot) {
        this.previewRepo = bot;
        return this;
    }

    @Override
    public NSession bot() {
        return this.setBot(true);
    }

    @Override
    public NSession yes() {
        return this.setConfirm(NConfirmationMode.YES);
    }

    @Override
    public NSession no() {
        return this.setConfirm(NConfirmationMode.NO);
    }

    @Override
    public NSession ask() {
        return this.setConfirm(NConfirmationMode.ASK);
    }

    @Override
    public boolean isYes() {
        return this.getConfirm().orDefault() == NConfirmationMode.YES;
    }

    @Override
    public boolean isNo() {
        return this.getConfirm().orDefault() == NConfirmationMode.NO;
    }

    @Override
    public boolean isAsk() {
        return this.getConfirm().orDefault() == NConfirmationMode.ASK;
    }

    @Override
    public NOptional<NContentType> getOutputFormat() {
        return NOptional.ofNamed(this.outputFormat, "outputFormat").withDefault((NContentType)((Object)((Supplier<NContentType>)() -> {
            NContentType o = NWorkspace.of().getBootOptions().getOutputFormat().orNull();
            if (o != null) {
                return o;
            }
            return NContentType.PLAIN;
        })));
    }

    @Override
    public NSession setOutputFormat(NContentType outputFormat) {
        if (outputFormat == null) {
            outputFormat = NContentType.PLAIN;
        }
        this.outputFormat = outputFormat;
        return this;
    }

    @Override
    public NSession json() {
        return this.setOutputFormat(NContentType.JSON);
    }

    @Override
    public NSession plain() {
        return this.setOutputFormat(NContentType.PLAIN);
    }

    @Override
    public NSession props() {
        return this.setOutputFormat(NContentType.PROPS);
    }

    @Override
    public NSession tree() {
        return this.setOutputFormat(NContentType.TREE);
    }

    @Override
    public NSession table() {
        return this.setOutputFormat(NContentType.TABLE);
    }

    @Override
    public NSession xml() {
        return this.setOutputFormat(NContentType.XML);
    }

    @Override
    public NSession copy() {
        try {
            DefaultNSession cloned = (DefaultNSession)this.clone();
            cloned.terminal = this.terminal == null ? null : NTerminal.of(this.terminal);
            cloned.properties = new NPropertiesHolder();
            for (String s : this.properties.keySet()) {
                NPropertiesHolder.NScopedPropertyValue v = this.properties.getScopedValue(s);
                switch (v.getScope()) {
                    case SHARED_SESSION: {
                        cloned.properties.setProperty(s, v.getValue(), NScopeType.SHARED_SESSION);
                        break;
                    }
                    case TRANSITIVE_SESSION: {
                        cloned.properties.setProperty(s, CoreNUtils.copyValue(v.getValue()), NScopeType.TRANSITIVE_SESSION);
                    }
                }
            }
            cloned.outputFormatOptions = this.outputFormatOptions == null ? null : new ArrayList<String>(this.outputFormatOptions);
            cloned.listeners = null;
            if (this.listeners != null) {
                for (NListener listener : this.getListeners()) {
                    cloned.addListener(listener);
                }
            }
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new NUnsupportedOperationException(NMsg.ofC("clone failed for type %s", this.getClass().getName()), (Throwable)e);
        }
    }

    @Override
    public NSession copyFrom(NSession other) {
        this.terminal = other.getTerminal() == null ? null : NTerminal.of(this.terminal);
        this.terminal = other.getTerminal();
        for (String s : ((DefaultNSession)other).properties.keySet()) {
            NPropertiesHolder.NScopedPropertyValue v = this.properties.getScopedValue(s);
            switch (v.getScope()) {
                case SHARED_SESSION: {
                    this.properties.setProperty(s, v.getValue(), NScopeType.SHARED_SESSION);
                    break;
                }
                case TRANSITIVE_SESSION: {
                    this.properties.setProperty(s, CoreNUtils.copyValue(v.getValue()), NScopeType.TRANSITIVE_SESSION);
                }
            }
        }
        this.listeners.clear();
        for (NListener listener : other.getListeners()) {
            this.addListener(listener);
        }
        this.trace = other.getTrace().orNull();
        this.confirm = other.getConfirm().orNull();
        this.dry = other.getDry().orNull();
        this.gui = other.getGui().orNull();
        this.bot = other.getBot().orNull();
        this.errLinePrefix = other.getErrLinePrefix();
        this.outLinePrefix = other.getOutLinePrefix();
        this.fetchStrategy = other.getFetchStrategy().orDefault();
        this.cached = other.getCached().orNull();
        this.indexed = other.getIndexed().orNull();
        this.transitive = other.getTransitive().orNull();
        this.outputFormat = other.getOutputFormat().orNull();
        this.iterableOut = other.isIterableOut();
        this.outputFormatOptions.clear();
        this.outputFormatOptions.addAll(other.getOutputFormatOptions());
        this.progressOptions = other.getProgressOptions();
        this.logTermLevel = other.getLogTermLevel();
        this.logFileLevel = other.getLogFileLevel();
        this.eout = other.eout();
        this.dependencySolver = other.getDependencySolver();
        return this;
    }

    @Override
    public NSession copyFrom(NWorkspaceOptions options) {
        if (options != null) {
            this.trace = options.getTrace().orElse(true);
            this.debug = options.getDebug().orNull();
            this.progressOptions = options.getProgressOptions().orNull();
            this.dry = options.getDry().orNull();
            this.cached = options.getCached().orNull();
            this.indexed = options.getIndexed().orNull();
            this.gui = options.getGui().orNull();
            this.confirm = options.getConfirm().orNull();
            this.errLinePrefix = options.getErrLinePrefix().orNull();
            this.outLinePrefix = options.getOutLinePrefix().orNull();
            this.fetchStrategy = options.getFetchStrategy().orNull();
            this.outputFormat = options.getOutputFormat().orNull();
            this.outputFormatOptions.clear();
            this.outputFormatOptions.addAll(options.getOutputFormatOptions().orElseGet(Collections::emptyList));
            NLogConfig logConfig = options.getLogConfig().orNull();
            if (logConfig != null) {
                this.logTermLevel = logConfig.getLogTermLevel();
                this.logFileLevel = logConfig.getLogFileLevel();
            }
            this.dependencySolver = options.getDependencySolver().orNull();
        }
        return this;
    }

    public NSession copyFrom(NBootOptions options) {
        if (options != null) {
            this.trace = options.getTrace().orElse(true);
            this.debug = options.getDebug().orNull();
            this.progressOptions = options.getProgressOptions().orNull();
            this.dry = options.getDry().orNull();
            this.cached = options.getCached().orNull();
            this.indexed = options.getIndexed().orNull();
            this.gui = options.getGui().orNull();
            this.confirm = options.getConfirm().orNull();
            this.errLinePrefix = options.getErrLinePrefix().orNull();
            this.outLinePrefix = options.getOutLinePrefix().orNull();
            this.fetchStrategy = options.getFetchStrategy().orNull();
            this.outputFormat = options.getOutputFormat().orNull();
            this.outputFormatOptions.clear();
            this.outputFormatOptions.addAll(options.getOutputFormatOptions().orElseGet(Collections::emptyList));
            NLogConfig logConfig = options.getLogConfig().orNull();
            if (logConfig != null) {
                this.logTermLevel = logConfig.getLogTermLevel();
                this.logFileLevel = logConfig.getLogFileLevel();
            }
            this.dependencySolver = options.getDependencySolver().orNull();
        }
        return this;
    }

    @Override
    public NOptional<NFetchStrategy> getFetchStrategy() {
        return NOptional.ofNamed(this.fetchStrategy, "fetchStrategy").withDefault((NFetchStrategy)((Object)((Supplier<NFetchStrategy>)() -> {
            NFetchStrategy wfetchStrategy = NWorkspace.of().getBootOptions().getFetchStrategy().orNull();
            if (wfetchStrategy != null) {
                return wfetchStrategy;
            }
            return NFetchStrategy.ONLINE;
        })));
    }

    @Override
    public NSession setFetchStrategy(NFetchStrategy mode) {
        this.fetchStrategy = mode;
        return this;
    }

    @Override
    public NSession addListener(NListener listener) {
        if (listener != null) {
            boolean ok = false;
            for (Class cls : new Class[]{NWorkspaceListener.class, NRepositoryListener.class, NInstallListener.class, NObservableMapListener.class}) {
                LinkedHashSet<NListener> li;
                if (!cls.isInstance(listener)) continue;
                if (this.listeners == null) {
                    this.listeners = new HashMap<Class, LinkedHashSet<NListener>>();
                }
                if ((li = this.listeners.get(cls)) == null) {
                    li = new LinkedHashSet();
                    this.listeners.put(cls, li);
                }
                li.add(listener);
                ok = true;
            }
            if (!ok) {
                throw new NIllegalArgumentException(NMsg.ofC("unsupported Listener %s : %s", listener.getClass().getName(), listener));
            }
        }
        return this;
    }

    @Override
    public NSession removeListener(NListener listener) {
        if (listener != null && this.listeners != null) {
            for (LinkedHashSet<NListener> value : this.listeners.values()) {
                value.remove(listener);
            }
        }
        return this;
    }

    @Override
    public <T extends NListener> List<T> getListeners(Class<T> type) {
        LinkedHashSet<NListener> tt;
        if (this.listeners != null && (tt = this.listeners.get(type)) != null) {
            return new ArrayList<NListener>(tt);
        }
        return Collections.emptyList();
    }

    @Override
    public List<NListener> getListeners() {
        if (this.listeners == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<NListener> all = new LinkedHashSet<NListener>();
        for (LinkedHashSet<NListener> value : this.listeners.values()) {
            all.addAll(value);
        }
        return new ArrayList<NListener>(all);
    }

    public NPropertiesHolder getPropertiesHolder() {
        return this.properties;
    }

    @Override
    public NOptional<NConfirmationMode> getConfirm() {
        return NOptional.ofNamed(this.confirm, "confirm").withDefault((NConfirmationMode)((Object)((Supplier<NConfirmationMode>)() -> {
            NConfirmationMode cm = NWorkspace.of().getBootOptions().getConfirm().orNull();
            if (this.isBot()) {
                if (cm == null) {
                    return NConfirmationMode.ERROR;
                }
                switch (cm) {
                    case ASK: {
                        return NConfirmationMode.ERROR;
                    }
                }
                return cm;
            }
            return cm == null ? NConfirmationMode.ASK : cm;
        })));
    }

    @Override
    public NSession setConfirm(NConfirmationMode confirm) {
        this.confirm = confirm;
        return this;
    }

    @Override
    public NSession addOutputFormatOptions(String ... options) {
        if (options != null) {
            for (String option : options) {
                if (NBlankable.isBlank(option)) continue;
                this.outputFormatOptions.add(option);
            }
        }
        return this;
    }

    @Override
    public List<String> getOutputFormatOptions() {
        return this.outputFormatOptions;
    }

    @Override
    public NSession setOutputFormatOptions(String ... options) {
        this.outputFormatOptions.clear();
        return this.addOutputFormatOptions(options);
    }

    @Override
    public NSession setOutputFormatOptions(List<String> options) {
        this.outputFormatOptions.clear();
        return this.addOutputFormatOptions(options.toArray(new String[0]));
    }

    @Override
    public NPrintStream out() {
        return this.terminal == null ? null : this.terminal.out();
    }

    @Override
    public InputStream in() {
        return this.terminal == null ? null : this.terminal.in();
    }

    @Override
    public NPrintStream err() {
        return this.terminal == null ? null : this.terminal.err();
    }

    @Override
    public NIterableFormat getIterableOutput() {
        if (!this.iterableOut) {
            return null;
        }
        return NElementFormat.of().setContentType(this.getOutputFormat().orDefault()).iter(this.out());
    }

    @Override
    public NTerminal getTerminal() {
        return this.terminal;
    }

    @Override
    public NSession setTerminal(NTerminal terminal) {
        this.terminal = terminal;
        if (terminal != null) {
            AbstractNTerminal a = (AbstractNTerminal)terminal;
            NPrintStream nPrintStream = a.getOut();
        }
        return this;
    }

    @Override
    public NWorkspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public NOptional<Boolean> getTransitive() {
        return NOptional.ofNamed(this.transitive, "transitive").withDefault((Boolean)((Object)((Supplier<Boolean>)() -> NWorkspace.of().getBootOptions().getTransitive().orElse(true))));
    }

    @Override
    public boolean isTransitive() {
        return this.getTransitive().orDefault();
    }

    @Override
    public NSession setTransitive(Boolean value) {
        this.transitive = value;
        return this;
    }

    @Override
    public NOptional<Boolean> getCached() {
        return NOptional.ofNamed(this.cached, "cached").withDefault((Boolean)((Object)((Supplier<Boolean>)() -> NWorkspace.of().getBootOptions().getCached().orElse(true))));
    }

    @Override
    public boolean isCached() {
        return this.getCached().orDefault();
    }

    @Override
    public NSession setCached(Boolean value) {
        this.cached = value;
        return this;
    }

    @Override
    public NOptional<Boolean> getIndexed() {
        return NOptional.ofNamed(this.indexed, "indexed").withDefault((Boolean)((Object)((Supplier<Boolean>)() -> NWorkspace.of().getBootOptions().getIndexed().orElse(false))));
    }

    @Override
    public boolean isIndexed() {
        return this.getIndexed().orDefault();
    }

    @Override
    public NSession setIndexed(Boolean value) {
        this.indexed = value;
        return this;
    }

    @Override
    public NOptional<Instant> getExpireTime() {
        return NOptional.ofNamed(this.expireTime, "expireTime");
    }

    @Override
    public NSession setExpireTime(Instant expireTime) {
        this.expireTime = expireTime;
        return this;
    }

    @Override
    public String getProgressOptions() {
        return this.progressOptions;
    }

    @Override
    public boolean isProgress() {
        if (!this.isPlainOut() || this.isBot()) {
            return false;
        }
        return this.callWith(() -> {
            NTerminalMode terminalMode = this.out().getTerminalMode();
            return ProgressOptions.of().getEnabled().orElse(terminalMode != NTerminalMode.FILTERED);
        });
    }

    @Override
    public NSession setProgressOptions(String progressOptions) {
        this.progressOptions = progressOptions;
        return this;
    }

    @Override
    public NOptional<Boolean> getGui() {
        return NOptional.ofNamed(this.gui, "gui").withDefault((Boolean)((Object)((Supplier<Boolean>)() -> {
            if (this.isBot()) {
                return false;
            }
            if (this.gui != null) {
                return this.gui;
            }
            return NWorkspace.of().getBootOptions().getGui().orElse(false);
        })));
    }

    @Override
    public boolean isGui() {
        return this.getGui().orDefault();
    }

    @Override
    public NSession setGui(Boolean gui) {
        this.gui = gui;
        return this;
    }

    @Override
    public String getErrLinePrefix() {
        return this.errLinePrefix;
    }

    @Override
    public NSession setErrLinePrefix(String errLinePrefix) {
        this.errLinePrefix = errLinePrefix;
        return this;
    }

    @Override
    public String getOutLinePrefix() {
        return this.outLinePrefix;
    }

    @Override
    public NSession setOutLinePrefix(String outLinePrefix) {
        this.outLinePrefix = outLinePrefix;
        return this;
    }

    @Override
    public NOptional<Boolean> getDry() {
        return NOptional.ofNamed(this.dry, "dry").withDefault((Boolean)((Object)((Supplier<Boolean>)() -> NWorkspace.of().getBootOptions().getDry().orElse(false))));
    }

    @Override
    public NOptional<Boolean> getShowStacktrace() {
        return NOptional.ofNamed(this.showStacktrace, "showStacktrace").withDefault((Boolean)((Object)((Supplier<Boolean>)() -> NWorkspace.of().getBootOptions().getShowStacktrace().orElse(false))));
    }

    @Override
    public boolean isDry() {
        return this.getDry().orDefault();
    }

    @Override
    public NSession setDry(Boolean dry) {
        this.dry = dry;
        return this;
    }

    @Override
    public NSession setShowStacktrace(Boolean showStacktrace) {
        this.showStacktrace = showStacktrace;
        return this;
    }

    @Override
    public Level getLogTermLevel() {
        return this.logTermLevel;
    }

    @Override
    public NSession setLogTermLevel(Level level) {
        this.logTermLevel = level;
        return this;
    }

    @Override
    public NSession configure(NWorkspaceOptions options) {
        if (options != null) {
            if (options.getCached().isPresent()) {
                this.setCached(options.getCached().orNull());
            }
            if (options.getConfirm().isPresent()) {
                this.setConfirm(options.getConfirm().orNull());
            }
            if (options.getDry().isPresent()) {
                this.setDry(options.getDry().orNull());
            }
            if (options.getOutputFormat().isPresent()) {
                this.setOutputFormat(options.getOutputFormat().orNull());
            }
            if (options.getOutputFormatOptions().isPresent()) {
                this.setOutputFormatOptions(options.getOutputFormatOptions().orElseGet(Collections::emptyList));
            }
            if (options.getErrLinePrefix().isPresent()) {
                this.setErrLinePrefix(options.getErrLinePrefix().orNull());
            }
            if (options.getFetchStrategy().isPresent()) {
                this.setFetchStrategy(options.getFetchStrategy().orNull());
            }
            if (options.getExpireTime().isPresent()) {
                this.setExpireTime(options.getExpireTime().orNull());
            }
            if (options.getGui().isPresent()) {
                this.setGui(options.getGui().orNull());
            }
            if (options.getProgressOptions().isPresent()) {
                this.setProgressOptions(options.getProgressOptions().orNull());
            }
            if (options.getIndexed().isPresent()) {
                this.setIndexed(options.getIndexed().orElse(true));
            }
            if (options.getTrace().isPresent()) {
                this.setTrace(options.getTrace().orElse(true));
            }
            if (options.getBot().isPresent()) {
                boolean wasBot = this.isBot();
                boolean becomesBot = options.getBot().orElse(false);
                this.setBot(becomesBot);
                if (becomesBot) {
                    if (this.getTerminal().out().getTerminalMode() != NTerminalMode.FILTERED) {
                        this.getTerminal().setOut(this.getTerminal().out().setTerminalMode(NTerminalMode.FILTERED));
                    }
                    if (this.getTerminal().err().getTerminalMode() != NTerminalMode.FILTERED) {
                        this.getTerminal().setErr(this.getTerminal().err().setTerminalMode(NTerminalMode.FILTERED));
                    }
                }
            }
            if (options.getTransitive().isPresent()) {
                this.setTransitive(options.getTransitive().orNull());
            }
            if (options.getTerminalMode().isPresent() && NTerminalMode.DEFAULT != options.getTerminalMode().orNull()) {
                this.getTerminal().setOut(this.getTerminal().getOut().setTerminalMode(options.getTerminalMode().orNull()));
            }
            if (options.getExecutionType().isPresent()) {
                this.setExecutionType(options.getExecutionType().orNull());
            }
            if (options.getDependencySolver().isPresent()) {
                this.setDependencySolver(options.getDependencySolver().orNull());
            }
        }
        return this;
    }

    @Override
    public Level getLogFileLevel() {
        return this.logFileLevel;
    }

    @Override
    public NSession setLogFileLevel(Level logFileLevel) {
        this.logFileLevel = logFileLevel;
        return this;
    }

    @Override
    public NArrayElementBuilder eout() {
        if (this.eout == null) {
            this.eout = new DefaultNArrayElementBuilder();
        }
        return this.eout;
    }

    @Override
    public NSession flush() {
        NArrayElementBuilder e = this.eout();
        if (e.size() > 0) {
            this.out().println(e.build());
            e.clear();
        }
        this.out().flush();
        return this;
    }

    @Override
    public NOptional<NExecutionType> getExecutionType() {
        return NOptional.ofNamed(this.executionType, "executionType").withDefault((NExecutionType)((Object)((Supplier<NExecutionType>)() -> NWorkspace.of().getBootOptions().getExecutionType().orElse(NExecutionType.SPAWN))));
    }

    @Override
    public NSession embedded() {
        return this.setExecutionType(NExecutionType.EMBEDDED);
    }

    @Override
    public NSession system() {
        return this.setExecutionType(NExecutionType.SYSTEM);
    }

    @Override
    public NSession spawn() {
        return this.setExecutionType(NExecutionType.SPAWN);
    }

    @Override
    public NSession setExecutionType(NExecutionType executionType) {
        this.executionType = executionType;
        return this;
    }

    @Override
    public NOptional<String> getDebug() {
        return NOptional.ofNamed(this.debug, "debug").withDefault((String)((Object)((Supplier<String>)() -> NWorkspace.of().getBootOptions().getDebug().orNull())));
    }

    @Override
    public NSession setDebug(String debug) {
        this.debug = debug;
        return this;
    }

    @Override
    public NOptional<String> getLocale() {
        return NOptional.ofNamed(this.locale, "locale").withDefault((String)((Object)((Supplier<String>)() -> NWorkspace.of().getBootOptions().getLocale().orNull())));
    }

    @Override
    public NSession setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    @Override
    public NOptional<NRunAs> getRunAs() {
        return NOptional.ofNamed(this.runAs, "runAs").withDefault((NRunAs)((Object)((Supplier<NRunAs>)() -> {
            NRunAs r = NWorkspace.of().getBootOptions().getRunAs().orNull();
            if (r != null) {
                return r;
            }
            return NRunAs.currentUser();
        })));
    }

    @Override
    public NSession setRunAs(NRunAs runAs) {
        this.runAs = runAs;
        return this;
    }

    @Override
    public NSession sudo() {
        return this.setRunAs(NRunAs.SUDO);
    }

    @Override
    public NSession root() {
        return this.setRunAs(NRunAs.ROOT);
    }

    @Override
    public NSession currentUser() {
        return this.setRunAs(NRunAs.CURRENT_USER);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NSession(");
        NWorkspace ws = this.getWorkspace();
        sb.append(ws == null ? "null" : ws.getLocation());
        if (this.properties.size() > 0) {
            sb.append(", properties=").append(this.properties);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getDependencySolver() {
        return this.dependencySolver;
    }

    @Override
    public NSession setDependencySolver(String dependencySolver) {
        this.dependencySolver = dependencySolver;
        return this;
    }

    private void parseLogLevel(NCmdLine cmdLine, boolean enabled) {
        NArg a = cmdLine.peek().get();
        switch (a.key()) {
            case "--log-file-verbose": 
            case "--log-file-finest": 
            case "--log-file-finer": 
            case "--log-file-fine": 
            case "--log-file-info": 
            case "--log-file-warning": 
            case "--log-file-config": 
            case "--log-file-severe": 
            case "--log-file-all": 
            case "--log-file-off": {
                cmdLine.skip();
                if (!enabled) break;
                String id = a.getKey().asString().get();
                this.setLogFileLevel(NLogUtils.parseLogLevel(id.substring("--log-file-".length())).ifEmpty(null).get());
                break;
            }
            case "--log-term-verbose": 
            case "--log-term-finest": 
            case "--log-term-finer": 
            case "--log-term-fine": 
            case "--log-term-info": 
            case "--log-term-warning": 
            case "--log-term-config": 
            case "--log-term-severe": 
            case "--log-term-all": 
            case "--log-term-off": {
                cmdLine.skip();
                if (!enabled) break;
                String id = a.getKey().asString().get();
                this.setLogTermLevel(NLogUtils.parseLogLevel(id.substring("--log-term-".length())).ifEmpty(null).get());
                break;
            }
            case "--verbose": {
                cmdLine.skip();
                if (!enabled || !a.getValue().asBoolean().orElse(true).booleanValue()) break;
                this.setLogTermLevel(Level.FINEST);
                this.setLogFileLevel(Level.FINEST);
                break;
            }
            case "--log-verbose": 
            case "--log-finest": 
            case "--log-finer": 
            case "--log-fine": 
            case "--log-info": 
            case "--log-warning": 
            case "--log-config": 
            case "--log-severe": 
            case "--log-all": 
            case "--log-off": {
                cmdLine.skip();
                if (!enabled) break;
                String id = a.getKey().asString().get();
                Level lvl = NLogUtils.parseLogLevel(id.substring("--log-".length())).ifEmpty(null).get();
                this.setLogTermLevel(lvl);
                this.setLogFileLevel(lvl);
            }
        }
    }

    @Override
    public boolean isLogTermLevel(Level level) {
        return level != null && this.logTermLevel != null && this.logTermLevel.intValue() <= level.intValue();
    }

    @Override
    public boolean isVerboseTerm() {
        return this.isLogTermLevel(Level.FINEST);
    }

    @Override
    public boolean isLogFileLevel(Level level) {
        return level != null && this.logFileLevel != null && this.logFileLevel.intValue() <= level.intValue();
    }

    @Override
    public boolean isVerboseFile() {
        return this.isLogFileLevel(Level.FINEST);
    }
}

