/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.security;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NErr;
import net.thevpc.nuts.runtime.standalone.security.NAuthenticationAgentProvider;
import net.thevpc.nuts.security.NAuthenticationAgent;
import net.thevpc.nuts.security.NSecurityException;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NStringUtils;

class WrapperNAuthenticationAgent {
    protected NWorkspace ws;
    protected NAuthenticationAgentProvider provider;
    protected Supplier<Map<String, String>> envProvider;
    private final Map<String, NAuthenticationAgent> cache = new HashMap<String, NAuthenticationAgent>();

    public WrapperNAuthenticationAgent(NWorkspace ws, Supplier<Map<String, String>> envProvider, NAuthenticationAgentProvider agentProvider) {
        this.envProvider = envProvider;
        this.provider = agentProvider;
        this.ws = ws;
    }

    public NAuthenticationAgent getCachedAuthenticationAgent(String name) {
        NAuthenticationAgent a = this.cache.get(name = NStringUtils.trim(name));
        if (a == null) {
            a = this.provider.create(name);
            this.cache.put(name, a);
            if (!a.getId().equals(name)) {
                this.cache.put(a.getId(), a);
            }
        }
        return a;
    }

    public boolean removeCredentials(char[] credentialsId) {
        return this.getCachedAuthenticationAgent(this.extractId(credentialsId)).removeCredentials(credentialsId, this.envProvider.get());
    }

    public void checkCredentials(char[] credentialsId, char[] password) {
        this.getCachedAuthenticationAgent(this.extractId(credentialsId)).checkCredentials(credentialsId, password, this.envProvider.get());
    }

    protected String extractId(char[] a) {
        String b = new String(a);
        int x = b.indexOf(58);
        if (x <= 0) {
            if (NWorkspace.of().getBootOptions().getRecover().orElse(false).booleanValue()) {
                NErr.println("```error RECOVER MODE : Password could no be parsed due a change in encryption spec. WIll use new default agent```");
                return null;
            }
            throw new NSecurityException(NMsg.ofPlain("credential id must start with authentication agent id"));
        }
        return b.substring(0, x);
    }

    public char[] getCredentials(char[] credentialsId) {
        return this.getCachedAuthenticationAgent(this.extractId(credentialsId)).getCredentials(credentialsId, this.envProvider.get());
    }

    public char[] createCredentials(char[] credentials, boolean allowRetrieve, char[] credentialId) {
        if (credentialId != null) {
            return this.getCachedAuthenticationAgent(this.extractId(credentialId)).createCredentials(credentials, allowRetrieve, credentialId, this.envProvider.get());
        }
        return this.getCachedAuthenticationAgent("").createCredentials(credentials, allowRetrieve, credentialId, this.envProvider.get());
    }
}

