/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.security;

import java.util.Arrays;
import java.util.Map;
import net.thevpc.nuts.security.NAuthenticationAgent;
import net.thevpc.nuts.security.NSecurityException;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NScorableContext;

@NComponentScope(value=NScopeType.WORKSPACE)
public class PlainNAuthenticationAgent
implements NAuthenticationAgent {
    @Override
    public String getId() {
        return "plain";
    }

    @Override
    public void checkCredentials(char[] credentialsId, char[] password, Map<String, String> envProvider) {
        if (password == null || NBlankable.isBlank(new String(password))) {
            throw new NSecurityException(NMsg.ofPlain("missing old password"));
        }
        char[] iid = this.extractId(credentialsId);
        if (Arrays.equals(iid, password)) {
            return;
        }
        throw new NSecurityException(NMsg.ofPlain("invalid login or password"));
    }

    @Override
    public char[] getCredentials(char[] credentialsId, Map<String, String> envProvider) {
        return this.extractId(credentialsId);
    }

    @Override
    public boolean removeCredentials(char[] credentialsId, Map<String, String> envProvider) {
        this.extractId(credentialsId);
        return true;
    }

    @Override
    public char[] createCredentials(char[] credentials, boolean allowRetrieve, char[] credentialId, Map<String, String> envProvider) {
        if (credentials == null || NBlankable.isBlank(new String(credentials))) {
            return null;
        }
        char[] val = credentials;
        String id = this.getId();
        char[] r = new char[id.length() + 1 + val.length];
        System.arraycopy(id.toCharArray(), 0, r, 0, id.length());
        r[id.length()] = 58;
        System.arraycopy(val, 0, r, id.length() + 1, val.length);
        return r;
    }

    @Override
    public int getScore(NScorableContext authenticationAgent) {
        return 9;
    }

    private char[] extractId(char[] a) {
        char[] idc;
        if (a != null && !NBlankable.isBlank(new String(a)) && a.length > (idc = (this.getId() + ":").toCharArray()).length + 1) {
            boolean ok = true;
            for (int i = 0; i < idc.length; ++i) {
                if (a[i] == idc[i]) continue;
                ok = false;
                break;
            }
            if (ok) {
                return Arrays.copyOfRange(a, idc.length, a.length);
            }
        }
        throw new NSecurityException(NMsg.ofC("credential id must start with '%s:'", this.getId()));
    }
}

