/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.logging.Level;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceEvent;
import net.thevpc.nuts.core.NWorkspaceListener;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.security.DefaultNLoginContext;
import net.thevpc.nuts.runtime.standalone.security.DefaultNUser;
import net.thevpc.nuts.runtime.standalone.security.NAuthorizations;
import net.thevpc.nuts.runtime.standalone.security.WrapperNAuthenticationAgent;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNWorkspaceConfigModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigSecurity;
import net.thevpc.nuts.runtime.standalone.xtra.digest.NDigestUtils;
import net.thevpc.nuts.security.NAddUserCmd;
import net.thevpc.nuts.security.NAuthenticationAgent;
import net.thevpc.nuts.security.NLoginException;
import net.thevpc.nuts.security.NRemoveUserCmd;
import net.thevpc.nuts.security.NSecurityException;
import net.thevpc.nuts.security.NUpdateUserCmd;
import net.thevpc.nuts.security.NUser;
import net.thevpc.nuts.security.NUserConfig;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNWorkspaceSecurityModel {
    private final ThreadLocal<Stack<DefaultNLoginContext>> loginContextStack = new ThreadLocal();
    private final DefaultNWorkspace workspace;
    private final WrapperNAuthenticationAgent agent;
    private final Map<String, NAuthorizations> authorizations = new HashMap<String, NAuthorizations>();
    private NLog LOG;

    public DefaultNWorkspaceSecurityModel(DefaultNWorkspace ws) {
        this.workspace = ws;
        this.agent = new WrapperNAuthenticationAgent(ws, () -> NWorkspace.of().getConfigMap(), x -> this.getAuthenticationAgent(x));
        this.workspace.addWorkspaceListener(new ClearAuthOnWorkspaceChange());
    }

    protected NLog _LOG() {
        return NLog.of(DefaultNWorkspaceSecurityModel.class);
    }

    public void login(String username, char[] password) {
        NUserConfig registeredUser = NWorkspaceExt.of().getConfigModel().getUser(username);
        if (registeredUser != null) {
            try {
                this.checkCredentials(registeredUser.getCredentials().toCharArray(), password);
                Stack<DefaultNLoginContext> r = this.loginContextStack.get();
                if (r == null) {
                    r = new Stack();
                }
                r.push(new DefaultNLoginContext(username));
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new NLoginException(NMsg.ofC("Authentication failed for %s", username));
    }

    public boolean setSecureMode(boolean secure, char[] adminPassword) {
        if (secure) {
            return this.switchSecureMode(adminPassword);
        }
        return this.switchUnsecureMode(adminPassword);
    }

    public boolean switchUnsecureMode(char[] adminPassword) {
        char[] credentials;
        NUser adminSecurity;
        if (adminPassword == null) {
            adminPassword = new char[]{};
        }
        if ((adminSecurity = this.findUser("admin")) == null || !adminSecurity.hasCredentials()) {
            if (this._LOG().isLoggable(Level.CONFIG)) {
                this._LOG().log(NMsg.ofC("%s user has no credentials. reset to default", "admin").asConfig().withIntent(NMsgIntent.ALERT));
            }
            NUserConfig u = NWorkspaceExt.of(this.workspace).getConfigModel().getUser("admin");
            u.setCredentials(CoreStringUtils.chrToStr(this.createCredentials("admin".toCharArray(), false, null)));
            NWorkspaceExt.of(this.workspace).getConfigModel().setUser(u);
        }
        if (Arrays.equals(credentials = NDigestUtils.evalSHA1(adminPassword), adminPassword)) {
            Arrays.fill(credentials, '\u0000');
            throw new NSecurityException(NMsg.ofPlain("invalid credentials"));
        }
        Arrays.fill(credentials, '\u0000');
        boolean activated = false;
        if (this.isSecure()) {
            NWorkspaceExt.of(this.workspace).getConfigModel().setSecure(false);
            activated = true;
        }
        return activated;
    }

    public boolean switchSecureMode(char[] adminPassword) {
        if (adminPassword == null) {
            adminPassword = new char[]{};
        }
        boolean deactivated = false;
        char[] credentials = NDigestUtils.evalSHA1(adminPassword);
        boolean passwordAccepted = Arrays.equals(credentials, adminPassword);
        Arrays.fill(credentials, '\u0000');
        if (!passwordAccepted) {
            throw new NSecurityException(NMsg.ofPlain("invalid credentials"));
        }
        DefaultNWorkspaceConfigModel configModel = NWorkspaceExt.of(this.workspace).getConfigModel();
        if (!configModel.isSecure()) {
            configModel.setSecure(true);
            deactivated = true;
        }
        return deactivated;
    }

    public boolean isAdmin() {
        return "admin".equals(this.getCurrentUsername());
    }

    public boolean isAnonymous() {
        return "anonymous".equals(this.getCurrentUsername());
    }

    public void logout() {
        Stack<DefaultNLoginContext> r = this.loginContextStack.get();
        if (r == null || r.isEmpty()) {
            throw new NLoginException(NMsg.ofPlain("not logged in"));
        }
        r.pop();
    }

    public NUser findUser(String username) {
        NUserConfig security = NWorkspaceExt.of(this.workspace).getConfigModel().getUser(username);
        Stack<String> inherited = new Stack<String>();
        if (security != null) {
            Stack<String> visited = new Stack<String>();
            visited.push(username);
            Stack<String> curr = new Stack<String>();
            curr.addAll(security.getGroups());
            while (!curr.empty()) {
                String s = (String)curr.pop();
                visited.add(s);
                NUserConfig ss = NWorkspaceExt.of(this.workspace).getConfigModel().getUser(s);
                if (ss == null) continue;
                inherited.addAll(ss.getPermissions());
                for (String group : ss.getGroups()) {
                    if (visited.contains(group)) continue;
                    curr.push(group);
                }
            }
        }
        return security == null ? null : new DefaultNUser(security, inherited);
    }

    public List<NUser> findUsers() {
        ArrayList<NUser> all = new ArrayList<NUser>();
        for (NUserConfig secu : NWorkspaceExt.of(this.workspace).getConfigModel().getUsers()) {
            all.add(this.findUser(secu.getUser()));
        }
        return all;
    }

    public NAddUserCmd addUser(String name) {
        return NAddUserCmd.of().setUsername(name);
    }

    public NUpdateUserCmd updateUser(String name) {
        return NUpdateUserCmd.of().setUsername(name);
    }

    public NRemoveUserCmd removeUser(String name) {
        return NRemoveUserCmd.of().setUsername(name);
    }

    public void checkAllowed(String permission, String operationName) {
        if (!this.isAllowed(permission)) {
            if (NBlankable.isBlank(operationName)) {
                throw new NSecurityException(NMsg.ofC("%s not allowed!", permission));
            }
            throw new NSecurityException(NMsg.ofC("%s : %s not allowed!", operationName, permission));
        }
    }

    private NAuthorizations getAuthorizations(String n) {
        NAuthorizations aa = this.authorizations.get(n);
        if (aa != null) {
            return aa;
        }
        NUserConfig s = NWorkspaceExt.of(this.workspace).getConfigModel().getUser(n);
        if (s != null) {
            List<String> rr = s.getPermissions();
            aa = new NAuthorizations(NCollections.nonNullList(rr));
            this.authorizations.put(n, aa);
        } else {
            aa = new NAuthorizations(Collections.emptyList());
        }
        return aa;
    }

    public boolean isAllowed(String permission) {
        if (!this.isSecure()) {
            return true;
        }
        String name = this.getCurrentUsername();
        if (NBlankable.isBlank(name)) {
            return false;
        }
        if ("admin".equals(name)) {
            return true;
        }
        Stack<String> items = new Stack<String>();
        HashSet<String> visitedGroups = new HashSet<String>();
        visitedGroups.add(name);
        items.push(name);
        while (!items.isEmpty()) {
            String n = (String)items.pop();
            NAuthorizations s = this.getAuthorizations(n);
            Boolean ea = s.explicitAccept(permission);
            if (ea != null) {
                return ea;
            }
            NUserConfig uc = NWorkspaceExt.of(this.workspace).getConfigModel().getUser(n);
            if (uc == null) continue;
            for (String g : uc.getGroups()) {
                if (visitedGroups.contains(g)) continue;
                visitedGroups.add(g);
                items.push(g);
            }
        }
        return false;
    }

    public String[] getCurrentLoginStack() {
        ArrayList<String> logins = new ArrayList<String>();
        Stack<DefaultNLoginContext> c = this.loginContextStack.get();
        if (c != null) {
            for (DefaultNLoginContext loginContext : c) {
                logins.add(loginContext.getUserName());
            }
        }
        if (logins.isEmpty()) {
            if (this.isInitializing()) {
                logins.add("admin");
            } else {
                logins.add("anonymous");
            }
        }
        return logins.toArray(new String[0]);
    }

    private boolean isInitializing() {
        return this.workspace.getModel().bootModel.isInitializing();
    }

    public String getCurrentUsername() {
        if (this.isInitializing()) {
            return "admin";
        }
        Object name = null;
        DefaultNLoginContext currentSubject = this.getLoginContext();
        if (currentSubject != null) {
            return currentSubject.getUserName();
        }
        return "anonymous";
    }

    private DefaultNLoginContext getLoginContext() {
        Stack<DefaultNLoginContext> c = this.loginContextStack.get();
        if (c == null) {
            return null;
        }
        if (c.isEmpty()) {
            return null;
        }
        return c.peek();
    }

    public NAuthenticationAgent getAuthenticationAgent(String authenticationAgentId) {
        if (NBlankable.isBlank(authenticationAgentId = NStringUtils.trim(authenticationAgentId))) {
            authenticationAgentId = this.workspace.getConfigModel().getStoredConfigSecurity().getAuthenticationAgent();
        }
        NAuthenticationAgent a = this.workspace.getConfigModel().createAuthenticationAgent(authenticationAgentId);
        return a;
    }

    public void setAuthenticationAgent(String authenticationAgentId) {
        DefaultNWorkspaceConfigModel cc = NWorkspaceExt.of(this.workspace).getConfigModel();
        if (cc.createAuthenticationAgent(authenticationAgentId) == null) {
            throw new NIllegalArgumentException(NMsg.ofC("unsupported Authentication Agent %s", authenticationAgentId));
        }
        NWorkspaceConfigSecurity conf = cc.getStoredConfigSecurity();
        if (!Objects.equals(conf.getAuthenticationAgent(), authenticationAgentId)) {
            conf.setAuthenticationAgent(authenticationAgentId);
            cc.fireConfigurationChanged("authentication-agent", ConfigEventType.SECURITY);
        }
    }

    public boolean isSecure() {
        return NWorkspaceExt.of(this.workspace).getConfigModel().getStoredConfigSecurity().isSecure();
    }

    public void checkCredentials(char[] credentialsId, char[] password) throws NSecurityException {
        this.agent.checkCredentials(credentialsId, password);
    }

    public char[] getCredentials(char[] credentialsId) {
        return this.agent.getCredentials(credentialsId);
    }

    public boolean removeCredentials(char[] credentialsId) {
        return this.agent.removeCredentials(credentialsId);
    }

    public char[] createCredentials(char[] credentials, boolean allowRetrieve, char[] credentialId) {
        return this.agent.createCredentials(credentials, allowRetrieve, credentialId);
    }

    public NWorkspace getWorkspace() {
        return this.workspace;
    }

    private class ClearAuthOnWorkspaceChange
    implements NWorkspaceListener {
        @Override
        public void onConfigurationChanged(NWorkspaceEvent event) {
            DefaultNWorkspaceSecurityModel.this.authorizations.clear();
        }
    }
}

