/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.security;

import java.util.List;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.security.DefaultNWorkspaceSecurityModel;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.security.NAddUserCmd;
import net.thevpc.nuts.security.NAuthenticationAgent;
import net.thevpc.nuts.security.NRemoveUserCmd;
import net.thevpc.nuts.security.NSecurityException;
import net.thevpc.nuts.security.NUpdateUserCmd;
import net.thevpc.nuts.security.NUser;
import net.thevpc.nuts.security.NWorkspaceSecurityManager;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.util.NScorableContext;

@NComponentScope(value=NScopeType.WORKSPACE)
public class DefaultNWorkspaceSecurityManager
implements NWorkspaceSecurityManager {
    public final DefaultNWorkspaceSecurityModel model;
    public NWorkspace workspace;

    public DefaultNWorkspaceSecurityManager(NWorkspace workspace) {
        this.workspace = workspace;
        NWorkspaceExt e = (NWorkspaceExt)((Object)workspace);
        this.model = e.getModel().securityModel;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public NWorkspaceSecurityManager login(String username, char[] password) {
        this.model.login(username, password);
        return this;
    }

    @Override
    public boolean setSecureMode(boolean secure, char[] adminPassword) {
        return this.model.setSecureMode(secure, adminPassword);
    }

    public boolean switchUnsecureMode(char[] adminPassword) {
        return this.model.switchUnsecureMode(adminPassword);
    }

    public boolean switchSecureMode(char[] adminPassword) {
        return this.model.switchSecureMode(adminPassword);
    }

    @Override
    public boolean isAdmin() {
        return this.model.isAdmin();
    }

    @Override
    public boolean isAnonymous() {
        return this.model.isAnonymous();
    }

    @Override
    public NWorkspaceSecurityManager logout() {
        this.model.logout();
        return this;
    }

    @Override
    public NUser findUser(String username) {
        return this.model.findUser(username);
    }

    @Override
    public List<NUser> findUsers() {
        return this.model.findUsers();
    }

    @Override
    public NAddUserCmd addUser(String name) {
        return this.model.addUser(name);
    }

    @Override
    public NUpdateUserCmd updateUser(String name) {
        return this.model.updateUser(name);
    }

    @Override
    public NRemoveUserCmd removeUser(String name) {
        return this.model.removeUser(name);
    }

    @Override
    public NWorkspaceSecurityManager checkAllowed(String permission, String operationName) {
        this.model.checkAllowed(permission, operationName);
        return this;
    }

    @Override
    public boolean isAllowed(String permission) {
        return this.model.isAllowed(permission);
    }

    @Override
    public String[] getCurrentLoginStack() {
        return this.model.getCurrentLoginStack();
    }

    @Override
    public String getCurrentUsername() {
        return this.model.getCurrentUsername();
    }

    @Override
    public NAuthenticationAgent getAuthenticationAgent(String authenticationAgentId) {
        return this.model.getAuthenticationAgent(authenticationAgentId);
    }

    @Override
    public NWorkspaceSecurityManager setAuthenticationAgent(String authenticationAgentId) {
        this.model.setAuthenticationAgent(authenticationAgentId);
        return this;
    }

    @Override
    public boolean isSecureMode() {
        return this.model.isSecure();
    }

    @Override
    public NWorkspaceSecurityManager checkCredentials(char[] credentialsId, char[] password) throws NSecurityException {
        this.model.checkCredentials(credentialsId, password);
        return this;
    }

    @Override
    public char[] getCredentials(char[] credentialsId) {
        return this.model.getCredentials(credentialsId);
    }

    @Override
    public boolean removeCredentials(char[] credentialsId) {
        return this.model.removeCredentials(credentialsId);
    }

    @Override
    public char[] createCredentials(char[] credentials, boolean allowRetrieve, char[] credentialId) {
        return this.model.createCredentials(credentials, allowRetrieve, credentialId);
    }
}

