/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryConfig;
import net.thevpc.nuts.core.NRepositoryEvent;
import net.thevpc.nuts.core.NRepositoryListener;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.repository.config.DefaultNRepoConfigManager;
import net.thevpc.nuts.runtime.standalone.security.DefaultNUser;
import net.thevpc.nuts.runtime.standalone.security.NAuthorizations;
import net.thevpc.nuts.runtime.standalone.security.WrapperNAuthenticationAgent;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.NRepositoryConfigManagerExt;
import net.thevpc.nuts.security.NAddUserCmd;
import net.thevpc.nuts.security.NAuthenticationAgent;
import net.thevpc.nuts.security.NRemoveUserCmd;
import net.thevpc.nuts.security.NSecurityException;
import net.thevpc.nuts.security.NUpdateUserCmd;
import net.thevpc.nuts.security.NUser;
import net.thevpc.nuts.security.NUserConfig;
import net.thevpc.nuts.security.NWorkspaceSecurityManager;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNRepositorySecurityModel {
    private final NRepository repository;
    private final WrapperNAuthenticationAgent agent;
    private final Map<String, NAuthorizations> authorizations = new HashMap<String, NAuthorizations>();

    public DefaultNRepositorySecurityModel(NRepository repo) {
        this.repository = repo;
        this.agent = new WrapperNAuthenticationAgent(repo.getWorkspace(), () -> repo.config().getConfigMap(), x -> this.getAuthenticationAgent(x));
        this.repository.addRepositoryListener(new NRepositoryListener(){

            @Override
            public void onConfigurationChanged(NRepositoryEvent event) {
                DefaultNRepositorySecurityModel.this.authorizations.clear();
            }
        });
    }

    public void checkAllowed(String right, String operationName) {
        if (!this.isAllowed(right)) {
            if (NBlankable.isBlank(operationName)) {
                throw new NSecurityException(NMsg.ofC("%s not allowed!", right));
            }
            throw new NSecurityException(NMsg.ofC("%s : %s not allowed!", operationName, right));
        }
    }

    public NAddUserCmd addUser(String name) {
        return NAddUserCmd.of().setRepository(this.repository).setUsername(name);
    }

    public NUpdateUserCmd updateUser(String name) {
        return NUpdateUserCmd.of().setRepository(this.repository).setUsername(name);
    }

    public NRemoveUserCmd removeUser(String name) {
        return NRemoveUserCmd.of().setRepository(this.repository).setUsername(name);
    }

    private NAuthorizations getAuthorizations(String n) {
        NAuthorizations aa = this.authorizations.get(n);
        if (aa != null) {
            return aa;
        }
        NUserConfig s = NRepositoryConfigManagerExt.of(this.repository.config()).getModel().findUser(n).orNull();
        if (s != null) {
            List<String> rr = s.getPermissions();
            aa = new NAuthorizations(NCollections.nonNullList(rr));
            this.authorizations.put(n, aa);
        } else {
            aa = new NAuthorizations(Collections.emptyList());
        }
        return aa;
    }

    public boolean isAllowed(String right) {
        NWorkspaceSecurityManager sec = NWorkspaceSecurityManager.of();
        if (!sec.isSecureMode()) {
            return true;
        }
        String name = sec.getCurrentUsername();
        if ("admin".equals(name)) {
            return true;
        }
        Stack<String> items = new Stack<String>();
        HashSet<String> visitedGroups = new HashSet<String>();
        visitedGroups.add(name);
        items.push(name);
        while (!items.isEmpty()) {
            String n = (String)items.pop();
            NAuthorizations s = this.getAuthorizations(n);
            Boolean ea = s.explicitAccept(right);
            if (ea != null) {
                return ea;
            }
            NUserConfig uc = NRepositoryConfigManagerExt.of(this.repository.config()).getModel().findUser(n).orNull();
            if (uc == null || uc.getGroups() == null) continue;
            for (String g : uc.getGroups()) {
                if (visitedGroups.contains(g)) continue;
                visitedGroups.add(g);
                items.push(g);
            }
        }
        return sec.isAllowed(right);
    }

    public List<NUser> findUsers() {
        ArrayList<NUser> all = new ArrayList<NUser>();
        for (NUserConfig secu : NRepositoryConfigManagerExt.of(this.repository.config()).getModel().findUsers()) {
            all.add(this.getEffectiveUser(secu.getUser()));
        }
        return all;
    }

    public NUser getEffectiveUser(String username) {
        NUserConfig u = NRepositoryConfigManagerExt.of(this.repository.config()).getModel().findUser(username).orNull();
        Stack<String> inherited = new Stack<String>();
        if (u != null) {
            Stack<String> visited = new Stack<String>();
            visited.push(username);
            Stack<String> curr = new Stack<String>();
            curr.addAll(u.getGroups());
            while (!curr.empty()) {
                String s = (String)curr.pop();
                visited.add(s);
                NUserConfig ss = NRepositoryConfigManagerExt.of(this.repository.config()).getModel().findUser(s).orNull();
                if (ss == null) continue;
                inherited.addAll(ss.getPermissions());
                for (String group : ss.getGroups()) {
                    if (visited.contains(group)) continue;
                    curr.push(group);
                }
            }
        }
        return u == null ? null : new DefaultNUser(u, inherited);
    }

    public NAuthenticationAgent getAuthenticationAgent(String id) {
        if ((id = NStringUtils.trim(id)).isEmpty()) {
            id = ((DefaultNRepoConfigManager)this.repository.config()).getModel().getStoredConfig().getAuthenticationAgent();
        }
        NAuthenticationAgent a = NWorkspaceExt.of(this.getWorkspace()).getConfigModel().createAuthenticationAgent(id);
        return a;
    }

    public void setAuthenticationAgent(String authenticationAgent) {
        DefaultNRepoConfigManager cc = (DefaultNRepoConfigManager)this.repository.config();
        if (NWorkspaceExt.of(this.getWorkspace()).getConfigModel().createAuthenticationAgent(authenticationAgent) == null) {
            throw new NIllegalArgumentException(NMsg.ofC("unsupported Authentication Agent %s", authenticationAgent));
        }
        NRepositoryConfig conf = cc.getModel().getStoredConfig();
        if (!Objects.equals(conf.getAuthenticationAgent(), authenticationAgent)) {
            conf.setAuthenticationAgent(authenticationAgent);
            cc.getModel().fireConfigurationChanged("authentication-agent");
        }
    }

    public void checkCredentials(char[] credentialsId, char[] password) throws NSecurityException {
        this.agent.checkCredentials(credentialsId, password);
    }

    public char[] getCredentials(char[] credentialsId) {
        return this.agent.getCredentials(credentialsId);
    }

    public boolean removeCredentials(char[] credentialsId) {
        return this.agent.removeCredentials(credentialsId);
    }

    public char[] createCredentials(char[] credentials, boolean allowRetrieve, char[] credentialId) {
        return this.agent.createCredentials(credentials, allowRetrieve, credentialId);
    }

    public NRepository getRepository() {
        return this.repository;
    }

    public NWorkspace getWorkspace() {
        return this.repository.getWorkspace();
    }
}

