/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.util;

import java.util.Objects;
import java.util.logging.Level;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NRepositoryConfig;
import net.thevpc.nuts.core.NRepositoryRef;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;

public class NRepositoryUtils {
    public static NRepositoryRef optionsToRef(NAddRepositoryOptions options) {
        return new NRepositoryRef().setEnabled(options.isEnabled()).setFailSafe(options.isFailSafe()).setName(options.getName()).setLocation(options.getLocation()).setDeployWeight(options.getDeployWeight());
    }

    public static NAddRepositoryOptions refToOptions(NRepositoryRef ref) {
        return new NAddRepositoryOptions().setEnabled(ref.isEnabled()).setFailSafe(ref.isFailSafe()).setName(ref.getName()).setLocation(ref.getLocation()).setDeployWeight(ref.getDeployWeight()).setTemporary(false);
    }

    public static NRepositoryLocation validateLocation(NRepositoryLocation r, NLog nLog) {
        if (NBlankable.isBlank(r.getLocationType()) && r.getFullLocation() != null) {
            NPath p;
            boolean fileExists;
            block13: {
                NPath r1 = NPath.of(r.getPath()).toAbsolute();
                if (!Objects.equals(r.getPath(), r1.toString())) {
                    r = r.setPath(r1.toString());
                }
                NPath r2 = r1.resolve(".nuts-repository");
                fileExists = false;
                try {
                    if (!r2.exists()) {
                        if (nLog != null) {
                            nLog.log(NMsg.ofC("unable to load %s", r2).withLevel(Level.CONFIG).withIntent(NMsgIntent.ALERT));
                        }
                    } else {
                        byte[] bytes = r2.readBytes();
                        if (bytes != null) {
                            String o;
                            fileExists = true;
                            NObjectElement jsonObject = NElementParser.ofJson().parse(bytes).asObject().get();
                            if (NBlankable.isBlank(r.getLocationType()) && !NBlankable.isBlank(o = jsonObject.getStringValue("repositoryType").orNull())) {
                                r = r.setLocationType(String.valueOf(o));
                            }
                            if (NBlankable.isBlank(r.getName()) && !NBlankable.isBlank(o = jsonObject.getStringValue("repositoryName").orNull())) {
                                r = r.setName(String.valueOf(o));
                            }
                            if (NBlankable.isBlank(r.getName())) {
                                r = r.setName(r.getName());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (nLog == null) break block13;
                    nLog.log(NMsg.ofC("unable to load %s", r2).withLevel(Level.CONFIG).withIntent(NMsgIntent.ALERT));
                }
            }
            if (fileExists && NBlankable.isBlank(r.getLocationType())) {
                r = r.setLocationType("nuts");
            }
            if (NBlankable.isBlank(r.getLocationType()) && (p = NPath.of(r.getPath())).isLocal() && (!p.exists() || p.isDirectory())) {
                r = r.setLocationType("nuts");
            }
        }
        return r;
    }

    public static String getRepoType(NRepositoryConfig conf) {
        NRepositoryLocation loc;
        if (conf != null && (loc = conf.getLocation()) != null && !NBlankable.isBlank((loc = NRepositoryUtils.validateLocation(loc, null)).getLocationType())) {
            return loc.getLocationType();
        }
        return null;
    }
}

