/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.toolbox;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryModel;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.repository.toolbox.ToolboxRepoHelper;
import net.thevpc.nuts.runtime.standalone.repository.toolbox.helpers.NetbeansRepoHelper;
import net.thevpc.nuts.runtime.standalone.repository.toolbox.helpers.TomcatRepoHelper;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBuilder;

public class ToolboxRepositoryModel
implements NRepositoryModel {
    private Map<String, ToolboxRepoHelper> mapByShortId = new HashMap<String, ToolboxRepoHelper>();
    private List<ToolboxRepoHelper> map = new ArrayList<ToolboxRepoHelper>();

    public ToolboxRepositoryModel() {
        this.register(new TomcatRepoHelper());
        this.register(new NetbeansRepoHelper());
    }

    private void register(ToolboxRepoHelper t) {
        this.map.add(t);
    }

    @Override
    public String getName() {
        return "toolbox";
    }

    @Override
    public String getUuid() {
        return UUID.nameUUIDFromBytes(this.getName().getBytes()).toString();
    }

    private ToolboxRepoHelper findByShortId(NId id) {
        NId shortId = id.getShortId();
        ToolboxRepoHelper old = this.mapByShortId.get(id.getShortName());
        if (old != null) {
            return old;
        }
        for (ToolboxRepoHelper h : this.map) {
            if (!h.acceptId(shortId)) continue;
            this.mapByShortId.put(id.getShortName(), h);
            return h;
        }
        return null;
    }

    @Override
    public NIterator<NId> searchVersions(NId id, NDefinitionFilter filter, NFetchMode fetchMode, NRepository repository) {
        if (fetchMode != NFetchMode.REMOTE) {
            return null;
        }
        ToolboxRepoHelper old = this.findByShortId(id);
        if (old != null) {
            return old.searchVersions(id, filter, repository);
        }
        return null;
    }

    @Override
    public NDescriptor fetchDescriptor(NId id, NFetchMode fetchMode, NRepository repository) {
        if (fetchMode != NFetchMode.REMOTE) {
            return null;
        }
        ToolboxRepoHelper old = this.findByShortId(id);
        if (old != null) {
            return old.fetchDescriptor(id, repository);
        }
        return null;
    }

    @Override
    public NPath fetchContent(NId id, NDescriptor descriptor, NFetchMode fetchMode, NRepository repository) {
        if (fetchMode != NFetchMode.REMOTE) {
            return null;
        }
        ToolboxRepoHelper old = this.findByShortId(id);
        if (old != null) {
            return old.fetchContent(id, descriptor, repository);
        }
        return null;
    }

    @Override
    public NIterator<NId> search(NDefinitionFilter filter, NPath[] basePaths, NFetchMode fetchMode, NRepository repository) {
        if (fetchMode != NFetchMode.REMOTE) {
            return NIterator.ofEmpty();
        }
        NIteratorBuilder<NId> b = NIteratorBuilder.emptyBuilder();
        for (ToolboxRepoHelper h : this.map) {
            b.concat(h.search(filter, basePaths, repository));
        }
        return b.build();
    }

    public static String getIdLocalFile(NId id, NRepository repository) {
        NWorkspace workspace = NWorkspace.of();
        return repository.config().getStoreLocation().resolve(workspace.getDefaultIdBasedir(id)).resolve(workspace.getDefaultIdFilename(id)).toString();
    }
}

