/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.definition.NDefinitionFilterUtils;

public class CommonRootsByPathHelper {
    private static Set<NPath> resolveRootIdAnd(Set<NPath> a, Set<NPath> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.isEmpty()) {
            return Collections.emptySet();
        }
        if (b.isEmpty()) {
            return Collections.emptySet();
        }
        NPath[] aa = a.toArray(new NPath[0]);
        NPath[] bb = b.toArray(new NPath[0]);
        HashSet<NPath> h = new HashSet<NPath>();
        for (NPath path : aa) {
            for (NPath nutsPath : bb) {
                h.add(CommonRootsByPathHelper.commonRoot(path, nutsPath));
            }
        }
        return CommonRootsByPathHelper.compact(h);
    }

    private static Set<NPath> compact(Set<NPath> a) {
        HashMap<String, NPath> x = new HashMap<String, NPath>();
        if (a != null) {
            for (NPath t : a) {
                String ts = CommonRootsByPathHelper.pathOf(t);
                NPath o = (NPath)x.get(ts);
                if (o != null && (CommonRootsByPathHelper.deepOf(o) || !CommonRootsByPathHelper.deepOf(t))) continue;
                x.put(ts, t);
            }
        }
        return new HashSet<NPath>(x.values());
    }

    private static boolean deepOf(NPath p) {
        return p.getName().equals("*");
    }

    private static String pathOf(NPath p) {
        if (p.getName().equals("*")) {
            p = p.getParent();
        }
        if (p == null) {
            return "";
        }
        return p.toString();
    }

    private static Set<NPath> resolveRootIdOr(Set<NPath> a, Set<NPath> b) {
        NPath o;
        String ts;
        HashMap<String, NPath> x = new HashMap<String, NPath>();
        if (a != null) {
            for (NPath t : a) {
                ts = CommonRootsByPathHelper.pathOf(t);
                o = (NPath)x.get(ts);
                if (o != null && (CommonRootsByPathHelper.deepOf(o) || !CommonRootsByPathHelper.deepOf(t))) continue;
                x.put(ts, t);
            }
        }
        if (b != null) {
            for (NPath t : b) {
                ts = CommonRootsByPathHelper.pathOf(t);
                o = (NPath)x.get(ts);
                if (o != null && (CommonRootsByPathHelper.deepOf(o) || !CommonRootsByPathHelper.deepOf(t))) continue;
                x.put(ts, t);
            }
        }
        return new HashSet<NPath>(x.values());
    }

    private static NPath commonRoot(NPath a, NPath b) {
        String b_path;
        boolean b_deep;
        String a_path;
        boolean a_deep;
        if (a.getName().equals("*")) {
            a_deep = true;
            a_path = a.getParent() == null ? "" : a.getParent().toString();
        } else {
            a_deep = false;
            a_path = a.toString();
        }
        if (b.getName().equals("*")) {
            b_deep = true;
            b_path = b.getParent() == null ? "" : b.getParent().toString();
        } else {
            b_deep = false;
            b_path = a.toString();
        }
        String[] aa = a_path.split("[.]");
        String[] bb = b_path.split("[.]");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Math.min(aa.length, bb.length); ++i) {
            if (!aa[i].equals(bb[i])) continue;
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(aa[i]);
        }
        if (a_deep || b_deep) {
            if (sb.length() > 0) {
                return NPath.of(sb.toString()).resolve("*");
            }
            return NPath.of("*");
        }
        return NPath.of(sb.toString());
    }

    private static Set<NPath> resolveRootId(String groupId, String artifactId, String version) {
        String g = groupId;
        if (g == null) {
            g = "";
        }
        if ((g = g.trim()).isEmpty() || g.equals("*")) {
            return new HashSet<NPath>(Collections.singletonList(NPath.of("*")));
        }
        int i = g.indexOf("*");
        if (i >= 0) {
            int j = (g = g.substring(0, i)).indexOf(".");
            if (j >= 0) {
                g = g.substring(0, j);
            }
            if (g.isEmpty()) {
                g = "*";
            } else {
                if (!(g = g.replace('.', '/')).endsWith("/")) {
                    g = g + "/";
                }
                g = g + "*";
            }
            return new HashSet<NPath>(Collections.singletonList(NPath.of(g)));
        }
        if (artifactId.length() > 0 && !artifactId.contains("*")) {
            if (!(version.length() <= 0 || version.contains("*") || version.contains("[") || version.contains("]"))) {
                return new HashSet<NPath>(Collections.singletonList(NPath.of(g.replace('.', '/') + "/" + artifactId + "/" + version)));
            }
            return new HashSet<NPath>(Collections.singletonList(NPath.of(g.replace('.', '/') + "/" + artifactId)));
        }
        return new HashSet<NPath>(Collections.singletonList(NPath.of(g.replace('.', '/'))));
    }

    public static List<NPath> resolveRootPaths(NDefinitionFilter filter) {
        return new ArrayList<NPath>(CommonRootsByPathHelper.resolveRootIds(filter));
    }

    public static Set<NPath> resolveRootIds(NDefinitionFilter filter) {
        Set<NPath> v = CommonRootsByPathHelper.resolveRootId0(filter);
        if (v == null) {
            HashSet<NPath> s = new HashSet<NPath>();
            s.add(NPath.of("*"));
            return s;
        }
        return v;
    }

    public static Set<NPath> resolveRootId0(NDefinitionFilter filter) {
        if (filter == null) {
            return null;
        }
        NDefinitionFilter[] aa = NDefinitionFilterUtils.toAndChildren(filter).orNull();
        if (aa != null) {
            Set<NPath> xx = null;
            for (NDefinitionFilter g : aa) {
                xx = CommonRootsByPathHelper.resolveRootIdAnd(xx, CommonRootsByPathHelper.resolveRootId0(g));
            }
            return xx;
        }
        aa = NDefinitionFilterUtils.toOrChildren(filter).orNull();
        if (aa != null) {
            if (aa.length == 0) {
                return null;
            }
            Set<NPath> xx = CommonRootsByPathHelper.resolveRootId0(aa[0]);
            for (int i = 1; i < aa.length; ++i) {
                xx = CommonRootsByPathHelper.resolveRootIdOr(xx, CommonRootsByPathHelper.resolveRootId0(aa[i]));
            }
            return xx;
        }
        NId pid = NDefinitionFilterUtils.toPatternId(filter).orNull();
        if (pid != null) {
            return CommonRootsByPathHelper.resolveRootId(pid.getGroupId(), pid.getArtifactId(), pid.getVersion().toString());
        }
        return null;
    }
}

