/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.runtime.standalone.definition.NDefinitionFilterUtils;

public class CommonRootsByIdHelper {
    private static Set<NId> resolveRootIdAnd(Set<NId> a, Set<NId> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.isEmpty()) {
            return Collections.emptySet();
        }
        if (b.isEmpty()) {
            return Collections.emptySet();
        }
        NId[] aa = a.toArray(new NId[0]);
        NId[] bb = b.toArray(new NId[0]);
        HashSet<NId> h = new HashSet<NId>();
        for (NId path : aa) {
            for (NId nutsPath : bb) {
                h.add(CommonRootsByIdHelper.commonRoot(path, nutsPath));
            }
        }
        return CommonRootsByIdHelper.compact(h);
    }

    private static Set<NId> compact(Set<NId> a) {
        HashMap<String, NId> x = new HashMap<String, NId>();
        if (a != null) {
            for (NId t : a) {
                String ts = CommonRootsByIdHelper.pathOf(t);
                NId o = (NId)x.get(ts);
                if (o != null && (CommonRootsByIdHelper.deepOf(o) || !CommonRootsByIdHelper.deepOf(t))) continue;
                x.put(ts, t);
            }
        }
        return new HashSet<NId>(x.values());
    }

    private static boolean deepOf(NId p) {
        String g = p.getGroupId();
        String a = p.getArtifactId();
        return g.contains("*") || a.contains("*");
    }

    private static String pathOf(NId p) {
        String a = p.getArtifactId();
        String g = p.getGroupId();
        if (a.equals("*")) {
            if (g.equals("*")) {
                return "*";
            }
            int x = g.lastIndexOf(46);
            if (x >= 0) {
                String pp = g.substring(0, x);
                if (pp.isEmpty()) {
                    return "*";
                }
                return pp;
            }
            return "*";
        }
        return g;
    }

    private static Set<NId> resolveRootIdOr(Set<NId> a, Set<NId> b) {
        NId o;
        String ts;
        HashMap<String, NId> x = new HashMap<String, NId>();
        if (a != null) {
            for (NId t : a) {
                ts = CommonRootsByIdHelper.pathOf(t);
                o = (NId)x.get(ts);
                if (o != null && (CommonRootsByIdHelper.deepOf(o) || !CommonRootsByIdHelper.deepOf(t))) continue;
                x.put(ts, t);
            }
        }
        if (b != null) {
            for (NId t : b) {
                ts = CommonRootsByIdHelper.pathOf(t);
                o = (NId)x.get(ts);
                if (o != null && (CommonRootsByIdHelper.deepOf(o) || !CommonRootsByIdHelper.deepOf(t))) continue;
                x.put(ts, t);
            }
        }
        return new HashSet<NId>(x.values());
    }

    private static NId commonRoot(NId a, NId b) {
        if (a.getShortName().equals(b.getShortName())) {
            return a;
        }
        String[] aa = a.getGroupId().split("[.]");
        String[] bb = b.getGroupId().split("[.]");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Math.min(aa.length, bb.length); ++i) {
            if (!aa[i].equals(bb[i])) continue;
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(aa[i]);
        }
        return NId.get(sb.toString() + ":*").get();
    }

    private static Set<NId> resolveRootId(String groupId, String artifactId, String version) {
        return new HashSet<NId>(Collections.singletonList(NIdBuilder.of().setGroupId(groupId).setArtifactId(artifactId).build()));
    }

    public static List<NId> resolveRootPaths(NDefinitionFilter filter) {
        return new ArrayList<NId>(CommonRootsByIdHelper.resolveRootIds(filter));
    }

    public static Set<NId> resolveRootIds(NDefinitionFilter filter) {
        Set<NId> v = CommonRootsByIdHelper.resolveRootId0(filter);
        if (v == null) {
            HashSet<NId> s = new HashSet<NId>();
            s.add(NId.BLANK);
            return s;
        }
        return v;
    }

    public static Set<NId> resolveRootId0(NDefinitionFilter filter) {
        if (filter == null) {
            return null;
        }
        NDefinitionFilter[] aa = NDefinitionFilterUtils.toAndChildren(filter).orNull();
        if (aa != null) {
            Set<NId> xx = null;
            for (NDefinitionFilter g : aa) {
                xx = CommonRootsByIdHelper.resolveRootIdAnd(xx, CommonRootsByIdHelper.resolveRootId0(g));
            }
            return xx;
        }
        aa = NDefinitionFilterUtils.toOrChildren(filter).orNull();
        if (aa != null) {
            if (aa.length == 0) {
                return null;
            }
            Set<NId> xx = CommonRootsByIdHelper.resolveRootId0(aa[0]);
            for (int i = 1; i < aa.length; ++i) {
                xx = CommonRootsByIdHelper.resolveRootIdOr(xx, CommonRootsByIdHelper.resolveRootId0(aa[i]));
            }
            return xx;
        }
        NId pid = NDefinitionFilterUtils.toPatternId(filter).orNull();
        if (pid != null) {
            return CommonRootsByIdHelper.resolveRootId(pid.getGroupId(), pid.getArtifactId(), pid.getVersion().toString());
        }
        return null;
    }
}

