/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.nuts;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.logging.Level;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorParser;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.command.NFetchModeNotSupportedException;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NSpeedQualifier;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.io.NCp;
import net.thevpc.nuts.io.NDigest;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.net.NWebCli;
import net.thevpc.nuts.runtime.standalone.definition.NDefinitionFilterUtils;
import net.thevpc.nuts.runtime.standalone.id.filter.NExprIdFilter;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.CoreSecurityUtils;
import net.thevpc.nuts.runtime.standalone.repository.impl.NCachedRepository;
import net.thevpc.nuts.runtime.standalone.repository.util.NIdLocationUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.NRepositoryConfigManagerExt;
import net.thevpc.nuts.runtime.standalone.xtra.digest.NDigestUtils;
import net.thevpc.nuts.security.NUser;
import net.thevpc.nuts.security.NUserConfig;
import net.thevpc.nuts.security.NWorkspaceSecurityManager;
import net.thevpc.nuts.spi.NPushRepositoryCmd;
import net.thevpc.nuts.text.NDescriptorFormat;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBase;
import net.thevpc.nuts.util.NIteratorBuilder;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NStringUtils;

public class NHttpSrvRepository
extends NCachedRepository {
    private NId remoteId;

    public NHttpSrvRepository(NAddRepositoryOptions options, NRepository parentRepository) {
        super(options, parentRepository, NSpeedQualifier.SLOW, false, "nuts", true);
        try {
            this.remoteId = this.getRemoteId();
        }
        catch (Exception ex) {
            this.LOG().log(NMsg.ofJ("unable to initialize Repository NutsId for repository {0}", options.getLocation()).withLevel(Level.WARNING).withIntent(NMsgIntent.FAIL));
        }
    }

    protected NLog LOG() {
        return NLog.of(NHttpSrvRepository.class);
    }

    public String getUrl(String path) {
        return this.config().getLocationPath().resolve(path).toString();
    }

    public NId getRemoteId() {
        if (this.remoteId == null) {
            try {
                this.remoteId = NId.get(this.httpGetString(this.getUrl("/version"))).get();
            }
            catch (Exception ex) {
                this.LOG().log(NMsg.ofJ("unable to resolve Repository NutsId for remote repository {0}", this.config().getLocation()).withLevel(Level.WARNING).withIntent(NMsgIntent.FAIL));
            }
        }
        return this.remoteId;
    }

    @Override
    public void pushImpl(NPushRepositoryCmd command) {
        NPath content = this.lib.fetchContentImpl(command.getId());
        NDescriptor desc = this.lib.fetchDescriptorImpl(command.getId());
        if (content == null || desc == null) {
            throw new NArtifactNotFoundException(command.getId());
        }
        ByteArrayOutputStream descStream = new ByteArrayOutputStream();
        NDescriptorFormat.of(desc).print(new OutputStreamWriter(descStream));
        NWebCli nWebCli = NWebCli.of();
        nWebCli.req().POST().setUrl(CoreIOUtils.buildUrl(this.config().getLocationPath().toString(), "/deploy?" + this.resolveAuthURLPart())).addPart("descriptor-hash", NDigest.of().sha1().setSource(desc).computeString()).addPart("content-hash", NDigestUtils.evalSHA1Hex(content)).addPart("force", NDigestUtils.evalSHA1Hex(content)).addPart().setName("descriptor").setFileName("Project.nuts").setBody(NInputSource.of(descStream.toByteArray())).end().run();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NDescriptor fetchDescriptorCore(NId id, NFetchMode fetchMode) {
        NSession session = this.getWorkspace().currentSession();
        if (fetchMode != NFetchMode.REMOTE) {
            throw new NArtifactNotFoundException(id, (Throwable)new NFetchModeNotSupportedException(this, fetchMode, id.toString(), null));
        }
        boolean transitive = session.isTransitive();
        session.getTerminal().printProgress(NMsg.ofC("loading descriptor for %s", id.getLongId()));
        try (InputStream stream = NPath.of(this.getUrl("/fetch-descriptor?id=" + CoreIOUtils.urlEncodeString(id.toString()) + (transitive ? "&transitive" : "") + "&" + this.resolveAuthURLPart())).getInputStream();){
            NDescriptor descriptor = NDescriptorParser.of().parse(stream).get();
            if (descriptor == null) return null;
            String hash = this.httpGetString(this.getUrl("/fetch-descriptor-hash?id=" + CoreIOUtils.urlEncodeString(id.toString()) + (transitive ? "&transitive" : "") + "&" + this.resolveAuthURLPart()));
            if (!hash.equals(descriptor.toString())) return null;
            NDescriptor nDescriptor = descriptor;
            return nDescriptor;
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public NIterator<NId> searchVersionsCore(NId id, NDefinitionFilter idFilter, NFetchMode fetchMode) {
        NSession session = this.getWorkspace().currentSession();
        if (fetchMode != NFetchMode.REMOTE) {
            throw new NArtifactNotFoundException(id, (Throwable)new NFetchModeNotSupportedException(this, fetchMode, id.toString(), null));
        }
        boolean transitive = session.isTransitive();
        InputStream ret = null;
        try {
            session.getTerminal().printProgress(NMsg.ofC("search version for %s", id.getLongId()));
            ret = NPath.of(this.getUrl("/find-versions?id=" + CoreIOUtils.urlEncodeString(id.toString()) + (transitive ? "&transitive" : "") + "&" + this.resolveAuthURLPart())).getInputStream();
        }
        catch (UncheckedIOException | NIOException e) {
            return NIteratorBuilder.emptyIterator();
        }
        NIterator<NId> it = new NamedNIdFromStreamIterator(ret);
        NDefinitionFilter filter2 = ((NDefinitionFilter)NDefinitionFilters.of().nonnull(idFilter)).and(NDefinitionFilters.of().byName(id.getShortName()));
        if (filter2 != null) {
            it = NIteratorBuilder.of(it).filter(NDefinitionFilterUtils.toIdPredicate(filter2)).iterator();
        }
        return it;
    }

    @Override
    public NIterator<NId> searchCore(NDefinitionFilter filter, NPath[] basePaths, NId[] baseIds, NFetchMode fetchMode) {
        if (fetchMode != NFetchMode.REMOTE) {
            return null;
        }
        NSession session = this.getWorkspace().currentSession();
        session.getTerminal().printProgress(NMsg.ofC("search into %s ", Arrays.toString(basePaths)));
        boolean transitive = session.isTransitive();
        InputStream ret = null;
        String[] ulp = this.resolveEncryptedAuth();
        if (filter instanceof NExprIdFilter) {
            String js = ((NExprIdFilter)((Object)filter)).toExpr();
            if (js != null) {
                NWebCli nWebCli = NWebCli.of();
                ret = nWebCli.req().POST().setUrl(this.getUrl("/find?" + (transitive ? "transitive" : "") + "&" + this.resolveAuthURLPart())).addPart("root", "/").addPart("ul", ulp[0]).addPart("up", ulp[1]).addPart("js").setFileName("search.js").setBody(NInputSource.of(js.getBytes())).end().run().getContent().getInputStream();
                return NIteratorBuilder.of(new NamedNIdFromStreamIterator(ret)).filter(NDefinitionFilterUtils.toIdPredicate(filter)).iterator();
            }
        } else {
            NWebCli nWebCli = NWebCli.of();
            ret = nWebCli.req().POST().setUrl(this.getUrl("/find?" + (transitive ? "transitive" : "") + "&" + this.resolveAuthURLPart())).addPart("root", "/").addPart("ul", ulp[0]).addPart("up", ulp[1]).addPart("pattern", "*").addPart("transitive", String.valueOf(transitive)).run().getContent().getInputStream();
        }
        if (filter == null) {
            return new NamedNIdFromStreamIterator(ret);
        }
        return NIteratorBuilder.of(new NamedNIdFromStreamIterator(ret)).filter(NDefinitionFilterUtils.toIdPredicate(filter)).iterator();
    }

    @Override
    public NPath fetchContentCore(NId id, NDescriptor descriptor, NFetchMode fetchMode) {
        NSession session = this.getWorkspace().currentSession();
        if (fetchMode != NFetchMode.REMOTE) {
            throw new NArtifactNotFoundException(id, (Throwable)new NFetchModeNotSupportedException(this, fetchMode, id.toString(), null));
        }
        NPath localPath = NIdLocationUtils.fetch(id, descriptor.getLocations(), this);
        if (localPath != null) {
            return localPath;
        }
        boolean transitive = session.isTransitive();
        try {
            localPath = NPath.ofTempRepositoryFile(new File(this.getIdFilename(id)).getName(), this);
            String location = this.getUrl("/fetch?id=" + CoreIOUtils.urlEncodeString(id.toString()) + (transitive ? "&transitive" : "") + "&" + this.resolveAuthURLPart());
            NCp.of().from(NPath.of(location)).to(localPath).addOptions(NPathOption.SAFE, NPathOption.LOG, NPathOption.TRACE).run();
            String rhash = this.httpGetString(this.getUrl("/fetch-hash?id=" + CoreIOUtils.urlEncodeString(id.toString()) + (transitive ? "&transitive" : "") + "&" + this.resolveAuthURLPart()));
            String lhash = NDigestUtils.evalSHA1Hex(localPath);
            if (rhash.equalsIgnoreCase(lhash)) {
                return localPath.setUserCache(false);
            }
        }
        catch (UncheckedIOException | NIOException ex) {
            throw new NArtifactNotFoundException(id, (Throwable)ex);
        }
        return null;
    }

    private String httpGetString(String url) {
        this.LOG().log(NMsg.ofJ("get URL{0}", url).withLevel(Level.FINEST).withIntent(NMsgIntent.START));
        return NIOUtils.loadString(NPath.of(url).getInputStream(), true);
    }

    @Override
    public String toString() {
        return super.toString() + (this.remoteId == null ? "" : " ; desc=" + this.remoteId);
    }

    private String[] resolveEncryptedAuth() {
        String login = NWorkspaceSecurityManager.of().getCurrentUsername();
        NUserConfig security = NRepositoryConfigManagerExt.of(this.config()).getModel().findUser(login).orNull();
        String newLogin = "";
        char[] credentials = new char[]{};
        if (security == null) {
            newLogin = "anonymous";
            credentials = "anonymous".toCharArray();
        } else {
            NUser security2;
            newLogin = security.getRemoteIdentity();
            if (NBlankable.isBlank(newLogin) && (security2 = NWorkspaceSecurityManager.of().findUser(login)) != null) {
                newLogin = security2.getRemoteIdentity();
            }
            if (NBlankable.isBlank(newLogin)) {
                newLogin = login;
            } else {
                security = NRepositoryConfigManagerExt.of(this.config()).getModel().findUser(newLogin).orNull();
                if (security == null) {
                    newLogin = "anonymous";
                    credentials = "anonymous".toCharArray();
                }
            }
            if (security != null) {
                credentials = security.getRemoteCredentials() == null ? null : security.getRemoteCredentials().toCharArray();
                credentials = NWorkspaceSecurityManager.of().getCredentials(credentials);
            }
        }
        String passphrase = this.config().getConfigProperty("passphrase").flatMap(NLiteral::asString).orElse(CoreSecurityUtils.DEFAULT_PASSPHRASE);
        newLogin = new String(CoreSecurityUtils.INSTANCE.defaultEncryptChars(NStringUtils.trim(newLogin).toCharArray(), passphrase));
        credentials = CoreSecurityUtils.INSTANCE.defaultEncryptChars(credentials, passphrase);
        return new String[]{newLogin, new String(credentials)};
    }

    private String resolveAuthURLPart() {
        String[] auth = this.resolveEncryptedAuth();
        return "ul=" + CoreIOUtils.urlEncodeString(auth[0]) + "&up=" + CoreIOUtils.urlEncodeString(auth[0]);
    }

    @Override
    public boolean isAcceptFetchMode(NFetchMode mode) {
        return true;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    private class NamedNIdFromStreamIterator
    extends NIteratorBase<NId> {
        private final BufferedReader br;
        private String line;
        private InputStream source0;

        public NamedNIdFromStreamIterator(InputStream ret) {
            this.br = new BufferedReader(new InputStreamReader(ret));
            this.line = null;
        }

        @Override
        public NElement describe() {
            return NElement.ofObjectBuilder().name("ScanArchetypeCatalog").set("source", this.source0.toString()).build();
        }

        @Override
        public boolean hasNext() {
            do {
                try {
                    this.line = this.br.readLine();
                }
                catch (IOException e) {
                    this.close();
                    return false;
                }
                if (this.line == null) {
                    this.close();
                    return false;
                }
                this.line = this.line.trim();
            } while (this.line.length() <= 0);
            return true;
        }

        private void close() {
            try {
                this.br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public NId next() {
            NId nutsId = NId.get(this.line).get();
            return nutsId.builder().setRepository(NHttpSrvRepository.this.getName()).build();
        }
    }
}

