/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.artifact.NVersionComparator;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.runtime.standalone.id.util.CoreNIdUtils;
import net.thevpc.nuts.runtime.standalone.repository.NIdPathIterator;
import net.thevpc.nuts.runtime.standalone.repository.NIdPathIteratorBase;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryExt;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenMetadata;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenMetadataParser;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenUtils;
import net.thevpc.nuts.runtime.standalone.xtra.digest.NDigestUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NStream;

public class MavenRepositoryFolderHelper {
    private NRepository repo;
    private NPath rootPath;

    public MavenRepositoryFolderHelper(NRepository repo, NPath rootPath) {
        this.repo = repo;
        this.rootPath = rootPath;
    }

    protected NLog _LOG() {
        return NLog.of(MavenRepositoryFolderHelper.class);
    }

    public NPath getIdLocalFile(NId id) {
        return this.getStoreLocation().resolve(NRepositoryExt.of(this.repo).getIdBasedir(id)).resolve(NWorkspace.of().getDefaultIdFilename(id));
    }

    public NPath fetchContentImpl(NId id, Path localPath) {
        NPath cacheContent = this.getIdLocalFile(id);
        if (cacheContent != null && cacheContent.exists()) {
            return cacheContent.setUserCache(true).setUserTemporary(false);
        }
        return null;
    }

    protected String getIdFilename(NId id) {
        if (this.repo == null) {
            return NWorkspace.of().getDefaultIdFilename(id);
        }
        return NRepositoryExt.of(this.repo).getIdFilename(id);
    }

    public NPath getLocalGroupAndArtifactFile(NId id) {
        CoreNIdUtils.checkShortId(id);
        return this.getStoreLocation().resolve(id.getShortId().getMavenFolder());
    }

    public Iterator<NId> searchVersions(NId id, NDefinitionFilter filter, boolean deep) {
        String singleVersion = id.getVersion().asSingleValue().orNull();
        if (singleVersion != null) {
            NId id1 = id.builder().setVersion(singleVersion).setFaceDescriptor().build();
            NPath localFile = this.getIdLocalFile(id1);
            if (localFile != null && localFile.isRegularFile()) {
                return Collections.singletonList(id.builder().setRepository(this.repo == null ? null : this.repo.getName()).build()).iterator();
            }
            return null;
        }
        return this.searchInFolder(this.getLocalGroupAndArtifactFile(id), filter, deep ? Integer.MAX_VALUE : 1);
    }

    public Iterator<NId> searchInFolder(NPath folder, NDefinitionFilter filter, int maxDepth) {
        return new NIdPathIterator(this.repo, this.rootPath.normalize(), folder, filter, new NIdPathIteratorBase(){

            @Override
            public NWorkspace getWorkspace() {
                return MavenRepositoryFolderHelper.this.repo.getWorkspace();
            }

            @Override
            public void undeploy(NId id) {
                throw new NIllegalArgumentException(NMsg.ofPlain("unsupported undeploy"));
            }

            @Override
            public boolean isDescFile(NPath pathname) {
                return pathname.getName().equals("pom.xml");
            }

            @Override
            public NDescriptor parseDescriptor(NPath pathname, InputStream in, NFetchMode fetchMode, NRepository repository, NPath rootURL) {
                return MavenUtils.of().parsePomXmlAndResolveParents(pathname, NFetchMode.LOCAL, MavenRepositoryFolderHelper.this.repo);
            }
        }, maxDepth, "core", null, true);
    }

    public NPath getStoreLocation() {
        return this.rootPath;
    }

    public NId searchLatestVersion(NId id, NDefinitionFilter filter) {
        NId bestId = null;
        NPath file = this.getLocalGroupAndArtifactFile(id);
        if (file.exists()) {
            NPath[] versionFolders;
            for (NPath versionFolder : versionFolders = (NPath[])((NStream)file.stream().filter(NPath::isDirectory).redescribe(NElementDescribables.ofDesc("isDirectory"))).toArray(NPath[]::new)) {
                NId id2 = id.builder().setVersion(versionFolder.getName()).build();
                if (bestId != null && id2.getVersion().compareTo(bestId.getVersion()) <= 0) continue;
                bestId = id2;
            }
        }
        return bestId;
    }

    public void reindexFolder() {
        this.reindexFolder(this.getStoreLocation(), true);
    }

    private void reindexFolder(final NPath path, final boolean applyRawNavigation) {
        try {
            Files.walkFileTree(path.toPath().get(), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    File folder = dir.toFile();
                    File[] children = folder.listFiles();
                    TreeSet<String> files = new TreeSet<String>();
                    TreeSet<String> folders = new TreeSet<String>();
                    String subPath = dir.toString().equals(path.toString()) ? "" : dir.toString().substring(path.toString().length() + 1).replace('\\', '/');
                    int iii = subPath.lastIndexOf(47);
                    String artifactId = null;
                    String groupId = null;
                    if (iii > 0) {
                        artifactId = subPath.substring(iii + 1);
                        groupId = subPath.substring(0, iii).replace('/', '.');
                    } else {
                        artifactId = subPath;
                        groupId = "";
                    }
                    if (children != null && children.length > 0) {
                        ArrayList<File> versions = new ArrayList<File>();
                        for (File c : children) {
                            File[] pomFiles = c.listFiles(x -> x.getName().endsWith(".pom"));
                            if (pomFiles == null || pomFiles.length <= 0) continue;
                            versions.add(c);
                        }
                        if (versions.size() > 0) {
                            Path metadataxml = dir.resolve("maven-metadata.xml");
                            MavenMetadata old = null;
                            try {
                                if (Files.exists(metadataxml, new LinkOption[0])) {
                                    old = new MavenMetadataParser().parseMavenMetaData(metadataxml);
                                }
                            }
                            catch (Exception ex) {
                                MavenRepositoryFolderHelper.this._LOG().log(NMsg.ofJ("failed to parse metadata xml for {0} : {1}", metadataxml, ex).asFinestFail(ex));
                            }
                            MavenMetadata m = new MavenMetadata();
                            m.setArtifactId(artifactId);
                            m.setGroupId(groupId);
                            m.setLastUpdated(old == null ? null : old.getLastUpdated());
                            m.setRelease(old == null ? null : old.getRelease());
                            m.setLatest(old == null ? null : old.getLatest());
                            LinkedHashSet<String> sversions = new LinkedHashSet<String>();
                            if (old != null) {
                                sversions.addAll(old.getVersions());
                            }
                            for (File version : versions) {
                                sversions.add(version.getName());
                            }
                            ArrayList<String> ll = new ArrayList<String>(sversions);
                            ll.sort(new Comparator<String>(){

                                @Override
                                public int compare(String o1, String o2) {
                                    return -NVersionComparator.ofMaven().compare(NVersion.of(o1), NVersion.of(o2));
                                }
                            });
                            m.setVersions(ll);
                            if (m.getLastUpdated() == null) {
                                m.setLastUpdated(new Date());
                            }
                            new MavenMetadataParser().writeMavenMetaData(m, metadataxml);
                            String md5 = NDigestUtils.evalMD5Hex(metadataxml).toLowerCase();
                            Files.write(metadataxml.resolveSibling("maven-metadata.xml.md5"), md5.getBytes(), new OpenOption[0]);
                            String sha1 = NDigestUtils.evalSHA1Hex(NPath.of(metadataxml)).toLowerCase();
                            Files.write(metadataxml.resolveSibling("maven-metadata.xml.sha1"), sha1.getBytes(), new OpenOption[0]);
                        }
                        if (applyRawNavigation) {
                            for (File child : children) {
                                if (child.getName().startsWith(".")) continue;
                                if (child.isDirectory()) {
                                    folders.add(child.getName());
                                    continue;
                                }
                                if (!child.isFile()) continue;
                                files.add(child.getName());
                            }
                        }
                    }
                    if (applyRawNavigation) {
                        try (PrintStream p = new PrintStream(new File(folder, ".files"));){
                            p.println("#version=" + NWorkspace.of().getApiVersion());
                            for (String file : folders) {
                                p.println(file + "/");
                            }
                            for (String file : files) {
                                p.println(file);
                            }
                        }
                        catch (FileNotFoundException e) {
                            throw new NIOException(e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }
}

