/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven.solrsearch;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.elem.NArrayElement;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.definition.NDefinitionHelper;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.MavenFolderRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.solrsearch.MavenSolrSearchRequest;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBuilder;
import net.thevpc.nuts.util.NIteratorUtils;
import net.thevpc.nuts.util.NLiteral;

public class MavenSolrSearchCommand {
    private MavenFolderRepository repo;

    public MavenSolrSearchCommand(MavenFolderRepository repo) {
        this.repo = repo;
    }

    public boolean isSolrSearchEnabled() {
        NPath solrSearchUrl = this.getSolrSearchUrl();
        String configProperty = (String)this.repo.config().getConfigProperty("maven.solrsearch.enable").flatMap(NLiteral::asString).orNull();
        return solrSearchUrl != null && NLiteral.of(configProperty).asBoolean().ifEmpty(true).orElse(false) != false;
    }

    public NIterator<NId> search(NDefinitionFilter filter, NId[] baseIds, NFetchMode fetchMode) {
        if (fetchMode == NFetchMode.REMOTE && this.isSolrSearchEnabled()) {
            boolean someCorrect = false;
            boolean someIncorrect = false;
            ArrayList list2 = new ArrayList();
            NPath solrSearchUrl = this.getSolrSearchUrl();
            for (NId baseId : baseIds) {
                MavenSolrSearchRequest r = new MavenSolrSearchRequest(baseId.getGroupId(), baseId.getArtifactId());
                Iterator<NId> ii = this.search(r, solrSearchUrl, filter);
                if (ii == null) {
                    return null;
                }
                list2.add((NIterator)ii);
                someCorrect = true;
            }
            if (someCorrect && !someIncorrect) {
                return NIteratorUtils.concat(list2);
            }
        }
        return null;
    }

    public NPath getSolrSearchUrl() {
        String a = (String)this.repo.config().getConfigProperty("maven.solrsearch.url").flatMap(NLiteral::asString).orNull();
        if (a != null) {
            return NPath.of(a);
        }
        return null;
    }

    public Iterator<NId> search(MavenSolrSearchRequest r, NPath url, NDefinitionFilter idFilter) {
        if (r != null) {
            Map<String, String> m;
            String urlString = url.toString();
            if (urlString.startsWith("htmlfs+")) {
                urlString = urlString.substring("htmlfs+".length());
            }
            if ((m = r.toQueryMap()) != null) {
                StringBuilder q2 = new StringBuilder(urlString).append("?");
                int index = 0;
                for (Map.Entry<String, String> entry : m.entrySet()) {
                    if (index > 0) {
                        q2.append("&");
                    }
                    try {
                        q2.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        return null;
                    }
                    ++index;
                }
                final NPath query = NPath.of(q2.toString());
                NIteratorBuilder<NId> it = NIteratorBuilder.ofSupplier(new Supplier<Iterator<NId>>(){

                    @Override
                    public Iterator<NId> get() {
                        return new Iterator<NId>(){
                            NArrayElement arr;
                            int index = 0;

                            @Override
                            public boolean hasNext() {
                                NObjectElement o;
                                String status;
                                NElement e;
                                if (this.arr == null && (e = NElementParser.ofJson().setLogProgress(true).parse(query)).isObject() && "0".equals(status = (o = e.asObject().get()).getByPath("responseHeader", "status").map(NElement::asLiteral).flatMap(NLiteral::asString).orElse(""))) {
                                    this.arr = o.getArrayByPath("response", "docs").orElse(NArrayElement.ofEmpty());
                                }
                                return this.index < this.arr.size();
                            }

                            @Override
                            public NId next() {
                                if (this.arr != null && this.index < this.arr.size()) {
                                    NObjectElement d = this.arr.getObject(this.index).get();
                                    String g = d.getStringValue("g").orElse("");
                                    String a = d.getStringValue("a").orElse("");
                                    String v = d.getStringValue("v").orElse("");
                                    ++this.index;
                                    return NIdBuilder.of(g, a).setVersion(v).build();
                                }
                                return null;
                            }
                        };
                    }
                }, () -> NElement.ofObjectBuilder().set("url", query.toString()).build());
                return it.filter(y -> idFilter == null || idFilter.acceptDefinition(NDefinitionHelper.ofIdOnlyFromRepo(y, this.repo, "MavenSolrSearchCommand")), () -> NElement.ofObjectBuilder().set("filterBy", (NElement)NElement.ofString(idFilter == null ? "true" : idFilter.toString())).build()).build();
            }
        }
        return null;
    }
}

