/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomDependenciesNode;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomDependency;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomDependencyNode;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomId;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.impl.DefaultNPomNode;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.impl.PomDependencyObj;
import net.thevpc.nuts.util.NBlankable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PomDependenciesObj
extends DefaultNPomNode<List<NPomDependencyNode>>
implements NPomDependenciesNode {
    public PomDependenciesObj(Element element, List<NPomDependencyNode> object, Document document) {
        super(element, object, document);
    }

    @Override
    public void removeDuplicates() {
        NPomDependencyNode[] pomDependencyObjs;
        LinkedHashMap<String, NPomDependencyNode> visited = new LinkedHashMap<String, NPomDependencyNode>();
        for (NPomDependencyNode dependencyAndElement : pomDependencyObjs = ((List)this.getObject()).toArray(new NPomDependencyNode[0])) {
            NPomDependency dependency = dependencyAndElement.getObject();
            NPomDependencyNode last = (NPomDependencyNode)visited.get(dependency.getShortName());
            if (last != null) {
                ((List)this.getObject()).remove(last);
            }
            visited.put(dependency.getShortName(), dependencyAndElement);
        }
    }

    @Override
    public void remove(NPomDependencyNode dependency) {
        for (NPomDependencyNode x : ((List)this.getObject()).toArray(new NPomDependencyNode[0])) {
            if (!Objects.equals(x, dependency)) continue;
            ((List)this.getObject()).remove(x);
            this.getXmlElement().removeChild(x.getXmlElement());
            return;
        }
    }

    @Override
    public void remove(NPomDependency dependency) {
        for (NPomDependencyNode x : ((List)this.getObject()).toArray(new NPomDependencyNode[0])) {
            if (!Objects.equals(x.getObject(), dependency)) continue;
            ((List)this.getObject()).remove(x);
            this.getXmlElement().removeChild(x.getXmlElement());
            return;
        }
    }

    @Override
    public void removeAllChildren(NPomDependencyNode dependency) {
        this.removeAllChildren(dependency.getObject());
    }

    @Override
    public void removeAllChildren(NPomDependency dependency) {
        for (NPomDependencyNode x : ((List)this.getObject()).toArray(new NPomDependencyNode[0])) {
            if (!Objects.equals(x.getObject(), dependency)) continue;
            ((List)this.getObject()).remove(x);
            this.getXmlElement().removeChild(x.getXmlElement());
        }
    }

    @Override
    public void appendChild(NPomDependency dependency) {
        Element d = this.getDocument().createElement("dependency");
        d.appendChild(this.createTextElement("groupId", dependency.getGroupId()));
        d.appendChild(this.createTextElement("artifactId", dependency.getArtifactId()));
        if (!NBlankable.isBlank(dependency.getVersion())) {
            d.appendChild(this.createTextElement("version", dependency.getVersion()));
        }
        if (!NBlankable.isBlank(dependency.getOptional())) {
            d.appendChild(this.createTextElement("optional", dependency.getOptional()));
        }
        if (!NBlankable.isBlank(dependency.getClassifier())) {
            d.appendChild(this.createTextElement("classifier", dependency.getClassifier()));
        }
        if (dependency.getExclusions().length > 0) {
            Element exclusions = this.getDocument().createElement("exclusions");
            for (NPomId exclusion : dependency.getExclusions()) {
                exclusions.appendChild(this.createTextElement("groupId", exclusion.getGroupId()));
                exclusions.appendChild(this.createTextElement("artifactId", exclusion.getArtifactId()));
                if (NBlankable.isBlank(exclusion.getVersion())) continue;
                exclusions.appendChild(this.createTextElement("version", exclusion.getVersion()));
            }
            d.appendChild(exclusions);
        }
        this.getXmlElement().appendChild(d);
        ((List)this.getObject()).add(new PomDependencyObj(d, dependency, this.getDocument()));
    }
}

