/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api;

import java.util.Arrays;
import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomId;
import net.thevpc.nuts.util.NBlankable;

public class NPomDependency {
    private String groupId;
    private String artifactId;
    private String version;
    private String scope;
    private String classifier;
    private String os;
    private String arch;
    private String optional;
    private String type;
    private NPomId[] exclusions;

    public NPomDependency(String groupId, String artifactId, String version) {
        this(groupId, artifactId, null, version, null, null, null, null, null, new NPomId[0]);
    }

    public NPomDependency(String groupId, String artifactId, String classifier, String version, String scope, String optional, String os, String arch, String type, NPomId[] exclusions) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.optional = optional;
        this.scope = scope;
        this.os = os;
        this.arch = arch;
        this.type = type;
        this.classifier = classifier;
        this.exclusions = exclusions;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean equalsShortName(NPomDependency other) {
        return other != null && Objects.equals(this.groupId, other.getGroupId()) && Objects.equals(this.artifactId, other.getArtifactId());
    }

    public boolean equalsLongName(NPomDependency other) {
        return other != null && Objects.equals(this.groupId, other.getGroupId()) && Objects.equals(this.artifactId, other.getArtifactId()) && Objects.equals(this.version, other.getVersion());
    }

    public String getShortName() {
        if (NBlankable.isBlank(this.groupId) && NBlankable.isBlank(this.artifactId)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (!NBlankable.isBlank(this.groupId)) {
            sb.append(this.groupId);
            sb.append(":");
        }
        sb.append(this.artifactId);
        return sb.toString();
    }

    public String getLongName() {
        if (NBlankable.isBlank(this.groupId) && NBlankable.isBlank(this.artifactId)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (!NBlankable.isBlank(this.groupId)) {
            sb.append(this.groupId);
            sb.append(":");
        }
        sb.append(this.artifactId);
        if (!NBlankable.isBlank(this.version)) {
            sb.append("#");
            sb.append(this.version);
        }
        return sb.toString();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getScope() {
        return this.scope;
    }

    public String getOptional() {
        return this.optional;
    }

    public NPomId[] getExclusions() {
        return this.exclusions;
    }

    public NPomDependency setClassifier(String classifier) {
        this.classifier = classifier;
        return this;
    }

    public NPomDependency setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public NPomDependency setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public NPomDependency setVersion(String version) {
        this.version = version;
        return this;
    }

    public NPomDependency setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public NPomDependency setOptional(String optional) {
        this.optional = optional;
        return this;
    }

    public NPomDependency setExclusions(NPomId[] exclusions) {
        this.exclusions = exclusions;
        return this;
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getArch() {
        return this.arch;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NPomDependency that = (NPomDependency)o;
        return Objects.equals(NPomDependency.toUniformGroupId(this.groupId), NPomDependency.toUniformGroupId(that.groupId)) && Objects.equals(NPomDependency.toUniformGroupId(this.artifactId), NPomDependency.toUniformGroupId(that.artifactId)) && Objects.equals(NPomDependency.toUniformGroupId(this.version), NPomDependency.toUniformGroupId(that.version)) && Objects.equals(NPomDependency.toUniformGroupId(this.os), NPomDependency.toUniformGroupId(that.os)) && Objects.equals(NPomDependency.toUniformGroupId(this.arch), NPomDependency.toUniformGroupId(that.arch)) && Objects.equals(NPomDependency.toUniformScope(this.scope), NPomDependency.toUniformScope(that.scope)) && Objects.equals(NPomDependency.toUniformOptional(this.optional), NPomDependency.toUniformOptional(that.optional)) && Arrays.equals(this.exclusions, that.exclusions);
    }

    private static String toUniformGroupId(String s) {
        return s == null ? "" : s.trim();
    }

    private static String toUniformScope(String s) {
        String string = s = s == null ? "" : s.trim().toLowerCase();
        if (s.isEmpty()) {
            return "compile";
        }
        return s;
    }

    private static String toUniformOptional(String s) {
        s = s == null ? "" : s.trim().toLowerCase();
        return s;
    }

    public int hashCode() {
        int result = Objects.hash(this.groupId, this.artifactId, this.version, this.scope, this.optional, this.os, this.arch);
        result = 31 * result + Arrays.hashCode(this.exclusions);
        return result;
    }

    public String toString() {
        return "PomDependency{groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ", scope='" + this.scope + '\'' + ", os='" + this.os + '\'' + ", arch='" + this.arch + '\'' + ", optional='" + this.optional + '\'' + ", type='" + this.type + '\'' + ", exclusions=" + Arrays.toString(this.exclusions) + '}';
    }
}

