/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamResult;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.expr.NParseException;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.format.xml.XmlUtils;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPom;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomContributor;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomDependenciesNode;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomDependency;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomDependencyNode;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomId;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomLicense;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomProfile;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomProfileActivation;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomProfileNode;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomProfilesNode;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomPropertiesNode;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomProperty;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomPropertyNode;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomRepositoriesNode;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomRepositoryNode;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomRepositoryPolicy;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.PomDomVisitor;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.PomDomVisitorContext;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.impl.DefaultPomDomVisitorContext;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.impl.PomDependenciesObj;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.impl.PomDependencyObj;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.impl.PomProfileObj;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.impl.PomProfilesObj;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.impl.PomPropertiesObj;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.impl.PomPropertyObj;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.impl.PomRepositoriesObj;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.impl.PomRepositoryObj;
import net.thevpc.nuts.runtime.standalone.util.XmlEscaper;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;
import net.thevpc.nuts.runtime.standalone.xtra.web.DefaultNWebCli;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NPomXmlParser {
    public static final Pattern NUTS_OS_ARCH_DEPS_PATTERN = Pattern.compile("^nuts([.](?<os>[a-zA-Z0-9-_]+)-os)?([.](?<arch>[a-zA-Z0-9-_]+)-arch)?-dependencies$");

    private static String elemToStr(Element ex) {
        return ex.getTextContent() == null ? "" : ex.getTextContent().trim();
    }

    private static List<Element> getElementChildren(Node profile) {
        NodeList childList = profile.getChildNodes();
        ArrayList<Element> a = new ArrayList<Element>();
        for (int k = 0; k < childList.getLength(); ++k) {
            Element c = NPomXmlParser.toElement(childList.item(k));
            if (c == null) continue;
            a.add(c);
        }
        return a;
    }

    private static List<Element> toElements(NodeList parentChildList) {
        ArrayList<Element> a = new ArrayList<Element>();
        for (int j = 0; j < parentChildList.getLength(); ++j) {
            Element parElem = NPomXmlParser.toElement(parentChildList.item(j));
            if (parElem == null) continue;
            a.add(parElem);
        }
        return a;
    }

    private static Element toElement(Node n) {
        if (n instanceof Element) {
            return (Element)n;
        }
        return null;
    }

    private static Element toElement(Node n, String name) {
        if (n instanceof Element && ((Element)n).getTagName().equals(name)) {
            return (Element)n;
        }
        return null;
    }

    public static NPomPropertyNode parseProperty(Element property, PomDomVisitor visitor, PomDomVisitorContext context) {
        if (visitor != null) {
            visitor.visitStartProperty(property, context);
        }
        NPomProperty p = new NPomProperty(property.getTagName(), NPomXmlParser.elemToStr(property));
        PomPropertyObj o = new PomPropertyObj(property, p, context.getDocument());
        if (visitor != null) {
            visitor.visitEndProperty(o, context);
        }
        return o;
    }

    public static NPomPropertiesNode parseProperties(Element properties, PomDomVisitor visitor, PomDomVisitorContext context, PomMode mode) {
        if (visitor != null && mode == PomMode.ROOT) {
            visitor.visitStartProperties(properties, context);
        }
        ArrayList<NPomPropertyNode> props = new ArrayList<NPomPropertyNode>();
        NodeList propsChildList = properties.getChildNodes();
        for (int j = 0; j < propsChildList.getLength(); ++j) {
            Element parElem = NPomXmlParser.toElement(propsChildList.item(j));
            if (parElem == null) continue;
            props.add(NPomXmlParser.parseProperty(parElem, visitor, context));
        }
        PomPropertiesObj o = new PomPropertiesObj(properties, (List<NPomPropertyNode>)props, context.getDocument());
        if (visitor != null && mode == PomMode.ROOT) {
            visitor.visitEndProperties(o, context);
        }
        return o;
    }

    public static NPomRepositoriesNode parseRepositories(Element elem1, PomDomVisitor visitor, PomDomVisitorContext context, PomMode mode) {
        ArrayList<NPomRepositoryNode> repositories = new ArrayList<NPomRepositoryNode>();
        if (visitor != null) {
            if (mode == PomMode.ROOT) {
                visitor.visitStartRepositories(elem1, context);
            } else if (mode == PomMode.ROOT_PLUGIN) {
                visitor.visitStartRepositories(elem1, context);
            }
        }
        NodeList dependenciesChildList = elem1.getChildNodes();
        String childName = "repository";
        if (mode == PomMode.ROOT_PLUGIN) {
            childName = "pluginRepository";
        }
        for (int j = 0; j < dependenciesChildList.getLength(); ++j) {
            Element repository = NPomXmlParser.toElement(dependenciesChildList.item(j), childName);
            if (repository == null) continue;
            NPomRepositoryNode repo = NPomXmlParser.parseRepository(repository, visitor, context, mode);
            repositories.add(repo);
        }
        PomRepositoriesObj d = new PomRepositoriesObj(elem1, (List<NPomRepositoryNode>)repositories, context.getDocument());
        if (visitor != null) {
            if (mode == PomMode.ROOT) {
                visitor.visitEndRepositories(d, context);
            } else if (mode == PomMode.ROOT_PLUGIN) {
                visitor.visitEndPluginRepositories(d, context);
            }
        }
        return d;
    }

    public static NPomDependenciesNode parseDependencies(Element elem1, PomDomVisitor visitor, PomDomVisitorContext context, OsAndArch osAndArch, PomMode mode) {
        ArrayList<NPomDependencyNode> dependencies = new ArrayList<NPomDependencyNode>();
        if (visitor != null) {
            if (mode == PomMode.ROOT) {
                visitor.visitStartDependencies(elem1, context);
            } else if (mode == PomMode.ROOT_DEPENDENCY_MANAGEMENT) {
                visitor.visitStartDependenciesManagement(elem1, context);
            }
        }
        NodeList dependenciesChildList = elem1.getChildNodes();
        for (int j = 0; j < dependenciesChildList.getLength(); ++j) {
            Element dependencyElem = NPomXmlParser.toElement(dependenciesChildList.item(j), "dependency");
            if (dependencyElem == null) continue;
            NPomDependencyNode dep = NPomXmlParser.parseDependency(dependencyElem, osAndArch, visitor, context, mode);
            dependencies.add(dep);
        }
        PomDependenciesObj d = new PomDependenciesObj(elem1, (List<NPomDependencyNode>)dependencies, context.getDocument());
        if (visitor != null) {
            if (mode == PomMode.ROOT) {
                visitor.visitEndDependencies(d, context);
            } else if (mode == PomMode.ROOT_DEPENDENCY_MANAGEMENT) {
                visitor.visitEndDependenciesManagement(d, context);
            }
        }
        return d;
    }

    public static NPomDependencyNode parseDependency(Element dependency, OsAndArch props, PomDomVisitor visitor, PomDomVisitorContext context, PomMode mode) {
        if (visitor != null && mode == PomMode.ROOT) {
            visitor.visitStartDependency(dependency, context);
        }
        NodeList dependencyChildList = dependency.getChildNodes();
        String d_groupId = "";
        String d_artifactId = "";
        String d_version = "";
        String d_classifier = "";
        String d_scope = "";
        String d_optional = "";
        String d_type = "";
        ArrayList<NPomId> d_exclusions = new ArrayList<NPomId>();
        block28: for (int k = 0; k < dependencyChildList.getLength(); ++k) {
            Element c = NPomXmlParser.toElement(dependencyChildList.item(k));
            if (c == null) continue;
            switch (c.getTagName()) {
                case "groupId": {
                    d_groupId = NPomXmlParser.elemToStr(c);
                    continue block28;
                }
                case "artifactId": {
                    d_artifactId = NPomXmlParser.elemToStr(c);
                    continue block28;
                }
                case "classifier": {
                    d_classifier = NPomXmlParser.elemToStr(c);
                    continue block28;
                }
                case "version": {
                    d_version = NPomXmlParser.elemToStr(c);
                    continue block28;
                }
                case "scope": {
                    d_scope = NPomXmlParser.elemToStr(c);
                    continue block28;
                }
                case "optional": {
                    d_optional = NPomXmlParser.elemToStr(c);
                    continue block28;
                }
                case "type": {
                    d_type = NPomXmlParser.elemToStr(c);
                    continue block28;
                }
                case "exclusions": {
                    NodeList exclusionsList = c.getChildNodes();
                    for (int l = 0; l < exclusionsList.getLength(); ++l) {
                        Element ex = NPomXmlParser.toElement(exclusionsList.item(l), "exclusion");
                        if (ex == null) continue;
                        String ex_groupId = "";
                        String ex_artifactId = "";
                        NodeList exclusionsList2 = ex.getChildNodes();
                        block30: for (int m = 0; m < exclusionsList2.getLength(); ++m) {
                            Element ex2 = NPomXmlParser.toElement(exclusionsList2.item(m));
                            if (ex2 == null) continue;
                            switch (ex2.getTagName()) {
                                case "groupId": {
                                    ex_groupId = NPomXmlParser.elemToStr(ex2);
                                    continue block30;
                                }
                                case "artifactId": {
                                    ex_artifactId = NPomXmlParser.elemToStr(ex2);
                                }
                            }
                        }
                        if (ex_groupId.isEmpty()) continue;
                        d_exclusions.add(new NPomId(ex_groupId, ex_artifactId, null));
                    }
                    continue block28;
                }
            }
        }
        if (d_scope.isEmpty()) {
            d_scope = "compile";
        }
        NId id = NIdBuilder.of(d_groupId, d_artifactId).build();
        NPomDependency pomDependency = new NPomDependency(d_groupId, d_artifactId, d_classifier, d_version, d_scope, d_optional, props == null ? null : props.getOs(id), props == null ? null : props.getArch(id), d_type, d_exclusions.toArray(new NPomId[0]));
        PomDependencyObj d = new PomDependencyObj(dependency, pomDependency, context.getDocument());
        if (visitor != null && mode == PomMode.ROOT) {
            visitor.visitEndDependency(d, context);
        }
        return d;
    }

    public static NPomRepositoryPolicy parseRepositoryPolicy(Element dependency) {
        NodeList childList = dependency.getChildNodes();
        String enabled = "";
        String updatePolicy = "";
        String checksumPolicy = "";
        block10: for (int k = 0; k < childList.getLength(); ++k) {
            Element c = NPomXmlParser.toElement(childList.item(k));
            if (c == null) continue;
            switch (c.getTagName()) {
                case "enabled": {
                    enabled = NPomXmlParser.elemToStr(c);
                    continue block10;
                }
                case "updatePolicy": {
                    updatePolicy = NPomXmlParser.elemToStr(c);
                    continue block10;
                }
                case "checksumPolicy": {
                    checksumPolicy = NPomXmlParser.elemToStr(c);
                }
            }
        }
        return new NPomRepositoryPolicy(enabled.isEmpty() || Boolean.parseBoolean(enabled), updatePolicy, checksumPolicy);
    }

    public static NPomProfileNode parseProfile(Element profile, PomDomVisitor visitor, PomDomVisitorContext context, OsAndArch osAndArch, PomMode mode) {
        if (visitor != null && mode == PomMode.ROOT) {
            visitor.visitStartProfile(profile, context);
        }
        NPomProfile pomProfile = new NPomProfile();
        ArrayList<NPomDependencyNode> dependencies = new ArrayList<NPomDependencyNode>();
        ArrayList<String> modules = new ArrayList<String>();
        ArrayList<NPomDependencyNode> dependenciesManagement = new ArrayList<NPomDependencyNode>();
        ArrayList<NPomRepositoryNode> repositories = new ArrayList<NPomRepositoryNode>();
        ArrayList<NPomRepositoryNode> pluginRepositories = new ArrayList<NPomRepositoryNode>();
        HashMap<String, String> properties = new HashMap<String, String>();
        block54: for (Element elem1 : NPomXmlParser.getElementChildren(profile)) {
            switch (elem1.getTagName()) {
                case "id": {
                    pomProfile.setId(NPomXmlParser.elemToStr(elem1));
                    break;
                }
                case "activation": {
                    NPomProfileActivation a = new NPomProfileActivation();
                    pomProfile.setActivation(a);
                    block55: for (Element cc : NPomXmlParser.getElementChildren(elem1)) {
                        switch (cc.getTagName()) {
                            case "jdk": {
                                a.setJdk(NPomXmlParser.elemToStr(cc));
                                break;
                            }
                            case "property": {
                                for (Element ccc : NPomXmlParser.getElementChildren(cc)) {
                                    switch (ccc.getTagName()) {
                                        case "name": {
                                            a.setPropertyName(NPomXmlParser.elemToStr(ccc));
                                            break;
                                        }
                                        case "value": {
                                            a.setPropertyValue(NPomXmlParser.elemToStr(ccc));
                                        }
                                    }
                                }
                                continue block55;
                            }
                            case "file": {
                                a.setFile(NPomXmlParser.elemToStr(cc));
                                break;
                            }
                            case "activeByDefault": {
                                String s = NStringUtils.trim(NPomXmlParser.elemToStr(cc));
                                a.setActiveByDefault(s.equalsIgnoreCase("true"));
                                break;
                            }
                            case "os": {
                                for (Element ccc : NPomXmlParser.getElementChildren(cc)) {
                                    switch (ccc.getTagName()) {
                                        case "name": {
                                            a.setOsName(NPomXmlParser.elemToStr(ccc));
                                            break;
                                        }
                                        case "arch": {
                                            a.setOsArch(NPomXmlParser.elemToStr(ccc));
                                            break;
                                        }
                                        case "version": {
                                            a.setOsVersion(NPomXmlParser.elemToStr(ccc));
                                            break;
                                        }
                                        case "family": {
                                            a.setOsFamily(NPomXmlParser.elemToStr(ccc));
                                        }
                                    }
                                }
                                break;
                            }
                        }
                    }
                    continue block54;
                }
                case "modules": {
                    NodeList childList = elem1.getChildNodes();
                    for (int j = 0; j < childList.getLength(); ++j) {
                        String s;
                        Element parElem = NPomXmlParser.toElement(childList.item(j), "module");
                        if (parElem == null || (s = NPomXmlParser.elemToStr(parElem)).isEmpty()) continue;
                        modules.add(s);
                    }
                    continue block54;
                }
                case "properties": {
                    for (NPomPropertyNode p : NPomXmlParser.parseProperties(elem1, visitor, context, PomMode.PROFILE).getObject()) {
                        properties.put(p.getObject().getName(), p.getObject().getValue());
                    }
                    continue block54;
                }
                case "dependencyManagement": {
                    NodeList dependenciesChildList = elem1.getChildNodes();
                    for (int j = 0; j < dependenciesChildList.getLength(); ++j) {
                        Element dependenciesElem = NPomXmlParser.toElement(dependenciesChildList.item(j), "dependencies");
                        if (dependenciesElem == null) continue;
                        dependenciesManagement.addAll(NPomXmlParser.parseDependencies(dependenciesElem, visitor, context, osAndArch, PomMode.PROFILE_DEPENDENCY_MANAGEMENT).getObject());
                    }
                    continue block54;
                }
                case "dependencies": {
                    dependencies.addAll(NPomXmlParser.parseDependencies(elem1, visitor, context, osAndArch, PomMode.PROFILE).getObject());
                    break;
                }
                case "repositories": {
                    repositories.addAll(NPomXmlParser.parseRepositories(elem1, visitor, context, PomMode.PROFILE).getObject());
                    break;
                }
                case "pluginRepositories": {
                    NodeList dependenciesChildList = elem1.getChildNodes();
                    for (int j = 0; j < dependenciesChildList.getLength(); ++j) {
                        Element repository = NPomXmlParser.toElement(dependenciesChildList.item(j), "pluginRepository");
                        if (repository == null) continue;
                        NPomRepositoryNode repo = NPomXmlParser.parseRepository(repository, visitor, context, mode);
                        pluginRepositories.add(repo);
                    }
                    continue block54;
                }
            }
        }
        pomProfile.setDependencies((NPomDependency[])dependencies.stream().map(x -> x.getObject()).toArray(NPomDependency[]::new));
        pomProfile.setDependenciesManagement((NPomDependency[])dependenciesManagement.stream().map(x -> x.getObject()).toArray(NPomDependency[]::new));
        pomProfile.setRepositories((NPomRepository[])repositories.stream().map(x -> x.getObject()).toArray(NPomRepository[]::new));
        pomProfile.setPluginRepositories((NPomRepository[])pluginRepositories.stream().map(x -> x.getObject()).toArray(NPomRepository[]::new));
        pomProfile.setProperties(properties);
        PomProfileObj d = new PomProfileObj(profile, pomProfile, context.getDocument());
        if (visitor != null && mode == PomMode.ROOT) {
            visitor.visitEndProfile(d, context);
        }
        return d;
    }

    public static NPomRepositoryNode parseRepository(Element repository, PomDomVisitor visitor, PomDomVisitorContext context, PomMode mode) {
        if (visitor != null && mode == PomMode.ROOT) {
            visitor.visitStartRepositories(repository, context);
        }
        NodeList childList = repository.getChildNodes();
        String id = "";
        String layout = "";
        String url = "";
        String name = "";
        NPomRepositoryPolicy snapshots = null;
        NPomRepositoryPolicy releases = null;
        block16: for (int k = 0; k < childList.getLength(); ++k) {
            Element c = NPomXmlParser.toElement(childList.item(k));
            if (c == null) continue;
            switch (c.getTagName()) {
                case "id": {
                    id = NPomXmlParser.elemToStr(c);
                    continue block16;
                }
                case "layout": {
                    layout = NPomXmlParser.elemToStr(c);
                    continue block16;
                }
                case "url": {
                    url = NPomXmlParser.elemToStr(c);
                    continue block16;
                }
                case "name": {
                    name = NPomXmlParser.elemToStr(c);
                    continue block16;
                }
                case "snapshots": {
                    snapshots = NPomXmlParser.parseRepositoryPolicy(c);
                    continue block16;
                }
                case "releases": {
                    releases = NPomXmlParser.parseRepositoryPolicy(c);
                }
            }
        }
        if (name.isEmpty()) {
            name = "compile";
        }
        NPomRepository r = new NPomRepository(id, layout, url, name, releases, snapshots);
        PomRepositoryObj d = new PomRepositoryObj(repository, r, context.getDocument());
        if (visitor != null && mode == PomMode.ROOT) {
            visitor.visitEndRepository(d, context);
        }
        return d;
    }

    public static Element createExclusionElement(Document doc, NPomId exclusionId) {
        Element e = doc.createElement("exclusion");
        e.appendChild(NPomXmlParser.createNameTextTag(doc, "groupId", exclusionId.getGroupId()));
        e.appendChild(NPomXmlParser.createNameTextTag(doc, "artifactId", exclusionId.getArtifactId()));
        if (exclusionId.getVersion() != null && exclusionId.getVersion().trim().length() > 0) {
            e.appendChild(NPomXmlParser.createNameTextTag(doc, "version", exclusionId.getVersion()));
        }
        return e;
    }

    public static Element createDependencyElement(Document doc, NPomDependency dep) {
        NPomId[] e;
        Element dependency = doc.createElement("dependency");
        dependency.appendChild(NPomXmlParser.createNameTextTag(doc, "groupId", dep.getGroupId()));
        dependency.appendChild(NPomXmlParser.createNameTextTag(doc, "artifactId", dep.getArtifactId()));
        if (dep.getVersion() != null && dep.getVersion().trim().length() > 0) {
            dependency.appendChild(NPomXmlParser.createNameTextTag(doc, "version", dep.getVersion()));
        }
        if (dep.getOptional() != null && dep.getOptional().trim().length() > 0) {
            dependency.appendChild(NPomXmlParser.createNameTextTag(doc, "optional", dep.getOptional()));
        }
        if (dep.getType() != null && dep.getType().trim().length() > 0) {
            dependency.appendChild(NPomXmlParser.createNameTextTag(doc, "type", dep.getType()));
        }
        if ((e = dep.getExclusions()).length > 0) {
            Element exclusions = doc.createElement("exclusions");
            dependency.appendChild(exclusions);
            for (NPomId pomId : e) {
                exclusions.appendChild(NPomXmlParser.createExclusionElement(doc, pomId));
            }
        }
        return dependency;
    }

    public static Element createRepositoryElement(Document doc, NPomRepository repo) {
        return NPomXmlParser.createRepositoryElement(doc, repo, "repository");
    }

    public static Element createPluginRepositoryElement(Document doc, NPomRepository repo) {
        return NPomXmlParser.createRepositoryElement(doc, repo, "pluginRepository");
    }

    public static Element createRepositoryPolicy(Document doc, NPomRepositoryPolicy repo, String name) {
        Element snapshots = doc.createElement(name);
        snapshots.appendChild(NPomXmlParser.createNameTextTag(doc, "enabled", String.valueOf(repo.isEnabled())));
        if (repo.getUpdatePolicy() != null && repo.getUpdatePolicy().trim().length() > 0) {
            snapshots.appendChild(NPomXmlParser.createNameTextTag(doc, "updatePolicy", repo.getUpdatePolicy()));
        }
        if (repo.getChecksumPolicy() != null && repo.getChecksumPolicy().trim().length() > 0) {
            snapshots.appendChild(NPomXmlParser.createNameTextTag(doc, "checksumPolicy", repo.getChecksumPolicy()));
        }
        return snapshots;
    }

    public static Element createNameTextTag(Document doc, String name, String value) {
        Element elem = doc.createElement(name);
        elem.appendChild(doc.createTextNode(value));
        return elem;
    }

    public static Element createRepositoryElement(Document doc, NPomRepository repo, String name) {
        Element repository = doc.createElement(name);
        repository.appendChild(NPomXmlParser.createNameTextTag(doc, "id", repo.getId()));
        repository.appendChild(NPomXmlParser.createNameTextTag(doc, "url", repo.getUrl()));
        if (repo.getLayout() != null && repo.getLayout().trim().length() > 0) {
            repository.appendChild(NPomXmlParser.createNameTextTag(doc, "layout", repo.getLayout()));
        }
        if (repo.getName() != null && repo.getName().trim().length() > 0) {
            repository.appendChild(NPomXmlParser.createNameTextTag(doc, "name", repo.getName()));
        }
        if (repo.getSnapshots() != null) {
            repository.appendChild(NPomXmlParser.createRepositoryPolicy(doc, repo.getSnapshots(), "snapshots"));
        }
        if (repo.getReleases() != null) {
            repository.appendChild(NPomXmlParser.createRepositoryPolicy(doc, repo.getReleases(), "releases"));
        }
        return repository;
    }

    public static void writeDocument(Document doc, File result) {
        NPomXmlParser.writeDocument(doc, new StreamResult(result));
    }

    public static void writeDocument(Document doc, Writer result) {
        NPomXmlParser.writeDocument(doc, new StreamResult(result));
    }

    public static void writeDocument(Document doc, OutputStream result) {
        NPomXmlParser.writeDocument(doc, new StreamResult(result));
    }

    public static void writeDocument(Document doc, StreamResult result) {
        XmlUtils.writeDocument(doc, result, false, true);
    }

    public static boolean appendOrReplaceDependency(NPomDependency dependency, Element dependencyElement, Element dependenciesElement, Map<String, String> props, PomDomVisitor visitor, PomDomVisitorContext context, PomMode mode) {
        if (dependencyElement != null && dependenciesElement == null) {
            dependenciesElement = (Element)dependencyElement.getParentNode();
        }
        Document doc = dependenciesElement.getOwnerDocument();
        if (dependencyElement == null) {
            dependenciesElement.appendChild(NPomXmlParser.createDependencyElement(doc, dependency));
            return true;
        }
        NPomDependencyNode old = NPomXmlParser.parseDependency(dependencyElement, new OsAndArch(props), visitor, context, mode);
        if (old == null || !old.getObject().equals(dependency)) {
            dependenciesElement.replaceChild(NPomXmlParser.createDependencyElement(doc, dependency), dependencyElement);
            return true;
        }
        return false;
    }

    public static boolean appendOrReplaceRepository(NPomRepository repository, Element repositoryElement, Element repositoriesElement, PomDomVisitor visitor, PomDomVisitorContext context, PomMode mode) {
        if (repositoryElement != null && repositoriesElement == null) {
            repositoriesElement = (Element)repositoryElement.getParentNode();
        }
        Document doc = repositoriesElement.getOwnerDocument();
        if (repositoryElement == null) {
            repositoriesElement.appendChild(NPomXmlParser.createRepositoryElement(doc, repository));
            return true;
        }
        NPomRepositoryNode old = NPomXmlParser.parseRepository(repositoryElement, visitor, context, mode);
        if (old == null || !old.getObject().equals(repository)) {
            repositoriesElement.replaceChild(NPomXmlParser.createRepositoryElement(doc, repository), repositoryElement);
            return true;
        }
        return false;
    }

    public NPom parse(URL url) throws IOException, SAXException, ParserConfigurationException {
        return this.parse(url, null);
    }

    public NPom parse(URL url, PomDomVisitor visitor) {
        NPom nPom;
        block8: {
            InputStream is = DefaultNWebCli.prepareGlobalOpenStream(url);
            try {
                nPom = this.parse(is, visitor);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                }
            }
            is.close();
        }
        return nPom;
    }

    public NPom parse(URI uri) {
        return this.parse(uri, null);
    }

    public NPom parse(URI uri, PomDomVisitor visitor) {
        NPom nPom;
        block8: {
            InputStream is = DefaultNWebCli.prepareGlobalOpenStream(uri.toURL());
            try {
                nPom = this.parse(is, visitor);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                }
            }
            is.close();
        }
        return nPom;
    }

    public NPom parse(File file) {
        return this.parse(file, null);
    }

    public NPom parse(NPath file, PomDomVisitor visitor) {
        NPom nPom;
        block8: {
            InputStream is = file.getInputStream();
            try {
                nPom = this.parse(is, visitor);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                }
            }
            is.close();
        }
        return nPom;
    }

    public NPom parse(File file, PomDomVisitor visitor) {
        NPom nPom;
        FileInputStream is = new FileInputStream(file);
        try {
            nPom = this.parse(is, visitor);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new NIOException(ex);
            }
        }
        ((InputStream)is).close();
        return nPom;
    }

    public NPom parse(InputStream stream) {
        return this.parse(stream, null);
    }

    public NPom parse(InputStream stream, PomDomVisitor visitor) {
        try {
            Document doc = XmlUtils.createDocumentBuilder(true).parse(this.preValidateStream(stream));
            return this.parse(doc, visitor);
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
        catch (SAXException ex) {
            throw new NParseException(NMsg.ofC("error parsing %s", stream), (Throwable)ex);
        }
    }

    private byte[] loadAllBytes(InputStream in) {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        try {
            int count;
            int size = in.available();
            if (size <= 4096) {
                size = 4096;
            }
            byte[] b = new byte[size];
            while ((count = in.read(b)) > 0) {
                o.write(b, 0, count);
            }
            return o.toByteArray();
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    private InputStream preValidateStream(InputStream in) {
        int skip;
        byte[] bytes0 = this.loadAllBytes(in);
        for (skip = 0; skip < bytes0.length && Character.isWhitespace(bytes0[skip]); ++skip) {
        }
        String x = new String(bytes0, skip, bytes0.length - skip);
        return new ByteArrayInputStream(XmlEscaper.escapeToCode(x).getBytes());
    }

    public NPom parse(Document doc) {
        return this.parse(doc, null);
    }

    public NPom parse(Document doc, PomDomVisitor visitor) {
        ArrayList<NPomDependencyNode> deps = new ArrayList<NPomDependencyNode>();
        ArrayList<NPomDependencyNode> depsMan = new ArrayList<NPomDependencyNode>();
        ArrayList<NPomRepositoryNode> repos = new ArrayList<NPomRepositoryNode>();
        ArrayList<NPomRepositoryNode> pluginRepos = new ArrayList<NPomRepositoryNode>();
        ArrayList<NPomProfileNode> profiles = new ArrayList<NPomProfileNode>();
        ArrayList<NPomContributor> contributors = new ArrayList<NPomContributor>();
        ArrayList<NPomContributor> developers = new ArrayList<NPomContributor>();
        ArrayList<NPomLicense> licenses = new ArrayList<NPomLicense>();
        doc.getDocumentElement().normalize();
        NodeList rootChildList = doc.getDocumentElement().getChildNodes();
        String groupId = "";
        String inceptionYear = "";
        String url = "";
        String artifactId = "";
        String description = "";
        String name = "";
        ArrayList<String> modules = new ArrayList<String>();
        String version = "";
        String packaging = "";
        NPomId parentId = null;
        DefaultPomDomVisitorContext context = new DefaultPomDomVisitorContext().setDocument(doc);
        if (visitor != null) {
            visitor.visitStartDocument(doc, context);
        }
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        block64: for (int i = 0; i < rootChildList.getLength(); ++i) {
            Element elem1 = NPomXmlParser.toElement(rootChildList.item(i));
            if (elem1 == null) continue;
            switch (elem1.getTagName()) {
                case "groupId": {
                    groupId = NPomXmlParser.elemToStr(elem1);
                    continue block64;
                }
                case "artifactId": {
                    artifactId = NPomXmlParser.elemToStr(elem1);
                    continue block64;
                }
                case "version": {
                    version = NPomXmlParser.elemToStr(elem1);
                    continue block64;
                }
                case "packaging": {
                    packaging = NPomXmlParser.elemToStr(elem1);
                    continue block64;
                }
                case "description": {
                    description = NPomXmlParser.elemToStr(elem1);
                    continue block64;
                }
                case "name": {
                    name = NPomXmlParser.elemToStr(elem1);
                    continue block64;
                }
                case "inceptionYear": {
                    inceptionYear = NPomXmlParser.elemToStr(elem1);
                    continue block64;
                }
                case "url": {
                    url = NPomXmlParser.elemToStr(elem1);
                    continue block64;
                }
                case "contributors": {
                    for (Element contributor : NPomXmlParser.toElements(elem1.getChildNodes())) {
                        if (!"contributor".equals(contributor.getTagName())) continue;
                        contributors.add(this.parseContributor(contributor));
                    }
                    continue block64;
                }
                case "developers": {
                    for (Element contributor : NPomXmlParser.toElements(elem1.getChildNodes())) {
                        if (!"developer".equals(contributor.getTagName())) continue;
                        developers.add(this.parseContributor(contributor));
                    }
                    continue block64;
                }
                case "licenses": {
                    for (Element contributor : NPomXmlParser.toElements(elem1.getChildNodes())) {
                        if (!"license".equals(contributor.getTagName())) continue;
                        NPomLicense cc = new NPomLicense();
                        for (Element parElem : NPomXmlParser.toElements(contributor.getChildNodes())) {
                            switch (parElem.getTagName()) {
                                case "name": {
                                    cc.setName(NPomXmlParser.elemToStr(parElem));
                                    break;
                                }
                                case "url": {
                                    cc.setUrl(NPomXmlParser.elemToStr(parElem));
                                    break;
                                }
                                case "distribution": {
                                    cc.setDistribution(NPomXmlParser.elemToStr(parElem));
                                    break;
                                }
                                case "comments": {
                                    cc.setComments(NPomXmlParser.elemToStr(parElem));
                                }
                            }
                        }
                        licenses.add(cc);
                    }
                    continue block64;
                }
                case "parent": {
                    NodeList parentChildList = elem1.getChildNodes();
                    String p_groupId = "";
                    String p_artifactId = "";
                    String p_version = "";
                    block69: for (int j = 0; j < parentChildList.getLength(); ++j) {
                        Element parElem = NPomXmlParser.toElement(parentChildList.item(j));
                        if (parElem == null) continue;
                        switch (parElem.getTagName()) {
                            case "groupId": {
                                p_groupId = NPomXmlParser.elemToStr(parElem);
                                continue block69;
                            }
                            case "artifactId": {
                                p_artifactId = NPomXmlParser.elemToStr(parElem);
                                continue block69;
                            }
                            case "version": {
                                p_version = NPomXmlParser.elemToStr(parElem);
                            }
                        }
                    }
                    if (p_groupId.length() <= 0 && p_artifactId.length() <= 0 && p_version.length() <= 0) continue block64;
                    parentId = new NPomId(p_groupId, p_artifactId, p_version);
                    continue block64;
                }
                case "modules": {
                    NodeList childList = elem1.getChildNodes();
                    for (int j = 0; j < childList.getLength(); ++j) {
                        String s;
                        Element parElem = NPomXmlParser.toElement(childList.item(j), "module");
                        if (parElem == null || (s = NPomXmlParser.elemToStr(parElem)).isEmpty()) continue;
                        modules.add(s);
                    }
                    continue block64;
                }
                case "properties": {
                    for (NPomPropertyNode pomPropertyObj : NPomXmlParser.parseProperties(elem1, visitor, context, PomMode.ROOT).getObject()) {
                        props.put(pomPropertyObj.getObject().getName(), pomPropertyObj.getObject().getValue());
                    }
                    continue block64;
                }
                case "dependencyManagement": {
                    OsAndArch osAndArch = new OsAndArch(props);
                    NodeList dependenciesChildList = elem1.getChildNodes();
                    for (int j = 0; j < dependenciesChildList.getLength(); ++j) {
                        Element dependenciesElem = NPomXmlParser.toElement(dependenciesChildList.item(j), "dependencies");
                        if (dependenciesElem == null) continue;
                        depsMan.addAll(NPomXmlParser.parseDependencies(dependenciesElem, visitor, context, osAndArch, PomMode.ROOT_DEPENDENCY_MANAGEMENT).getObject());
                    }
                    continue block64;
                }
                case "dependencies": {
                    OsAndArch osAndArch = new OsAndArch(props);
                    deps.addAll(NPomXmlParser.parseDependencies(elem1, visitor, context, osAndArch, PomMode.ROOT).getObject());
                    continue block64;
                }
                case "repositories": {
                    repos.addAll(NPomXmlParser.parseRepositories(elem1, visitor, context, PomMode.ROOT).getObject());
                    continue block64;
                }
                case "pluginRepositories": {
                    pluginRepos.addAll(NPomXmlParser.parseRepositories(elem1, visitor, context, PomMode.ROOT_PLUGIN).getObject());
                    continue block64;
                }
                case "profiles": {
                    OsAndArch osAndArch = new OsAndArch(props);
                    profiles.addAll(this.parseProfiles(elem1, visitor, context, osAndArch, PomMode.ROOT).getObject());
                    continue block64;
                }
            }
        }
        NPom pom = new NPom(groupId, artifactId, version, packaging, parentId, name, description, url, inceptionYear, props, (NPomDependency[])deps.stream().map(x -> x.getObject()).toArray(NPomDependency[]::new), (NPomDependency[])depsMan.stream().map(x -> x.getObject()).toArray(NPomDependency[]::new), (NPomRepository[])repos.stream().map(x -> x.getObject()).toArray(NPomRepository[]::new), (NPomRepository[])pluginRepos.stream().map(x -> x.getObject()).toArray(NPomRepository[]::new), modules.toArray(new String[0]), (NPomProfile[])profiles.stream().map(x -> x.getObject()).toArray(NPomProfile[]::new), contributors.toArray(new NPomContributor[0]), developers.toArray(new NPomContributor[0]), licenses.toArray(new NPomLicense[0]), doc);
        if (visitor != null) {
            visitor.visitEndDocument(doc, pom, context);
        }
        return pom;
    }

    private NPomContributor parseContributor(Element contributor) {
        NPomContributor cc = new NPomContributor();
        block20: for (Element parElem : NPomXmlParser.toElements(contributor.getChildNodes())) {
            switch (parElem.getTagName()) {
                case "name": {
                    cc.setName(NPomXmlParser.elemToStr(parElem));
                    break;
                }
                case "email": {
                    cc.setEmail(NPomXmlParser.elemToStr(parElem));
                    break;
                }
                case "organization": {
                    cc.setOrganization(NPomXmlParser.elemToStr(parElem));
                    break;
                }
                case "organizationUrl": {
                    cc.setOrganizationUrl(NPomXmlParser.elemToStr(parElem));
                    break;
                }
                case "url": {
                    cc.setUrl(NPomXmlParser.elemToStr(parElem));
                    break;
                }
                case "timezone": {
                    cc.setTimeZone(NPomXmlParser.elemToStr(parElem));
                    break;
                }
                case "roles": {
                    for (Element r : NPomXmlParser.toElements(parElem.getChildNodes())) {
                        if (!"role".equals(r.getTagName())) continue;
                        String v = NPomXmlParser.elemToStr(parElem);
                        if (cc.getRoles() == null) {
                            cc.setRoles(new ArrayList<String>());
                        }
                        cc.getRoles().add(v);
                    }
                    continue block20;
                }
                case "properties": {
                    for (Element r : NPomXmlParser.toElements(parElem.getChildNodes())) {
                        String n = r.getTagName();
                        String v = NPomXmlParser.elemToStr(parElem);
                        if (cc.getProperties() == null) {
                            cc.setProperties(new LinkedHashMap<String, String>());
                        }
                        cc.getProperties().put(n, v);
                    }
                    break;
                }
            }
        }
        return cc;
    }

    private NPomProfilesNode parseProfiles(Element elem1, PomDomVisitor visitor, DefaultPomDomVisitorContext context, OsAndArch osAndArch, PomMode mode) {
        ArrayList<NPomProfileNode> profiles = new ArrayList<NPomProfileNode>();
        if (visitor != null && mode == PomMode.ROOT) {
            visitor.visitStartProfiles(elem1, context);
        }
        NodeList childList = elem1.getChildNodes();
        for (int j = 0; j < childList.getLength(); ++j) {
            Element profile = NPomXmlParser.toElement(childList.item(j), "profile");
            if (profile == null) continue;
            NPomProfileNode pomProfileObj = NPomXmlParser.parseProfile(profile, visitor, context, osAndArch, mode);
            profiles.add(pomProfileObj);
        }
        PomProfilesObj d = new PomProfilesObj(elem1, (List<NPomProfileNode>)profiles, context.getDocument());
        if (visitor != null && mode == PomMode.ROOT) {
            visitor.visitEndProfiles(d, context);
        }
        return d;
    }

    private static enum PomMode {
        ROOT,
        PROFILE_REPOSITORIES,
        PROFILE_DEPENDENCY_MANAGEMENT,
        ROOT_DEPENDENCY_MANAGEMENT,
        PROFILE_DEPENDENCIES,
        PROFILE,
        ROOT_PLUGIN;

    }

    private static class OsAndArch {
        Map<String, String> osMap = new HashMap<String, String>();
        Map<String, String> archMap = new HashMap<String, String>();

        public OsAndArch(Map<String, String> props) {
            for (Map.Entry<String, String> entry : props.entrySet()) {
                Matcher m = NUTS_OS_ARCH_DEPS_PATTERN.matcher(entry.getKey());
                if (!m.find()) continue;
                String os = m.group("os");
                String arch = m.group("arch");
                String txt = entry.getValue().trim();
                for (String a : StringTokenizerUtils.splitDefault(txt.trim())) {
                    NId id;
                    if ((a = a.trim()).startsWith("#") || (id = NId.get(a).orNull()) == null) continue;
                    if (!NBlankable.isBlank(os)) {
                        this.osMap.put(id.getShortName(), os);
                    }
                    if (NBlankable.isBlank(arch)) continue;
                    this.archMap.put(id.getShortName(), arch);
                }
            }
        }

        public String getOs(NId id) {
            return this.osMap.get(id.getShortName());
        }

        public String getArch(NId id) {
            return this.archMap.get(id.getShortName());
        }
    }
}

