/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.artifact.NDescriptorStyle;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.boot.internal.util.NBootJsonParser;
import net.thevpc.nuts.boot.internal.util.NBootPath;
import net.thevpc.nuts.command.NFetchStrategy;
import net.thevpc.nuts.core.NBootOptionsBuilder;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.io.NCoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class NReservedMavenUtils {
    public static final Pattern JAR_POM_PATH = Pattern.compile("META-INF/maven/(?<g>[a-zA-Z0-9_.-]+)/(?<a>[a-zA-Z0-9_-]+)/pom.xml");
    public static final Pattern JAR_NUTS_JSON_POM_PATH = Pattern.compile("META-INF/nuts/(?<g>[a-zA-Z0-9_.-]+)/(?<a>[a-zA-Z0-9_-]+)/nuts.json");
    public static final Pattern NUTS_OS_ARCH_DEPS_PATTERN = Pattern.compile("^nuts([.](?<os>[a-zA-Z0-9-_]+)-os)?([.](?<arch>[a-zA-Z0-9-_]+)-arch)?-dependencies$");
    public static final Pattern PATTERN_TARGET_CLASSES = Pattern.compile("(?<src>.*)[/\\\\]+target[/\\\\]+classes[/\\\\]*");

    public static NId[] resolveJarIds(URL url) {
        File file = NCoreIOUtils.toFile(url);
        if (file != null) {
            if (file.isDirectory()) {
                String src;
                Matcher m = PATTERN_TARGET_CLASSES.matcher(file.getPath().replace('/', File.separatorChar));
                if (m.find() && new File(src = m.group("src"), "pom.xml").exists()) {
                    Map<String, String> map = NReservedMavenUtils.resolvePomTagValues(new String[]{"groupId", "artifactId", "version"}, new File(src, "pom.xml"));
                    String groupId = map.get("groupId");
                    String artifactId = map.get("artifactId");
                    String version = map.get("version");
                    if (groupId != null && artifactId != null && version != null) {
                        return new NId[]{NId.get(groupId, artifactId, NVersion.get(version).get()).get()};
                    }
                }
                return new NId[0];
            }
            if (file.isFile()) {
                ArrayList<NId> all = new ArrayList<NId>();
                String fileName = file.getName().toLowerCase();
                if (fileName.endsWith(".jar") || fileName.endsWith(".zip")) {
                    try (ZipFile zf = new ZipFile(file);){
                        Enumeration<? extends ZipEntry> zipEntries = zf.entries();
                        while (zipEntries.hasMoreElements()) {
                            InputStream is;
                            String artifactId;
                            String groupId;
                            ZipEntry entry = zipEntries.nextElement();
                            String currPath = entry.getName();
                            Matcher m = JAR_POM_PATH.matcher(currPath);
                            if (m.find()) {
                                groupId = m.group("g");
                                artifactId = m.group("a");
                                is = zf.getInputStream(entry);
                                try {
                                    Map<String, String> map = NReservedMavenUtils.resolvePomTagValues(new String[]{"groupId", "artifactId", "version"}, is);
                                    if (map.containsKey("version")) {
                                        String version = map.get("version");
                                        all.add(NId.get(groupId, artifactId, NVersion.get(version).get()).get());
                                    }
                                }
                                finally {
                                    if (is != null) {
                                        is.close();
                                    }
                                }
                            }
                            if (!(m = JAR_NUTS_JSON_POM_PATH.matcher(currPath)).find()) continue;
                            groupId = m.group("g");
                            artifactId = m.group("a");
                            is = zf.getInputStream(entry);
                            try (InputStreamReader r = new InputStreamReader(is);){
                                Map map;
                                Object v;
                                Object p = new NBootJsonParser(r).parse();
                                if (!(p instanceof Map) || !((v = (map = (Map)p).get("version")) instanceof String)) continue;
                                all.add(NId.get(groupId, artifactId, NVersion.get((String)v).get()).get());
                            }
                            finally {
                                if (is == null) continue;
                                is.close();
                            }
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return all.toArray(new NId[0]);
            }
        }
        return new NId[0];
    }

    public static String getFileName(NId id, String ext) {
        return id.getArtifactId() + "-" + id.getVersion() + "." + ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<NId> loadDependenciesFromNutsUrl(String url, NLog bLog) {
        InputStream inputStream = NCoreIOUtils.resolveInputStream(url, bLog);
        Map<String, Object> descNuts = null;
        if (inputStream != null) {
            try {
                NBootJsonParser parser = null;
                parser = new NBootJsonParser(new InputStreamReader(inputStream));
                descNuts = parser.parseObject();
                List dependencies = (List)descNuts.get("dependencies");
                if (dependencies == null) {
                    LinkedHashSet<NId> linkedHashSet = new LinkedHashSet<NId>();
                    return linkedHashSet;
                }
                Set<NId> set = dependencies.stream().map(x -> NId.get(x).get()).collect(Collectors.toSet());
                return set;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    static List<NVersion> detectVersionsFromMetaData(String mavenMetadata, NLog bLog) {
        ArrayList<NVersion> all = new ArrayList<NVersion>();
        try {
            URL runtimeMetadata = CoreIOUtils.urlOf(mavenMetadata);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream is = null;
            try {
                is = NCoreIOUtils.preloadStream(NCoreIOUtils.openStream(runtimeMetadata, bLog), bLog);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (is != null) {
                bLog.log(NMsg.ofC("parsing %s", mavenMetadata).withLevel(Level.FINEST).withIntent(NMsgIntent.SUCCESS));
                Document doc = builder.parse(is);
                Element c = doc.getDocumentElement();
                for (int i = 0; i < c.getChildNodes().getLength(); ++i) {
                    if (!(c.getChildNodes().item(i) instanceof Element) || !c.getChildNodes().item(i).getNodeName().equals("versioning")) continue;
                    Element c2 = (Element)c.getChildNodes().item(i);
                    for (int j = 0; j < c2.getChildNodes().getLength(); ++j) {
                        if (!(c2.getChildNodes().item(j) instanceof Element) || !c2.getChildNodes().item(j).getNodeName().equals("versions")) continue;
                        Element c3 = (Element)c2.getChildNodes().item(j);
                        for (int k = 0; k < c3.getChildNodes().getLength(); ++k) {
                            Element c4;
                            NVersion p;
                            if (!(c3.getChildNodes().item(k) instanceof Element) || !c3.getChildNodes().item(k).getNodeName().equals("version") || (p = NVersion.get((c4 = (Element)c3.getChildNodes().item(k)).getTextContent()).get()).isBlank()) continue;
                            all.add(p);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            bLog.log(NMsg.ofC("unable to parse %s", mavenMetadata).asFinestFail(ex));
        }
        return all;
    }

    static VersionAndPath resolveLatestMavenId(NId zId, String path, Predicate<NVersion> filter, NLog bLog, NRepositoryLocation repoUrl2, boolean stopFirst, NBootOptionsBuilder options) {
        String bestPath;
        NVersion bestVersion;
        block15: {
            boolean remoteURL;
            String basePath;
            boolean online;
            NDescriptorStyle descType = NDescriptorStyle.MAVEN;
            if ("nuts".equalsIgnoreCase(repoUrl2.getLocationType())) {
                descType = NDescriptorStyle.NUTS;
            }
            String repoUrl = repoUrl2.getPath();
            boolean found = false;
            bestVersion = null;
            bestPath = null;
            NFetchStrategy fetchStrategy = options.getFetchStrategy().orElse(NFetchStrategy.ANYWHERE);
            boolean offline = fetchStrategy != NFetchStrategy.REMOTE;
            boolean bl = online = fetchStrategy != NFetchStrategy.OFFLINE;
            if (!repoUrl.contains("://")) {
                if (offline) {
                    File[] children;
                    FilenameFilter filenameFilter;
                    File mavenNutsCoreFolder = new File(repoUrl, path.replace("/", File.separator));
                    FilenameFilter filenameFilter2 = filenameFilter = descType == NDescriptorStyle.NUTS ? (dir, name) -> name.endsWith(".nuts") : (dir, name) -> name.endsWith(".pom");
                    if (mavenNutsCoreFolder.isDirectory() && (children = mavenNutsCoreFolder.listFiles()) != null) {
                        for (File file : children) {
                            Path jarPath;
                            String[] goodChildren;
                            if (!file.isDirectory() || (goodChildren = file.list(filenameFilter)) == null || goodChildren.length <= 0) continue;
                            NVersion p = NVersion.get(file.getName()).get();
                            if (filter != null && !filter.test(p)) continue;
                            found = true;
                            if (bestVersion != null && bestVersion.compareTo(p) >= 0 || !Files.isRegularFile(jarPath = file.toPath().resolve(NReservedMavenUtils.getFileName(NId.get(zId.getGroupId(), zId.getArtifactId(), p).get(), "jar")), new LinkOption[0])) continue;
                            bestVersion = p;
                            bestPath = "local location : " + jarPath;
                            if (bLog != null) {
                                bLog.log(NMsg.ofC("%s#%s found in %s as %s", zId, bestVersion, repoUrl2, bestPath).withLevel(Level.FINEST).withIntent(NMsgIntent.SUCCESS));
                            }
                            if (stopFirst) break;
                        }
                    }
                }
                return new VersionAndPath(bestVersion, bestPath);
            }
            boolean htmlfs = repoUrl.startsWith("htmlfs+");
            if (htmlfs) {
                repoUrl = repoUrl.substring("htmlfs+".length());
            }
            if (!repoUrl.endsWith("/")) {
                repoUrl = repoUrl + "/";
            }
            if (!(basePath = repoUrl + path).endsWith("/")) {
                basePath = basePath + "/";
            }
            if ((!(remoteURL = new NBootPath(basePath).isRemote()) || !online) && (remoteURL || !offline)) break block15;
            if (htmlfs) {
                for (NVersion p : NReservedMavenUtils.detectVersionsFromHtmlfsTomcatDirectoryListing(basePath, bLog)) {
                    if (filter != null && !filter.test(p)) continue;
                    found = true;
                    if (bestVersion != null && bestVersion.compareTo(p) >= 0) continue;
                    bestVersion = p;
                    bestPath = "remote file " + basePath;
                    if (bLog != null) {
                        bLog.log(NMsg.ofC("%s#%s found in %s as %s", zId, bestVersion, repoUrl2, bestPath).withLevel(Level.FINEST).withIntent(NMsgIntent.SUCCESS));
                    }
                    if (!stopFirst) continue;
                    break;
                }
            } else {
                String mavenMetadata = basePath + "maven-metadata.xml";
                for (NVersion p : NReservedMavenUtils.detectVersionsFromMetaData(mavenMetadata, bLog)) {
                    if (filter != null && !filter.test(p)) continue;
                    found = true;
                    if (bestVersion != null && bestVersion.compareTo(p) >= 0) continue;
                    bestVersion = p;
                    bestPath = "remote file " + mavenMetadata;
                    if (bLog != null) {
                        bLog.log(NMsg.ofC("%s#%s found in %s as %s", zId, bestVersion, repoUrl2, bestPath).withLevel(Level.FINEST).withIntent(NMsgIntent.SUCCESS));
                    }
                    if (!stopFirst) continue;
                    break;
                }
            }
        }
        return new VersionAndPath(bestVersion, bestPath);
    }

    private static List<NVersion> detectVersionsFromHtmlfsTomcatDirectoryListing(String basePath, NLog bLog) {
        ArrayList<NVersion> all = new ArrayList<NVersion>();
        try (InputStream in = NCoreIOUtils.openStream(CoreIOUtils.urlOf(basePath), bLog);){
            List<String> p = new HtmlfsTomcatDirectoryListParser().parse(in);
            if (p != null) {
                for (String s : p) {
                    String n;
                    NVersion v;
                    int a;
                    if (!s.endsWith("/") || (a = (s = s.substring(0, s.length() - 1)).lastIndexOf(47)) < 0 || (v = NVersion.get(n = s.substring(a + 1)).get()).isBlank()) continue;
                    all.add(v);
                }
            }
        }
        catch (IOException | UncheckedIOException exception) {
            // empty catch block
        }
        return all;
    }

    public static String resolveNutsApiVersionFromClassPath(NLog bLog) {
        return NReservedMavenUtils.resolveNutsApiPomPattern("version", bLog);
    }

    public static String resolveNutsApiPomPattern(String propName, NLog bLog) {
        String propValue = null;
        try {
            URL resource = Nuts.class.getResource("/META-INF/maven/net.thevpc.nuts/nuts/pom.properties");
            if (resource != null) {
                switch (propName) {
                    case "groupId": 
                    case "artifactId": 
                    case "version": {
                        propValue = NCoreIOUtils.loadURLProperties(resource, null, false, bLog).getProperty(propName);
                    }
                }
            }
        }
        catch (Exception resource) {
            // empty catch block
        }
        if (!NBlankable.isBlank(propValue)) {
            return propValue;
        }
        URL pomXml = Nuts.class.getResource("/META-INF/maven/net.thevpc.nuts/nuts/pom.xml");
        if (pomXml != null) {
            try (InputStream is2 = NCoreIOUtils.openStream(pomXml, bLog);){
                propValue = NReservedMavenUtils.resolvePomTagValues(new String[]{propName}, is2).get(propName);
            }
            catch (Exception is2) {
                // empty catch block
            }
        }
        if (!NBlankable.isBlank(propValue)) {
            return propValue;
        }
        String cp = System.getProperty("java.class.path");
        for (String p : cp.split(File.pathSeparator)) {
            String src;
            Matcher m;
            File f = new File(p);
            if (!f.isDirectory() || !(m = Pattern.compile("(?<src>.*)[/\\\\]+target[/\\\\]+classes[/\\\\]*").matcher(f.getPath().replace('/', File.separatorChar))).find() || !new File(src = m.group("src"), "pom.xml").exists() || !new File(src, "src/main/java/net/thevpc/nuts/Nuts.java".replace('/', File.separatorChar)).exists()) continue;
            propValue = NReservedMavenUtils.resolvePomTagValues(new String[]{propName}, new File(src, "pom.xml")).get(propName);
        }
        if (!NBlankable.isBlank(propValue)) {
            return propValue;
        }
        try {
            URL resource = Nuts.class.getResource("/META-INF/nuts/net.thevpc.nuts/nuts/nuts.properties");
            if (resource != null) {
                block18 : switch (propName) {
                    case "groupId": 
                    case "artifactId": 
                    case "version": {
                        String id = NCoreIOUtils.loadURLProperties(resource, null, false, bLog).getProperty("id");
                        if (NBlankable.isBlank(id)) break;
                        NId nId = NId.get(id).orNull();
                        switch (propName) {
                            case "groupId": {
                                propValue = nId.getGroupId();
                                break block18;
                            }
                            case "artifactId": {
                                propValue = nId.getArtifactId();
                                break block18;
                            }
                            case "version": {
                                propValue = nId.getVersion().toString();
                            }
                        }
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!NBlankable.isBlank(propValue)) {
            return propValue;
        }
        return null;
    }

    public static Map<String, String> resolvePomTagValues(String[] propNames, File file) {
        if (file != null && file.isFile()) {
            Map<String, String> map;
            block9: {
                InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);
                try {
                    map = NReservedMavenUtils.resolvePomTagValues(propNames, is);
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                is.close();
            }
            return map;
        }
        return new HashMap<String, String>();
    }

    public static Map<String, String> resolvePomTagValues(String[] propNames, InputStream is) {
        int i;
        String propValue = null;
        StringBuilder sb = new StringBuilder("<(?<name>");
        for (i = 0; i < propNames.length; ++i) {
            if (i > 0) {
                sb.append("|");
            }
            sb.append(propNames[i].replace(".", "[.]"));
        }
        sb.append(")>");
        sb.append("(?<value>[^<]*)");
        sb.append("</(?<name2>");
        for (i = 0; i < propNames.length; ++i) {
            if (i > 0) {
                sb.append("|");
            }
            sb.append(propNames[i].replace(".", "[.]"));
        }
        sb.append(")>");
        Pattern pattern = Pattern.compile(sb.toString());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            NIOUtils.copy(is, bos, false, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher m = pattern.matcher(bos.toString());
        while (m.find()) {
            String n = m.group("name").trim();
            String n2 = m.group("name2").trim();
            propValue = m.group("value").trim();
            if (map.containsKey(n)) continue;
            map.put(n, propValue);
        }
        return map;
    }

    private static class VersionAndPath {
        NVersion version;
        String path;

        public VersionAndPath(NVersion version, String path) {
            this.version = version;
            this.path = path;
        }
    }

    private static class HtmlfsTomcatDirectoryListParser {
        private HtmlfsTomcatDirectoryListParser() {
        }

        public List<String> parse(InputStream html) {
            try {
                String line;
                ArrayList<String> found = new ArrayList<String>();
                BufferedReader br = new BufferedReader(new InputStreamReader(html));
                SimpleTomcatDirectoryListParserState s = SimpleTomcatDirectoryListParserState.EXPECT_DOCTYPE;
                block8: while ((line = br.readLine()) != null) {
                    line = line.trim();
                    switch (s.ordinal()) {
                        case 0: {
                            if (line.isEmpty()) break;
                            if (line.toLowerCase().startsWith("<!DOCTYPE html".toLowerCase())) {
                                s = SimpleTomcatDirectoryListParserState.EXPECT_BODY;
                                break;
                            }
                            if (line.toLowerCase().startsWith("<html>".toLowerCase()) || line.toLowerCase().startsWith("<html ".toLowerCase())) {
                                s = SimpleTomcatDirectoryListParserState.EXPECT_BODY;
                                break;
                            }
                            return null;
                        }
                        case 1: {
                            if (line.isEmpty() || !line.toLowerCase().startsWith("<body>".toLowerCase()) && !line.toLowerCase().startsWith("<body ".toLowerCase())) break;
                            s = SimpleTomcatDirectoryListParserState.EXPECT_PRE;
                            break;
                        }
                        case 2: {
                            int i1;
                            int i0;
                            if (line.isEmpty()) break;
                            String lowLine = line;
                            if (lowLine.toLowerCase().startsWith("<pre>".toLowerCase()) || lowLine.toLowerCase().startsWith("<pre ".toLowerCase())) {
                                if (lowLine.toLowerCase().startsWith("<pre>") && lowLine.toLowerCase().matches("<pre>name[ ]+last modified[ ]+size</pre>(<hr/>)?")) break;
                                if (lowLine.toLowerCase().startsWith("<pre>") && lowLine.toLowerCase().matches("<pre>[ ]*<a href=.*")) {
                                    if (!(lowLine = lowLine.substring("<pre>".length()).trim()).toLowerCase().startsWith("<a href=\"")) continue block8;
                                    i0 = "<a href=\"".length();
                                    i1 = lowLine.indexOf(34, i0);
                                    if (i1 > 0) {
                                        found.add(lowLine.substring(i0, i1));
                                        s = SimpleTomcatDirectoryListParserState.EXPECT_HREF;
                                        break;
                                    }
                                    return null;
                                }
                                if (!lowLine.toLowerCase().startsWith("<pre ")) continue block8;
                                s = SimpleTomcatDirectoryListParserState.EXPECT_HREF;
                                break;
                            }
                            if (!lowLine.toLowerCase().matches("<td .*<strong>last modified</strong>.*</td>")) continue block8;
                            s = SimpleTomcatDirectoryListParserState.EXPECT_HREF;
                            break;
                        }
                        case 3: {
                            int i1;
                            int i0;
                            if (line.isEmpty()) break;
                            String lowLine = line;
                            if (lowLine.toLowerCase().startsWith("</pre>".toLowerCase())) {
                                return found;
                            }
                            if (lowLine.toLowerCase().startsWith("</html>".toLowerCase())) {
                                return found;
                            }
                            if (!lowLine.toLowerCase().startsWith("<a href=\"") || (i1 = lowLine.indexOf(34, i0 = "<a href=\"".length())) <= 0) break;
                            found.add(lowLine.substring(i0, i1));
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    private static enum SimpleTomcatDirectoryListParserState {
        EXPECT_DOCTYPE,
        EXPECT_BODY,
        EXPECT_PRE,
        EXPECT_HREF;

    }
}

