/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven;

import java.util.ArrayList;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryConfig;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryList;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.MavenFolderRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.MavenRemoteXmlRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.NMavenSettings;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.NMavenSettingsLoader;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringUtils;

public class MavenSettingsRepository
extends NRepositoryList {
    private NMavenSettings settings;

    public MavenSettingsRepository(NAddRepositoryOptions options, NRepository parentRepository) {
        super(options, new NRepository[0], parentRepository, null, false, "maven", false);
        NLog LOG = NLog.of(MavenSettingsRepository.class);
        this.settings = new NMavenSettingsLoader(LOG).loadSettingsRepos();
        ArrayList<MavenFolderRepository> base = new ArrayList<MavenFolderRepository>();
        base.add(this.createChild(options, "maven-local", this.getName() + "-local", this.settings.getLocalRepository()));
        base.add(this.createChild(options, "maven-central", this.getName() + "-central", this.settings.getRemoteRepository()));
        for (NRepositoryLocation activeRepository : this.settings.getActiveRepositories()) {
            base.add(this.createChild(options, "maven-extra", this.getName() + "-" + activeRepository.getName(), activeRepository.getPath()));
        }
        this.repoItems = base.toArray(base.toArray(new NRepository[0]));
    }

    private MavenFolderRepository createChild(NAddRepositoryOptions options0, String type, String id, String url) {
        NPath p = NPath.of(url);
        String pr = NStringUtils.trim(p.getProtocol());
        MavenFolderRepository mavenChild = null;
        NAddRepositoryOptions options = new NAddRepositoryOptions();
        options.setName(id);
        options.setLocation(NPath.of(id).toAbsolute(NWorkspaceExt.of().getConfigModel().getRepositoriesRoot()).toString());
        options.setEnabled(true);
        options.setTemporary(true);
        options.setFailSafe(false);
        NRepositoryConfig config = new NRepositoryConfig();
        options.setConfig(config);
        config.setName(id);
        config.setEnv(options0.getConfig().getEnv());
        config.setLocation(new NRepositoryLocation(id, "maven", url));
        switch (pr) {
            case "http": 
            case "https": {
                if ("maven-extra".equals(type)) {
                    NPath nr = NPath.of(url).resolve(".nuts-repository");
                    if (nr.exists()) {
                        NElement e = null;
                        String repositoryType = null;
                        String repositoryName = null;
                        String repositoryLayout = null;
                        try {
                            e = NElementParser.ofJson().parse(nr);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (e != null && e.isAnyObject()) {
                            NObjectElement o = e.asObject().get();
                            repositoryType = o.getStringValue("repositoryType").orNull();
                            repositoryName = o.getStringValue("repositoryName").orNull();
                            repositoryLayout = o.getStringValue("repositoryLayout").orNull();
                        }
                        if (!NBlankable.isBlank(repositoryLayout)) {
                            config.setLocation(new NRepositoryLocation(id, "maven", NStringUtils.trim(repositoryLayout) + "+" + url));
                        }
                        mavenChild = new MavenFolderRepository(options, null);
                        break;
                    }
                    mavenChild = new MavenRemoteXmlRepository(options, null);
                    break;
                }
                mavenChild = new MavenRemoteXmlRepository(options, null);
                break;
            }
            default: {
                mavenChild = new MavenFolderRepository(options, null);
            }
        }
        mavenChild.getCache().setReadEnabled(false);
        mavenChild.getCache().setWriteEnabled(false);
        mavenChild.getLib().setReadEnabled(false);
        mavenChild.getLib().setWriteEnabled(false);
        mavenChild.setLockEnabled(false);
        return mavenChild;
    }
}

