/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl.maven;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.definition.NDefinitionHelper;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.MavenFolderRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenMetadata;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenUtils;
import net.thevpc.nuts.runtime.standalone.util.NCoreLogUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBuilder;

public class MavenRemoteXmlRepository
extends MavenFolderRepository {
    public MavenRemoteXmlRepository(NAddRepositoryOptions options, NRepository parentRepository) {
        super(options, parentRepository);
    }

    @Override
    public NIterator<NId> findNonSingleVersionImpl(NId id, NDefinitionFilter idFilter, NFetchMode fetchMode) {
        if (!this.acceptedFetchNoCache(fetchMode)) {
            return NIteratorBuilder.emptyIterator();
        }
        NSession session = this.getWorkspace().currentSession();
        String groupId = id.getGroupId();
        String artifactId = id.getArtifactId();
        NPath metadataURL = this.config().getLocationPath().resolve(groupId.replace('.', '/') + "/" + artifactId + "/maven-metadata.xml");
        return NIteratorBuilder.ofSupplier(() -> {
            ArrayList<NId> ret = new ArrayList<NId>();
            InputStream metadataStream = null;
            session.getTerminal().printProgress(NMsg.ofC("looking for versions of %s at %s", id, NCoreLogUtils.forProgress(metadataURL)));
            try {
                try {
                    metadataStream = this.openStream(id, metadataURL, id.builder().setFace("catalog").build(), "artifact catalog", NMsg.ofC("retrieve %s", id.getLongId()));
                }
                catch (UncheckedIOException | NIOException ex) {
                    NIterator nIterator = NIteratorBuilder.emptyIterator();
                    if (metadataStream != null) {
                        try {
                            metadataStream.close();
                        }
                        catch (IOException e) {
                            return NIteratorBuilder.emptyIterator();
                        }
                    }
                    return nIterator;
                }
                MavenMetadata info = MavenUtils.of().parseMavenMetaData(metadataStream);
                if (info != null) {
                    for (String version : info.getVersions()) {
                        NId nutsId = id.builder().setVersion(version).build();
                        if (idFilter != null && !idFilter.acceptDefinition(NDefinitionHelper.ofIdOnlyFromRepo(nutsId, this, "MavenRemoteXmlRepository"))) continue;
                        ret.add(NIdBuilder.of(groupId, artifactId).setVersion(version).build());
                    }
                }
            }
            catch (UncheckedIOException | NIOException ex) {
                NIterator nIterator = NIteratorBuilder.emptyIterator();
                return nIterator;
            }
            finally {
                if (metadataStream != null) {
                    try {
                        metadataStream.close();
                    }
                    catch (IOException e) {
                        return NIteratorBuilder.emptyIterator();
                    }
                }
            }
            return ret.iterator();
        }, () -> NElement.ofObjectBuilder().name("ScanMavenMetadataXml").set("path", metadataURL.toString()).build()).build();
    }
}

