/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl;

import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryModel;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.repository.cmd.NRepositorySupportedAction;
import net.thevpc.nuts.runtime.standalone.repository.impl.NCachedRepository;
import net.thevpc.nuts.util.NIterator;

public class NSimpleRepositoryWrapper
extends NCachedRepository {
    private NRepositoryModel base;
    private int mode;

    public NSimpleRepositoryWrapper(NAddRepositoryOptions options, NRepository parent, NRepositoryModel base) {
        super(options, parent, base.getSpeed(), (base.getMode() & 1) != 0, base.getRepositoryType(), true);
        this.mode = base.getMode();
        this.lib.setReadEnabled((this.mode & 2) != 0);
        this.lib.setWriteEnabled((this.mode & 4) != 0);
        this.cache.setReadEnabled((this.mode & 0x10) != 0);
        this.cache.setWriteEnabled((this.mode & 0x20) != 0);
        this.base = base;
    }

    @Override
    public String getBootConnectionString() {
        return null;
    }

    @Override
    public NIterator<NId> searchVersionsCore(NId id, NDefinitionFilter idFilter, NFetchMode fetchMode) {
        return this.base.searchVersions(id, idFilter, fetchMode, this);
    }

    @Override
    public NId searchLatestVersionCore(NId id, NDefinitionFilter filter, NFetchMode fetchMode) {
        return this.base.searchLatestVersion(id, filter, fetchMode, this);
    }

    @Override
    public NDescriptor fetchDescriptorCore(NId id, NFetchMode fetchMode) {
        return this.base.fetchDescriptor(id, fetchMode, this);
    }

    @Override
    public NPath fetchContentCore(NId id, NDescriptor descriptor, NFetchMode fetchMode) {
        return this.base.fetchContent(id, descriptor, fetchMode, this);
    }

    @Override
    public NIterator<NId> searchCore(NDefinitionFilter filter, NPath[] basePaths, NId[] baseIds, NFetchMode fetchMode) {
        return this.base.search(filter, basePaths, fetchMode, this);
    }

    @Override
    public void updateStatisticsImpl() {
        this.base.updateStatistics(this);
    }

    @Override
    protected boolean isAllowedOverrideArtifact(NId id) {
        return (this.mode & 8) != 0;
    }

    @Override
    public boolean acceptAction(NId id, NRepositorySupportedAction supportedAction, NFetchMode mode) {
        if (!super.acceptAction(id, supportedAction, mode)) {
            return false;
        }
        switch (supportedAction) {
            case DEPLOY: {
                return this.base.isAcceptDeploy(id, mode, this);
            }
            case SEARCH: {
                return this.base.isAcceptFetch(id, mode, this);
            }
        }
        return false;
    }

    @Override
    public boolean isAcceptFetchMode(NFetchMode mode) {
        return this.base.isAcceptFetchMode(mode);
    }

    @Override
    public boolean isRemote() {
        return this.base.isRemote();
    }
}

