/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorParser;
import net.thevpc.nuts.artifact.NDescriptorStyle;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NAlreadyDeployedException;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.concurrent.NLock;
import net.thevpc.nuts.core.NConfirmationMode;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.io.DefaultNContentMetadata;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NCp;
import net.thevpc.nuts.io.NDigest;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.runtime.standalone.definition.NDefinitionHelper;
import net.thevpc.nuts.runtime.standalone.event.DefaultNContentEvent;
import net.thevpc.nuts.runtime.standalone.id.util.CoreNIdUtils;
import net.thevpc.nuts.runtime.standalone.io.terminal.DefaultWriteTypeProcessor;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.repository.NIdPathIterator;
import net.thevpc.nuts.runtime.standalone.repository.NIdPathIteratorBase;
import net.thevpc.nuts.runtime.standalone.repository.NRepositoryHelper;
import net.thevpc.nuts.runtime.standalone.repository.cmd.fetch.DefaultNFetchContentRepositoryCmd;
import net.thevpc.nuts.runtime.standalone.repository.cmd.undeploy.DefaultNRepositoryUndeployCmd;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryExt0;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.CharacterizedExecFile;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultNExecCmd;
import net.thevpc.nuts.runtime.standalone.xtra.digest.NDigestUtils;
import net.thevpc.nuts.spi.NDeployRepositoryCmd;
import net.thevpc.nuts.spi.NRepositorySPI;
import net.thevpc.nuts.spi.NRepositoryUndeployCmd;
import net.thevpc.nuts.text.NDescriptorFormat;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBuilder;
import net.thevpc.nuts.util.NStream;

public class NRepositoryFolderHelper {
    private final NRepository repo;
    private final NPath rootPath;
    private final boolean cacheFolder;
    private NLog LOG;
    private boolean readEnabled = true;
    private boolean writeEnabled = true;
    private final String kind;
    private final NObjectElement extraInfoElements;

    public NRepositoryFolderHelper(NRepository repo, NPath rootPath, boolean cacheFolder, String kind, NObjectElement extraInfoElements) {
        this.repo = repo;
        this.kind = kind;
        this.extraInfoElements = extraInfoElements;
        this.rootPath = rootPath;
        this.cacheFolder = cacheFolder;
    }

    public boolean isReadEnabled() {
        return this.readEnabled;
    }

    public void setReadEnabled(boolean readEnabled) {
        this.readEnabled = readEnabled;
    }

    public boolean isWriteEnabled() {
        return this.writeEnabled;
    }

    public void setWriteEnabled(boolean writeEnabled) {
        this.writeEnabled = writeEnabled;
    }

    public NPath getLongIdLocalFolder(NId id) {
        CoreNIdUtils.checkLongId(id);
        if (this.repo == null) {
            return this.getStoreLocation().resolve(NWorkspace.of().getDefaultIdBasedir(id));
        }
        return this.getStoreLocation().resolve(NRepositoryExt0.of(this.repo).getIdBasedir(id));
    }

    public NPath getLongIdLocalFile(NId id) {
        if (this.repo == null) {
            return this.getLongIdLocalFolder(id).resolve(NWorkspace.of().getDefaultIdFilename(id));
        }
        return this.getLongIdLocalFolder(id).resolve(NRepositoryExt0.of(this.repo).getIdFilename(id));
    }

    public NPath getShortIdLocalFolder(NId id) {
        CoreNIdUtils.checkShortId(id);
        if (this.repo == null) {
            return this.getStoreLocation().resolve(NWorkspace.of().getDefaultIdBasedir(id.builder().setVersion("").build()));
        }
        return this.getStoreLocation().resolve(NRepositoryExt0.of(this.repo).getIdBasedir(id.builder().setVersion("").build()));
    }

    public NPath fetchContentImpl(NId id) {
        NPath cacheContent = this.getLongIdLocalFile(id.builder().setFaceContent().build());
        if (cacheContent != null && this.pathExists(cacheContent)) {
            return cacheContent.setUserCache(this.cacheFolder).setUserTemporary(false);
        }
        return null;
    }

    public NWorkspace getWorkspace() {
        return this.repo.getWorkspace();
    }

    protected String getIdFilename(NId id) {
        return NWorkspace.of().getDefaultIdFilename(id);
    }

    public NPath getGoodPath(NId id) {
        String idFilename = this.getIdFilename(id);
        NPath versionFolder = this.getLongIdLocalFolder(id);
        return versionFolder.resolve(idFilename);
    }

    public NDescriptor fetchDescriptorImpl(NId id) {
        if (!this.isReadEnabled()) {
            return null;
        }
        String idFilename = this.getIdFilename(id.builder().setFaceDescriptor().build());
        NPath goodFile = null;
        NPath versionFolder = this.getLongIdLocalFolder(id);
        goodFile = versionFolder.resolve(idFilename);
        if (this.pathExists(goodFile)) {
            return NDescriptorParser.of().setDescriptorStyle(NDescriptorStyle.NUTS).parse(goodFile).get();
        }
        return null;
    }

    protected NDescriptor loadMatchingDescriptor(NPath file, NId id) {
        if (this.pathExists(file)) {
            NDescriptor d;
            NDescriptor nDescriptor = d = file.isRegularFile() ? NDescriptorParser.of().parse(file).get() : null;
            if (d != null) {
                String de;
                String platform;
                String dist;
                Map<String, String> query = id.getProperties();
                String os = query.get("os");
                String arch = query.get("arch");
                if (CoreFilterUtils.matchesEnv(arch, os, dist = query.get("osdist"), platform = query.get("platform"), de = query.get("desktop"), d.getCondition())) {
                    return d;
                }
            }
        }
        return null;
    }

    public NPath getRelativeLocalGroupAndArtifactFile(NId id) {
        CoreNIdUtils.checkShortId(id);
        return NPath.of(id.getShortId().getMavenFolder());
    }

    public NPath getLocalGroupAndArtifactFile(NId id) {
        CoreNIdUtils.checkShortId(id);
        return this.getStoreLocation().resolve(id.getShortId().getMavenFolder());
    }

    public NIterator<NId> searchVersions(NId id, NDefinitionFilter filter, boolean deep) {
        String singleVersion;
        if (!this.isReadEnabled()) {
            return null;
        }
        String string = id.getVersion().isLatestVersion() ? null : (singleVersion = id.getVersion().isReleaseVersion() ? null : id.getVersion().asSingleValue().orNull());
        if (singleVersion != null) {
            return NIteratorBuilder.ofSupplier(() -> {
                if ("LATEST".equals(singleVersion) || "RELEASE".equals(singleVersion)) {
                    NId found = this.searchLatestVersion(id, filter);
                    return found != null ? Arrays.asList(found).iterator() : Collections.emptyIterator();
                }
                NId id1 = id.builder().setVersion(singleVersion).setFaceDescriptor().build();
                NPath localFile = this.getLongIdLocalFile(id1);
                if (localFile != null && localFile.isRegularFile()) {
                    return Collections.singletonList(id.builder().setRepository(this.repo == null ? null : this.repo.getName()).build()).iterator();
                }
                return NIteratorBuilder.emptyIterator();
            }, () -> NElement.ofObjectBuilder().name("SearchSingleVersion").set("repository", this.repo == null ? null : this.repo.getName()).set("id", id.toString()).set("root", this.getStoreLocation().toString()).addAll(this.extraInfoElements.children()).build()).build();
        }
        NDefinitionFilter filter2 = (NDefinitionFilter)NDefinitionFilters.of().all(filter, NDefinitionFilters.of().byName(id.getShortName()));
        return this.findInFolder(this.getRelativeLocalGroupAndArtifactFile(id), filter2, deep ? Integer.MAX_VALUE : 1);
    }

    public NIterator<NId> searchImpl(NDefinitionFilter filter) {
        if (!this.isReadEnabled()) {
            return null;
        }
        return this.findInFolder(null, filter, Integer.MAX_VALUE);
    }

    public NIterator<NId> findInFolder(NPath folder, NDefinitionFilter filter, int maxDepth) {
        if (!this.isReadEnabled()) {
            return null;
        }
        return new NIdPathIterator(this.repo, this.rootPath, folder, filter, new NIdPathIteratorBase(){

            @Override
            public NWorkspace getWorkspace() {
                return NRepositoryFolderHelper.this.repo.getWorkspace();
            }

            @Override
            public void undeploy(NId id) throws NExecutionException {
                if (NRepositoryFolderHelper.this.repo == null) {
                    NRepositoryFolderHelper.this.undeploy(((NRepositoryUndeployCmd)new DefaultNRepositoryUndeployCmd().setFetchMode(NFetchMode.LOCAL)).setId(id));
                } else {
                    NRepositorySPI repoSPI = NWorkspaceUtils.of().toRepositorySPI(NRepositoryFolderHelper.this.repo);
                    repoSPI.undeploy().setId(id).run();
                }
            }

            @Override
            public boolean isDescFile(NPath pathname) {
                return pathname.getName().endsWith(".nuts");
            }

            @Override
            public NDescriptor parseDescriptor(NPath pathname, InputStream in, NFetchMode fetchMode, NRepository repository, NPath rootURL) {
                if (NRepositoryFolderHelper.this.cacheFolder && CoreIOUtils.isObsoletePath(pathname)) {
                    return null;
                }
                return NDescriptorParser.of().parse(pathname).get();
            }
        }, maxDepth, this.kind, this.extraInfoElements, true);
    }

    public NPath getStoreLocation() {
        return this.rootPath;
    }

    public NId searchLatestVersion(NId id, NDefinitionFilter filter) {
        NPath[] versionFolders;
        if (!this.isReadEnabled()) {
            return null;
        }
        NId bestId = null;
        NPath file = this.getLocalGroupAndArtifactFile(id);
        if (file.exists() && (versionFolders = (NPath[])((NStream)file.stream().filter(NPath::isDirectory).redescribe(NElementDescribables.ofDesc("idDirectory"))).toArray(NPath[]::new)) != null) {
            for (NPath versionFolder : versionFolders) {
                if (this.pathExists(versionFolder)) {
                    NId id2 = id.builder().setVersion(versionFolder.getName()).build();
                    if (bestId != null && id2.getVersion().compareTo(bestId.getVersion()) <= 0 || filter != null && !filter.acceptDefinition(NDefinitionHelper.ofIdOnlyFromRepo(id2, this.repo, "NRepositoryFolderHelper"))) continue;
                    bestId = id2;
                    continue;
                }
                versionFolder.deleteTree();
            }
        }
        return bestId;
    }

    public NDescriptor deploy(NDeployRepositoryCmd deployment, NConfirmationMode writeType) {
        NPath pckFile;
        if (!this.isWriteEnabled()) {
            throw new NIllegalArgumentException(NMsg.ofPlain("read-only repository"));
        }
        NDescriptor descriptor = deployment.getDescriptor();
        NId id = deployment.getId();
        if (id == null) {
            id = descriptor.getId();
        }
        CoreNIdUtils.checkLongId(id);
        NInputSource inputSource = null;
        if (deployment.getContent() == null) {
            if (!descriptor.isNoContent()) {
                NAssert.requireNonNull(deployment.getContent(), () -> NMsg.ofC("invalid deployment; missing content for %s", deployment.getId()));
            }
        } else {
            inputSource = NInputSource.ofMultiRead(deployment.getContent());
            inputSource.getMetaData().setKind("package content");
            if (descriptor == null) {
                try (CharacterizedExecFile c = DefaultNExecCmd.characterizeForExec(inputSource, null);){
                    if (c.getDescriptor() == null) {
                        throw new NArtifactNotFoundException(null, NMsg.ofC("unable to resolve a valid descriptor for %s", deployment.getContent()), null);
                    }
                    descriptor = c.getDescriptor();
                }
            }
        }
        if (this.isDeployed(id, descriptor)) {
            NId finalId = id;
            if (!DefaultWriteTypeProcessor.of(writeType).ask(NMsg.ofC("override deployment for %s?", id)).withLog(this._LOG(), NMsg.ofC("nuts deployment overridden %s", id)).onError(() -> new NAlreadyDeployedException(finalId)).process()) {
                return descriptor;
            }
        }
        switch (writeType) {
            case ERROR: 
            case ASK: {
                writeType = NConfirmationMode.NO;
            }
        }
        this.deployDescriptor(id, descriptor, writeType);
        NPath nPath = pckFile = inputSource == null ? null : this.deployContent(id, inputSource, descriptor, writeType);
        if (this.repo != null) {
            NRepositoryHelper.of(this.repo).events().fireOnDeploy(new DefaultNContentEvent(pckFile, deployment, this.repo.getWorkspace().currentSession(), this.repo));
        }
        return descriptor.builder().setId(id.getLongId()).build();
    }

    protected NLog _LOG() {
        return NLog.of(DefaultNFetchContentRepositoryCmd.class);
    }

    public NPath deployDescriptor(NId id, NDescriptor desc, NConfirmationMode writeType) {
        if (!this.isWriteEnabled()) {
            throw new NIllegalArgumentException(NMsg.ofPlain("read only repository"));
        }
        CoreNIdUtils.checkLongId(id);
        NPath descFile = this.getLongIdLocalFile(id.builder().setFaceDescriptor().build());
        if (descFile.exists() && !DefaultWriteTypeProcessor.of(writeType).ask(NMsg.ofC("override descriptor file for %s?", id)).withLog(this._LOG(), NMsg.ofC("nuts descriptor file overridden %s", id)).onError(() -> new NAlreadyDeployedException(id)).process()) {
            return descFile;
        }
        return NLock.ofId(id).callWith(() -> {
            NDescriptorFormat.ofPlain(desc).print(descFile);
            byte[] bytes = NDigest.of().sha1().setSource(desc).computeString().getBytes();
            NCp.of().from(NInputSource.of(bytes, (NContentMetadata)new DefaultNContentMetadata(NMsg.ofC("sha1://%s", desc.getId()), Long.valueOf(bytes.length), "text/sha-1", StandardCharsets.UTF_8.name(), "descriptor hash"))).to(descFile.resolveSibling(descFile.getName() + ".sha1")).addOptions(NPathOption.SAFE).run();
            return descFile;
        });
    }

    public boolean isDeployed(NId id, NDescriptor descriptor) {
        NPath pckFile = this.getLongIdLocalFile(id.builder().setFaceContent().setPackaging(descriptor.getPackaging()).build());
        if (!pckFile.exists() || this.cacheFolder && CoreIOUtils.isObsoletePath(pckFile)) {
            return false;
        }
        NPath descFile = this.getLongIdLocalFile(id.builder().setFaceDescriptor().build());
        return descFile.exists() && (!this.cacheFolder || !CoreIOUtils.isObsoletePath(descFile));
    }

    public NPath deployContent(NId id, NInputSource content, NDescriptor descriptor, NConfirmationMode writeType) {
        if (!this.isWriteEnabled()) {
            return null;
        }
        CoreNIdUtils.checkLongId(id);
        NPath pckFile = this.getLongIdLocalFile(id.builder().setFaceContent().setPackaging(descriptor.getPackaging()).build());
        if (pckFile.exists()) {
            if (content instanceof NPath && ((NPath)content).equals(pckFile)) {
                return pckFile;
            }
            if (!DefaultWriteTypeProcessor.of(writeType).ask(NMsg.ofC("override content file for %s?", id)).withLog(this._LOG(), NMsg.ofC("nuts content file overridden %s", id)).onError(() -> new NAlreadyDeployedException(id)).process()) {
                return pckFile;
            }
        }
        return NLock.ofId(id).callWith(() -> {
            NCp.of().from(content).to(pckFile).addOptions(NPathOption.SAFE).run();
            NCp.of().from(CoreIOUtils.createBytesStream(NDigestUtils.evalSHA1Hex(pckFile).getBytes(), NMsg.ofC("sha1://%s", id), "text/sha-1", StandardCharsets.UTF_8.name(), null)).to(pckFile.resolveSibling(pckFile.getName() + ".sha1")).addOptions(NPathOption.SAFE).run();
            return pckFile;
        });
    }

    public boolean undeploy(NRepositoryUndeployCmd command) {
        if (!this.isWriteEnabled()) {
            return false;
        }
        NPath localFolder = this.getLongIdLocalFile(command.getId().builder().setFaceContent().build());
        if (localFolder != null && localFolder.exists() && NLock.of(localFolder).callWith(() -> {
            localFolder.deleteTree();
            return false;
        }).booleanValue() && this.repo != null) {
            NRepositoryHelper.of(this.repo).events().fireOnUndeploy(new DefaultNContentEvent(localFolder, command, this.repo.getWorkspace().currentSession(), this.repo));
            return true;
        }
        return true;
    }

    public void reindexFolder() {
        this.reindexFolder(this.getStoreLocation());
    }

    private boolean reindexFolder(NPath path) {
        if (!this.isWriteEnabled()) {
            return false;
        }
        try {
            final Path start = path.toPath().get();
            Files.walkFileTree(start, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (dir.toString().startsWith(start.resolve(".git").toString() + "/") || dir.toString().equals(start.resolve(".git").toString())) {
                        return FileVisitResult.CONTINUE;
                    }
                    File folder = dir.toFile();
                    File[] children = folder.listFiles();
                    TreeSet<String> files = new TreeSet<String>();
                    TreeSet<String> folders = new TreeSet<String>();
                    if (children != null) {
                        for (File child : children) {
                            if (child.getName().startsWith(".")) continue;
                            if (child.isDirectory()) {
                                folders.add(child.getName());
                                continue;
                            }
                            if (!child.isFile()) continue;
                            files.add(child.getName());
                        }
                    }
                    try (PrintStream p = new PrintStream(new File(folder, ".files"));){
                        p.println("#version=" + NWorkspace.of().getApiVersion());
                        for (String file : folders) {
                            p.println(file + "/");
                        }
                        for (String file : files) {
                            p.println(file);
                        }
                    }
                    catch (FileNotFoundException e) {
                        throw new NIOException(e);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
        return true;
    }

    private boolean pathExists(NPath p) {
        return p.exists() && (!this.cacheFolder || !CoreIOUtils.isObsoletePath(p));
    }
}

