/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryFilter;
import net.thevpc.nuts.runtime.standalone.dependency.util.NComplexExpressionString;
import net.thevpc.nuts.runtime.standalone.repository.filter.AbstractRepositoryFilter;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.util.NFilter;
import net.thevpc.nuts.util.NFilterOp;

public class NRepositoryFilterAnd
extends AbstractRepositoryFilter
implements NComplexExpressionString {
    private NRepositoryFilter[] all;

    public NRepositoryFilterAnd(NRepositoryFilter ... all) {
        super(NFilterOp.AND);
        ArrayList<NRepositoryFilter> valid = new ArrayList<NRepositoryFilter>();
        if (all != null) {
            for (NRepositoryFilter filter : all) {
                if (filter == null) continue;
                valid.add(filter);
            }
        }
        this.all = valid.toArray(new NRepositoryFilter[0]);
    }

    @Override
    public boolean acceptRepository(NRepository id) {
        if (this.all.length == 0) {
            return true;
        }
        for (NRepositoryFilter filter : this.all) {
            if (filter.acceptRepository(id)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NRepositoryFilter simplify() {
        return CoreFilterUtils.simplifyFilterAnd(NRepositoryFilter.class, this, this.all);
    }

    public String toString() {
        return CoreStringUtils.trueOrAnd(Arrays.stream(this.all).map(NComplexExpressionString::toString).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NRepositoryFilterAnd that = (NRepositoryFilterAnd)o;
        return Arrays.equals(this.all, that.all);
    }

    public int hashCode() {
        return Arrays.hashCode(this.all);
    }

    @Override
    public List<NFilter> getSubFilters() {
        return Arrays.asList(this.all);
    }
}

