/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.filter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.core.NRepositoryFilter;
import net.thevpc.nuts.core.NRepositoryFilters;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.repository.filter.DefaultNRepositoryNameFilter;
import net.thevpc.nuts.runtime.standalone.repository.filter.DefaultNRepositorySelectorFilter;
import net.thevpc.nuts.runtime.standalone.repository.filter.DefaultNRepositoryUuidFilter;
import net.thevpc.nuts.runtime.standalone.repository.filter.NRepositoryFilterAnd;
import net.thevpc.nuts.runtime.standalone.repository.filter.NRepositoryFilterFalse;
import net.thevpc.nuts.runtime.standalone.repository.filter.NRepositoryFilterNone;
import net.thevpc.nuts.runtime.standalone.repository.filter.NRepositoryFilterOr;
import net.thevpc.nuts.runtime.standalone.repository.filter.NRepositoryFilterParser;
import net.thevpc.nuts.runtime.standalone.repository.filter.NRepositoryFilterTrue;
import net.thevpc.nuts.runtime.standalone.util.filters.InternalNTypedFilters;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NFilter;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NScorableContext;

public class InternalNRepositoryFilters
extends InternalNTypedFilters<NRepositoryFilter>
implements NRepositoryFilters {
    public InternalNRepositoryFilters(NWorkspace workspace) {
        super(NRepositoryFilter.class);
    }

    @Override
    public NRepositoryFilter always() {
        return new NRepositoryFilterTrue();
    }

    @Override
    public NRepositoryFilter never() {
        return new NRepositoryFilterFalse();
    }

    @Override
    public NRepositoryFilter not(NFilter other) {
        return new NRepositoryFilterNone((NRepositoryFilter)other);
    }

    @Override
    public NRepositoryFilter installedRepo() {
        return new DefaultNRepositoryUuidFilter(Arrays.asList("<main>"));
    }

    @Override
    public NRepositoryFilter byName(String[] names) {
        if (names == null || names.length == 0) {
            return this.always();
        }
        List<String> namesList = Arrays.asList(names).stream().filter(x -> !NBlankable.isBlank(x)).map(String::trim).collect(Collectors.toList());
        if (namesList.isEmpty()) {
            return this.always();
        }
        return new DefaultNRepositoryNameFilter(namesList);
    }

    @Override
    public NRepositoryFilter bySelector(String[] names) {
        if (names == null || names.length == 0) {
            return this.always();
        }
        List<String> namesList = Arrays.asList(names).stream().filter(x -> !NBlankable.isBlank(x)).map(x -> {
            String i = x.trim();
            switch (i.charAt(0)) {
                case '+': 
                case '-': 
                case '=': {
                    return i;
                }
            }
            return "=" + i;
        }).collect(Collectors.toList());
        if (namesList.isEmpty()) {
            return this.always();
        }
        return new DefaultNRepositorySelectorFilter(namesList);
    }

    @Override
    public NRepositoryFilter byNameSelector(String ... names) {
        if (names == null || names.length == 0) {
            return this.always();
        }
        List<String> namesList = Arrays.asList(names).stream().filter(x -> !NBlankable.isBlank(x)).map(x -> {
            String v = x.trim();
            char s = v.charAt(0);
            switch (s) {
                case '+': 
                case '-': 
                case '=': {
                    return v;
                }
            }
            return '+' + v;
        }).collect(Collectors.toList());
        if (namesList.isEmpty()) {
            return this.always();
        }
        return new DefaultNRepositorySelectorFilter(namesList);
    }

    @Override
    public NRepositoryFilter byUuid(String ... uuids) {
        if (uuids == null || uuids.length == 0) {
            return this.always();
        }
        return new DefaultNRepositoryUuidFilter(Arrays.asList(uuids));
    }

    @Override
    public NRepositoryFilter as(NFilter a) {
        if (a instanceof NRepositoryFilter) {
            return (NRepositoryFilter)a;
        }
        return null;
    }

    @Override
    public NRepositoryFilter from(NFilter a) {
        if (a == null) {
            return null;
        }
        NRepositoryFilter t = this.as(a);
        if (t == null) {
            throw new NIllegalArgumentException(NMsg.ofPlain("not a RepositoryFilter"));
        }
        return t;
    }

    @Override
    public NRepositoryFilter all(NFilter ... others) {
        List<NRepositoryFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NRepositoryFilter)all.get(0);
        }
        return new NRepositoryFilterAnd(all.toArray(new NRepositoryFilter[0]));
    }

    @Override
    public NRepositoryFilter any(NFilter ... others) {
        List<NRepositoryFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NRepositoryFilter)all.get(0);
        }
        return new NRepositoryFilterOr(all.toArray(new NRepositoryFilter[0]));
    }

    @Override
    public NRepositoryFilter none(NFilter ... others) {
        List<NRepositoryFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        return new NRepositoryFilterNone(all.toArray(new NRepositoryFilter[0]));
    }

    @Override
    public NRepositoryFilter parse(String expression) {
        return (NRepositoryFilter)new NRepositoryFilterParser(expression).parse();
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

