/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryFilter;
import net.thevpc.nuts.core.NRepositoryFilters;
import net.thevpc.nuts.runtime.standalone.repository.filter.AbstractRepositoryFilter;
import net.thevpc.nuts.runtime.standalone.xtra.glob.GlobUtils;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NFilterOp;

public class DefaultNRepositoryNameFilter
extends AbstractRepositoryFilter {
    private final Set<String> exactRepos = new HashSet<String>();
    private final Set<Pattern> wildcardRepos = new HashSet<Pattern>();

    public DefaultNRepositoryNameFilter(Collection<String> exactRepos) {
        super(NFilterOp.CUSTOM);
        for (String repo : exactRepos == null ? new ArrayList() : exactRepos) {
            if (NBlankable.isBlank(repo)) continue;
            if (repo.indexOf(42) > 0) {
                this.wildcardRepos.add(GlobUtils.ofExact(repo));
                continue;
            }
            if (repo.length() > 2 && repo.startsWith("/") && repo.endsWith("/")) {
                this.wildcardRepos.add(Pattern.compile(repo.substring(1, repo.length() - 1)));
                continue;
            }
            this.exactRepos.add(repo);
        }
    }

    @Override
    public boolean acceptRepository(NRepository repository) {
        if (this.exactRepos.isEmpty() && this.wildcardRepos.isEmpty()) {
            return true;
        }
        if (this.exactRepos.contains(repository.getUuid()) || this.exactRepos.contains(repository.getName())) {
            return true;
        }
        for (Pattern wildcardRepo : this.wildcardRepos) {
            if (!wildcardRepo.matcher(repository.getName()).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public NRepositoryFilter simplify() {
        if (this.exactRepos.isEmpty() && this.wildcardRepos.isEmpty()) {
            return (NRepositoryFilter)NRepositoryFilters.of().always();
        }
        return this;
    }

    public String toString() {
        return "NRepositoryFilter{repos=" + this.exactRepos + " ; " + this.wildcardRepos + '}';
    }

    public int hashCode() {
        int hash = this.getClass().getName().hashCode();
        hash = 41 * hash + Objects.hashCode(this.exactRepos);
        hash = 41 * hash + Objects.hashCode(this.wildcardRepos);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNRepositoryNameFilter other = (DefaultNRepositoryNameFilter)obj;
        if (!Objects.equals(this.exactRepos, other.exactRepos)) {
            return false;
        }
        return Objects.equals(this.wildcardRepos, other.wildcardRepos);
    }
}

