/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.config;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NIndexStore;
import net.thevpc.nuts.core.NInvalidRepositoryException;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryConfig;
import net.thevpc.nuts.core.NRepositoryConfigManager;
import net.thevpc.nuts.core.NRepositoryListener;
import net.thevpc.nuts.core.NRepositoryNotFoundException;
import net.thevpc.nuts.core.NRepositoryRef;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NSpeedQualifier;
import net.thevpc.nuts.core.NStoreStrategy;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.repository.NRepositoryHelper;
import net.thevpc.nuts.runtime.standalone.repository.NRepositoryRegistryHelper;
import net.thevpc.nuts.runtime.standalone.repository.NRepositoryTagsListHelper;
import net.thevpc.nuts.runtime.standalone.repository.config.AbstractNRepositoryConfigModel;
import net.thevpc.nuts.runtime.standalone.repository.config.DefaultNRepoConfigManager;
import net.thevpc.nuts.runtime.standalone.repository.config.DefaultNRepositoryEvent;
import net.thevpc.nuts.runtime.standalone.repository.config.NRepositoryConfigModel;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryExt;
import net.thevpc.nuts.runtime.standalone.repository.util.NRepositoryUtils;
import net.thevpc.nuts.runtime.standalone.util.NSpeedQualifiers;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.NRepositoryConfigManagerExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.NStoreLocationsMap;
import net.thevpc.nuts.security.NUserConfig;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NPositionType;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NException;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NUnsupportedOperationException;

public class DefaultNRepositoryConfigModel
extends AbstractNRepositoryConfigModel {
    private final NRepository repository;
    private final NSpeedQualifier speed;
    private final NPath storeLocation;
    private NRepositoryConfig config;
    private final Map<String, NUserConfig> configUsers = new LinkedHashMap<String, NUserConfig>();
    private boolean configurationChanged = false;
    private int deployWeight;
    private boolean temporary;
    private String globalName;
    private boolean supportedMirroring;
    private final NRepositoryRegistryHelper repositoryRegistryHelper;
    private String repositoryName;
    private String repositoryType;
    private NWorkspace workspace;
    private NRepositoryRef repositoryRef;

    public DefaultNRepositoryConfigModel(NRepository repository, NAddRepositoryOptions options, NWorkspace workspace, NSpeedQualifier speed, boolean supportedMirroring, String repositoryType) {
        this.workspace = workspace;
        NAssert.requireNonNull(options, "repository options");
        NAssert.requireNonNull(options.getConfig(), "repository options config");
        this.repositoryRef = NRepositoryUtils.optionsToRef(options);
        String storeLocation = options.getLocation();
        NRepositoryConfig config = options.getConfig();
        String globalName = options.getConfig().getName();
        String repositoryName = options.getName();
        speed = speed == null ? NSpeedQualifier.NORMAL : speed;
        NAssert.requireNonBlank(repositoryType, "repository type");
        NAssert.requireNonBlank(repositoryName, "repository name");
        NAssert.requireNonBlank(globalName, "repository global name");
        NAssert.requireNonBlank(storeLocation, "repository store location");
        Path pfolder = Paths.get(storeLocation, new String[0]);
        if (Files.exists(pfolder, new LinkOption[0]) && !Files.isDirectory(pfolder, new LinkOption[0])) {
            throw new NInvalidRepositoryException(storeLocation, NMsg.ofC("unable to resolve root as a valid folder %s", storeLocation));
        }
        this.repositoryRegistryHelper = new NRepositoryRegistryHelper();
        this.repository = repository;
        this.repositoryName = repositoryName;
        this.globalName = globalName;
        this.storeLocation = NPath.of(storeLocation).toAbsolute(NWorkspaceExt.of().getConfigModel().getRepositoriesRoot());
        this.speed = speed;
        this.deployWeight = options.getDeployWeight();
        this.temporary = options.isTemporary();
        this.tags.addAll(new NRepositoryTagsListHelper().add(options.getConfig().getTags()).toSet());
        this.supportedMirroring = supportedMirroring;
        this.repositoryType = repositoryType;
        this.setConfig(config, false);
    }

    protected NLog _LOG() {
        return NLog.of(DefaultNRepositoryConfigModel.class);
    }

    @Override
    public NRepository getRepository() {
        return this.repository;
    }

    @Override
    public NWorkspace getWorkspace() {
        return this.repository.getWorkspace();
    }

    @Override
    public NRepositoryRef getRepositoryRef() {
        return new NRepositoryRef(this.repositoryRef);
    }

    @Override
    public String getName() {
        return this.repositoryName;
    }

    @Override
    public int getDeployWeight() {
        return this.deployWeight;
    }

    public void setEnv(String property, String value) {
        if (NBlankable.isBlank(value)) {
            if (this.config.getEnv() != null) {
                this.config.getEnv().remove(property);
                this.fireConfigurationChanged("env");
            }
        } else {
            if (this.config.getEnv() == null) {
                this.config.setEnv(new LinkedHashMap<String, String>());
            }
            if (!value.equals(this.config.getEnv().get(property))) {
                this.config.getEnv().put(property, value);
                this.fireConfigurationChanged("env");
            }
        }
    }

    @Override
    public NSpeedQualifier getSpeed() {
        ArrayList<NSpeedQualifier> all = new ArrayList<NSpeedQualifier>();
        boolean unavailable = false;
        if (this.speed == NSpeedQualifier.UNAVAILABLE) {
            unavailable = true;
        } else {
            all.add(this.speed);
        }
        if (this.isSupportedMirroring()) {
            for (NRepository mirror : this.getMirrors()) {
                NSpeedQualifier mspeed = mirror.config().getSpeed();
                if (mspeed == NSpeedQualifier.UNAVAILABLE) {
                    unavailable = true;
                    continue;
                }
                all.add(mspeed);
            }
        }
        if (all.isEmpty()) {
            if (unavailable) {
                return NSpeedQualifier.UNAVAILABLE;
            }
            return NSpeedQualifier.NORMAL;
        }
        return NSpeedQualifiers.max(all.toArray(new NSpeedQualifier[0]));
    }

    @Override
    public String getType() {
        return this.repositoryType;
    }

    @Override
    public String getGroups() {
        return this.config.getGroups();
    }

    @Override
    public NRepositoryLocation getLocation() {
        NRepositoryLocation loc = this.config.getLocation();
        if (loc == null) {
            loc = NRepositoryLocation.of(null);
        }
        String name = this.config.getName();
        return loc.setName(name);
    }

    @Override
    public NPath getLocationPath() {
        String s = NStringUtils.trimToNull(this.config.getLocation().getPath());
        if (s != null) {
            return NPath.of(s).toAbsolute(NWorkspace.of().getWorkspaceLocation());
        }
        return null;
    }

    @Override
    public NPath getStoreLocation() {
        return this.storeLocation;
    }

    @Override
    public NStoreStrategy getStoreStrategy() {
        NStoreStrategy strategy = this.config.getStoreStrategy();
        if (strategy == null) {
            strategy = NStoreStrategy.values()[0];
        }
        return strategy;
    }

    @Override
    public NPath getStoreLocation(NStoreType folderType) {
        NStoreLocationsMap hlm = new NStoreLocationsMap(this.config.getStoreLocations());
        String n = hlm.get(folderType);
        if (this.temporary) {
            if (NBlankable.isBlank(n)) {
                n = folderType.toString().toLowerCase();
                n = n.trim();
            }
            return this.getStoreLocation().resolve(n);
        }
        switch (this.getStoreStrategy()) {
            case STANDALONE: {
                if (NBlankable.isBlank(n)) {
                    n = folderType.toString().toLowerCase();
                }
                n = n.trim();
                return this.getStoreLocation().resolve(n);
            }
            case EXPLODED: {
                NPath storeLocation = NPath.ofWorkspaceStore(folderType);
                return storeLocation.resolve("repos").resolve(this.getName()).resolve(this.getUuid());
            }
        }
        throw new NIllegalArgumentException(NMsg.ofC("unsupported strategy type %s", this.getStoreLocation()));
    }

    @Override
    public String getUuid() {
        return this.config.getUuid();
    }

    public void setConfig(NRepositoryConfig newConfig, boolean fireChange) {
        NAssert.requireNonBlank(newConfig, "repository config");
        this.config = newConfig;
        if (this.config.getUuid() == null) {
            fireChange = true;
            this.config.setUuid(UUID.randomUUID().toString());
        }
        if (this.config.getStoreStrategy() == null) {
            fireChange = true;
            this.config.setStoreStrategy(NWorkspace.of().getRepositoryStoreStrategy());
        }
        if (this.config.getLocation() != null && !NBlankable.isBlank(this.config.getLocation().getLocationType()) && !Objects.equals(this.config.getLocation().getLocationType(), this.repositoryType)) {
            throw new NIllegalArgumentException(NMsg.ofC("invalid Repository Type : expected %s, found %s", this.repositoryType, NRepositoryUtils.getRepoType(this.config)));
        }
        this.tags.clear();
        if (this.config.getTags() != null) {
            for (String tag : this.config.getTags()) {
                if (NBlankable.isBlank(tag)) continue;
                this.tags.add(NStringUtils.trim(tag));
            }
        }
        this.globalName = newConfig.getName();
        this.configUsers.clear();
        if (this.config.getUsers() != null) {
            for (NUserConfig user : this.config.getUsers()) {
                this.configUsers.put(user.getUser(), user);
            }
        }
        this.removeAllMirrors();
        if (this.config.getMirrors() != null) {
            for (NRepositoryRef ref : this.config.getMirrors()) {
                NRepository r = NWorkspaceExt.of().getRepositoryModel().createRepository(NRepositoryUtils.refToOptions(ref), this.repository);
                this.addMirror(r);
            }
        }
        if (fireChange) {
            this.fireConfigurationChanged("*");
        }
    }

    @Override
    public void addMirror(NRepository repo) {
        this.repositoryRegistryHelper.addRepository(repo);
        NSession session = this.repository.getWorkspace().currentSession();
        NRepositoryHelper.of(this.repository).events().fireOnAddRepository(new DefaultNRepositoryEvent(session, this.repository, repo, "mirror", null, repo));
    }

    @Override
    public void setIndexEnabled(boolean enabled) {
        if (enabled != this.config.isIndexEnabled()) {
            this.config.setIndexEnabled(enabled);
            this.fireConfigurationChanged("index-enabled");
        }
    }

    @Override
    public boolean isIndexEnabled() {
        return this.config.isIndexEnabled();
    }

    @Override
    public void setUser(NUserConfig user) {
        this.configUsers.put(user.getUser(), user);
        this.fireConfigurationChanged("user");
    }

    @Override
    public void removeUser(String userId) {
        if (this.configUsers.containsKey(userId)) {
            this.configUsers.remove(userId);
            this.fireConfigurationChanged("user");
        }
    }

    @Override
    public NOptional<NUserConfig> findUser(String userId) {
        NUserConfig u = this.configUsers.get(userId);
        if (u == null && ("admin".equals(userId) || "anonymous".equals(userId))) {
            u = new NUserConfig(userId, null, null, null);
            this.configUsers.put(userId, u);
            this.fireConfigurationChanged("user");
        }
        return NOptional.ofNamed(u, "user " + userId);
    }

    @Override
    public NUserConfig[] findUsers() {
        return this.configUsers.values().toArray(new NUserConfig[0]);
    }

    @Override
    public void setMirrorEnabled(String repoName, boolean enabled) {
        NRepositoryRef e = this.repositoryRegistryHelper.findRepositoryRef(repoName);
        if (e != null && e.isEnabled() != enabled) {
            e.setEnabled(enabled);
            this.fireConfigurationChanged("mirror");
        }
    }

    @Override
    public boolean save(boolean force) {
        boolean ok = false;
        if (force || !NWorkspace.of().isReadOnly() && this.isConfigurationChanged()) {
            NWorkspaceUtils.of().checkReadOnly();
            this.repository.security().checkAllowed("save", "save");
            this.config.setConfigVersion(DefaultNWorkspace.VERSION_REPOSITORY_CONFIG);
            if (this.config.getEnv() != null && this.config.getEnv().isEmpty()) {
                this.config.setEnv(null);
            }
            this.config.setTags(this.tags.toArray(new String[0]));
            this.config.setMirrors(Arrays.asList(this.repositoryRegistryHelper.getRepositoryRefs()));
            this.config.setUsers((List<NUserConfig>)(this.configUsers.isEmpty() ? null : new ArrayList<NUserConfig>(this.configUsers.values())));
            boolean created = ((NWorkspaceExt)((Object)this.workspace)).store().saveRepoConfig(this.repository, this.config);
            this.configurationChanged = false;
            if (this._LOG().isLoggable(Level.CONFIG)) {
                if (created) {
                    this._LOG().log(NMsg.ofC("%s created repository %s at %s", NStringUtils.formatAlign(this.repository.getName(), 20, NPositionType.FIRST), this.repository.getName(), this.getStoreLocation()).withLevel(Level.CONFIG).withIntent(NMsgIntent.SUCCESS));
                } else {
                    this._LOG().log(NMsg.ofC("%s updated repository %s at %s", NStringUtils.formatAlign(this.repository.getName(), 20, NPositionType.FIRST), this.repository.getName(), this.getStoreLocation()).withLevel(Level.CONFIG).withIntent(NMsgIntent.SUCCESS));
                }
            }
            ok = true;
        }
        NException error = null;
        for (NRepository repo : this.getMirrors()) {
            try {
                NRepositoryConfigManager config = repo.config();
                if (!(config instanceof NRepositoryConfigManagerExt)) continue;
                ok |= ((NRepositoryConfigManagerExt)((Object)config)).getModel().save(force);
            }
            catch (NException ex) {
                error = ex;
            }
        }
        if (error != null) {
            throw error;
        }
        return ok;
    }

    public void save() {
        this.save(true);
    }

    @Override
    public void fireConfigurationChanged(String configName) {
        this.configurationChanged = true;
        NSession session = this.repository.getWorkspace().currentSession();
        DefaultNRepositoryEvent evt = new DefaultNRepositoryEvent(session, null, this.repository, "config." + configName, null, true);
        for (NRepositoryListener workspaceListener : this.repository.getRepositoryListeners()) {
            workspaceListener.onConfigurationChanged(evt);
        }
    }

    public boolean isConfigurationChanged() {
        return this.configurationChanged;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.repositoryRef.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.repositoryRef.isEnabled();
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public void setTemporary(boolean transientRepository) {
        this.temporary = transientRepository;
    }

    @Override
    public boolean isIndexSubscribed() {
        NIndexStore s = this.getIndexStore();
        return s != null && s.isSubscribed();
    }

    private NIndexStore getIndexStore() {
        return NRepositoryExt.of(this.repository).getIndexStore();
    }

    @Override
    public void subscribeIndex() {
        NIndexStore s = this.getIndexStore();
        if (s != null) {
            s.subscribe();
        }
    }

    @Override
    public void unsubscribeIndex() {
        NIndexStore s = this.getIndexStore();
        if (s != null) {
            s.unsubscribe();
        }
    }

    @Override
    public String getGlobalName() {
        return this.globalName;
    }

    @Override
    public boolean isSupportedMirroring() {
        return this.supportedMirroring;
    }

    @Override
    public void removeMirror(String repositoryId) {
        if (!this.isSupportedMirroring()) {
            throw new NUnsupportedOperationException(NMsg.ofC("unsupported operation '%s'", "removeMirror"));
        }
        NSession session = this.repository.getWorkspace().currentSession();
        this.repository.security().checkAllowed("remove-repo", "remove-repository");
        NRepository r = this.repositoryRegistryHelper.removeRepository(repositoryId);
        if (r == null) {
            throw new NRepositoryNotFoundException(repositoryId);
        }
        NRepositoryHelper.of(this.repository).events().fireOnRemoveRepository(new DefaultNRepositoryEvent(session, this.repository, r, "mirror", r, null));
    }

    @Override
    public NRepository getMirror(String repositoryIdPath) {
        NRepository r = this.findMirror(repositoryIdPath);
        if (r != null) {
            return r;
        }
        throw new NRepositoryNotFoundException(repositoryIdPath);
    }

    @Override
    public NRepository findMirror(String repositoryNameOrId) {
        NSession session = this.repository.getWorkspace().currentSession();
        NRepository y = this.repositoryRegistryHelper.findRepository(repositoryNameOrId);
        if (y != null) {
            return y;
        }
        if (session.isTransitive() && this.isSupportedMirroring()) {
            for (NRepository mirror : this.getMirrors()) {
                NRepository m = session.copy().setTransitive(true).callWith(() -> mirror.config().findMirror(repositoryNameOrId));
                if (m == null) continue;
                if (y == null) {
                    y = m;
                    continue;
                }
                throw new NIllegalArgumentException(NMsg.ofC("ambiguous repository name %s ; found two Ids %s and %s", repositoryNameOrId, y.getUuid(), m.getUuid()));
            }
        }
        return y;
    }

    @Override
    public NRepository findMirrorById(String repositoryNameOrId) {
        NRepository y = this.repositoryRegistryHelper.findRepositoryById(repositoryNameOrId);
        if (y != null) {
            return y;
        }
        NSession session = this.repository.getWorkspace().currentSession();
        if (session.isTransitive() && this.isSupportedMirroring()) {
            for (NRepository mirror : this.getMirrors()) {
                NRepository m = session.copy().setTransitive(true).callWith(() -> mirror.config().findMirrorById(repositoryNameOrId));
                if (m == null) continue;
                if (y == null) {
                    y = m;
                    continue;
                }
                throw new NIllegalArgumentException(NMsg.ofC("ambiguous repository name %s ; found two Ids %s and %s", repositoryNameOrId, y.getUuid(), m.getUuid()));
            }
        }
        return y;
    }

    @Override
    public NRepository findMirrorByName(String repositoryNameOrId) {
        NRepository y = this.repositoryRegistryHelper.findRepositoryByName(repositoryNameOrId);
        if (y != null) {
            return y;
        }
        NSession session = this.repository.getWorkspace().currentSession();
        if (session.isTransitive() && this.isSupportedMirroring()) {
            for (NRepository mirror : this.getMirrors()) {
                NRepository m = session.copy().setTransitive(true).callWith(() -> mirror.config().findMirrorByName(repositoryNameOrId));
                if (m == null) continue;
                if (y == null) {
                    y = m;
                    continue;
                }
                throw new NIllegalArgumentException(NMsg.ofC("ambiguous repository name %s ; found two Ids %s and %s", repositoryNameOrId, y.getUuid(), m.getUuid()));
            }
        }
        return y;
    }

    @Override
    public List<NRepository> getMirrors() {
        return Arrays.asList(this.repositoryRegistryHelper.getRepositories());
    }

    @Override
    public NRepository addMirror(NAddRepositoryOptions options) {
        if (!this.isSupportedMirroring()) {
            throw new NUnsupportedOperationException(NMsg.ofC("unsupported operation '%s'", "addMirror"));
        }
        if (options.isTemporary()) {
            return null;
        }
        NRepository repo = NWorkspaceExt.of().getRepositoryModel().createRepository(options, this.repository);
        this.addMirror(repo);
        return repo;
    }

    @Override
    public NPath getTempMirrorsRoot() {
        return this.getStoreLocation().resolve("repos");
    }

    @Override
    public NPath getMirrorsRoot() {
        return this.getStoreLocation().resolve("repos");
    }

    @Override
    public NRepositoryConfig getStoredConfig() {
        return this.config;
    }

    public void removeAllMirrors() {
        for (NRepository repo : this.repositoryRegistryHelper.getRepositories()) {
            this.removeMirror(repo.getUuid());
        }
    }

    @Override
    public NRepositoryConfig getConfig() {
        return this.config;
    }

    @Override
    public Map<String, String> toMap(boolean inherit) {
        return this.config_getEnv(inherit);
    }

    @Override
    public Map<String, String> toMap() {
        return this.config_getEnv(true);
    }

    @Override
    public NOptional<NLiteral> get(String key, boolean inherit) {
        NOptional<NLiteral> o = this.config_getEnv(key, inherit);
        if (o.isBlank() && inherit) {
            return o.orElseUse(() -> NWorkspace.of().getConfigProperty(key));
        }
        return o;
    }

    @Override
    public void set(String property, String value) {
        this.config_setEnv(property, value);
    }

    private NRepositoryConfigModel getConfig0() {
        return ((DefaultNRepoConfigManager)this.repository.config()).getModel();
    }

    public NOptional<NLiteral> config_getEnv(String key, boolean inherit) {
        NRepositoryConfigModel model = ((DefaultNRepoConfigManager)this.repository.config()).getModel();
        NRepositoryConfig config = model.getConfig();
        String t = null;
        if (config.getEnv() != null) {
            t = config.getEnv().get(key);
        }
        if (!NBlankable.isBlank(t)) {
            return NOptional.of(NLiteral.of(t));
        }
        if (inherit) {
            return NWorkspace.of().getConfigProperty(key);
        }
        return NOptional.ofEmpty(() -> NMsg.ofC("repository property not found : %s", key));
    }

    private Map<String, String> config_getEnv(boolean inherit) {
        NRepositoryConfigModel model = ((DefaultNRepoConfigManager)this.repository.config()).getModel();
        NRepositoryConfig config = model.getConfig();
        LinkedHashMap<String, String> p = new LinkedHashMap<String, String>();
        if (inherit) {
            p.putAll(NWorkspace.of().getConfigMap());
        }
        if (config.getEnv() != null) {
            p.putAll(config.getEnv());
        }
        return p;
    }

    private void config_setEnv(String property, String value) {
        NRepositoryConfig config = this.getConfig();
        if (NBlankable.isBlank(value)) {
            if (config.getEnv() != null) {
                config.getEnv().remove(property);
                this.fireConfigurationChanged("env");
            }
        } else {
            if (config.getEnv() == null) {
                config.setEnv(new LinkedHashMap<String, String>());
            }
            if (!value.equals(config.getEnv().get(property))) {
                config.getEnv().put(property, value);
                this.fireConfigurationChanged("env");
            }
        }
    }
}

