/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.cmd.search;

import java.util.ArrayList;
import java.util.logging.Level;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.definition.NDefinitionHelper;
import net.thevpc.nuts.runtime.standalone.id.util.CoreNIdUtils;
import net.thevpc.nuts.runtime.standalone.repository.cmd.search.AbstractNSearchVersionsRepositoryCmd;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryExt;
import net.thevpc.nuts.spi.NSearchVersionsRepositoryCmd;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NPositionType;
import net.thevpc.nuts.util.NException;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBuilder;
import net.thevpc.nuts.util.NIteratorUtils;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNSearchVersionsRepositoryCmd
extends AbstractNSearchVersionsRepositoryCmd {
    public DefaultNSearchVersionsRepositoryCmd(NRepository repo) {
        super(repo);
    }

    protected NLog _LOG() {
        return NLog.of(DefaultNSearchVersionsRepositoryCmd.class);
    }

    @Override
    public NSearchVersionsRepositoryCmd run() {
        NSession session = this.getRepo().getWorkspace().currentSession();
        this.getRepo().security().checkAllowed("fetch-desc", "find-versions");
        NRepositoryExt xrepo = NRepositoryExt.of(this.getRepo());
        CoreNIdUtils.checkShortId(this.id);
        xrepo.checkAllowedFetch(this.id);
        try {
            NIterator<NId> rr;
            ArrayList resultList = new ArrayList();
            if (this.getFetchMode() == NFetchMode.REMOTE && session.isIndexed() && xrepo.getIndexStore() != null && xrepo.getIndexStore().isEnabled()) {
                NIterator<NId> d = null;
                try {
                    d = xrepo.getIndexStore().searchVersions(this.id);
                }
                catch (NException ex) {
                    this._LOG().log(NMsg.ofC("error finding version with Indexer for %s : %s", this.getRepo().getName(), ex).withLevel(Level.FINEST).withIntent(NMsgIntent.FAIL));
                }
                if (d != null && this.filter != null) {
                    resultList.add(NIteratorBuilder.of(d).filter(x -> this.filter.acceptDefinition(NDefinitionHelper.ofIdOnlyFromRepo(x, this.repo, "DefaultNSearchVersionsRepositoryCmd")), () -> NElementDescribables.describeResolveOrToString(this.filter)).safeIgnore().iterator());
                }
            }
            if ((rr = xrepo.searchVersionsImpl(this.id, this.getFilter(), this.getFetchMode())) != null) {
                resultList.add(rr);
            }
            this.result = NIteratorUtils.coalesce(resultList);
            return this;
        }
        catch (RuntimeException ex) {
            this._LOG().log(NMsg.ofC("[%s] %s %s %s", NStringUtils.formatAlign(this.getFetchMode().toString(), 7, NPositionType.FIRST), NStringUtils.formatAlign(this.getRepo().getName(), 20, NPositionType.FIRST), NStringUtils.formatAlign("Fetch versions for", 24, NPositionType.FIRST), this.id).withLevel(Level.FINEST).withIntent(NMsgIntent.FAIL));
            throw ex;
        }
    }

    @Override
    public NIterator<NId> getResult() {
        if (this.result == null) {
            this.run();
        }
        return this.result;
    }
}

