/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository.cmd.search;

import java.util.function.Supplier;
import java.util.logging.Level;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.concurrent.NRunnable;
import net.thevpc.nuts.core.NIndexerNotAccessibleException;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.repository.cmd.search.AbstractNSearchRepositoryCmd;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryExt;
import net.thevpc.nuts.spi.NSearchRepositoryCmd;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NPositionType;
import net.thevpc.nuts.util.NException;
import net.thevpc.nuts.util.NIndexFirstIterator;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBuilder;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNSearchRepositoryCmd
extends AbstractNSearchRepositoryCmd {
    public DefaultNSearchRepositoryCmd(NRepository repo) {
        super(repo);
    }

    protected NLog _LOG() {
        return NLog.of(DefaultNSearchRepositoryCmd.class);
    }

    @Override
    public NSearchRepositoryCmd run() {
        NSession session = this.getRepo().getWorkspace().currentSession();
        Object startRunnable = NRunnable.of(() -> {
            this.getRepo().security().checkAllowed("fetch-desc", "search");
            NRepositoryExt xrepo = NRepositoryExt.of(this.getRepo());
            xrepo.checkAllowedFetch(null);
            this._LOG().log(NMsg.ofJ("{0} search packages", NStringUtils.formatAlign(this.getRepo().getName(), 20, NPositionType.FIRST)).withLevel(Level.FINEST).withIntent(NMsgIntent.START));
        }).redescribe((Supplier)NElementDescribables.ofDesc("CheckAuthorizations"));
        Object endRunnable = NRunnable.of(() -> this._LOG().log(NMsg.ofJ("{0} search packages", NStringUtils.formatAlign(this.getRepo().getName(), 20, NPositionType.FIRST)).withLevel(Level.FINEST).withIntent(NMsgIntent.SUCCESS))).redescribe((Supplier)NElementDescribables.ofDesc("Log"));
        try {
            boolean processIndexFirst;
            NRepositoryExt xrepo = NRepositoryExt.of(this.getRepo());
            boolean bl = processIndexFirst = this.getFetchMode() == NFetchMode.REMOTE && session.isIndexed() && xrepo.getIndexStore() != null && xrepo.getIndexStore().isEnabled();
            if (processIndexFirst) {
                NIterator<NId> o = null;
                try {
                    o = xrepo.getIndexStore().search(this.filter);
                }
                catch (NIndexerNotAccessibleException nIndexerNotAccessibleException) {
                }
                catch (NException ex) {
                    this._LOG().log(NMsg.ofJ("error search operation using Indexer for {0} : {1}", this.getRepo().getName(), ex).withLevel(Level.FINEST).withIntent(NMsgIntent.FAIL));
                }
                if (o != null) {
                    this.result = NIteratorBuilder.of(new NIndexFirstIterator<NId>(o, xrepo.searchImpl(this.filter, this.getFetchMode()))).onStart((NRunnable)startRunnable).onFinish((NRunnable)endRunnable).build();
                    return this;
                }
            }
            this.result = NIteratorBuilder.of(xrepo.searchImpl(this.filter, this.getFetchMode())).onStart((NRunnable)startRunnable).onFinish((NRunnable)endRunnable).build();
        }
        catch (SecurityException | NArtifactNotFoundException ex) {
            this._LOG().log(NMsg.ofJ("{0} search packages", NStringUtils.formatAlign(this.getRepo().getName(), 20, NPositionType.FIRST)).withLevel(Level.FINEST).withIntent(NMsgIntent.FAIL));
            throw ex;
        }
        catch (RuntimeException ex) {
            this._LOG().log(NMsg.ofJ("{0} search packages", NStringUtils.formatAlign(this.getRepo().getName(), 20, NPositionType.FIRST)).withLevel(Level.SEVERE).withIntent(NMsgIntent.FAIL));
            throw ex;
        }
        return this;
    }

    @Override
    public NIterator<NId> getResult() {
        if (this.result == null) {
            this.run();
        }
        return this.result;
    }
}

