/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository;

import java.util.Objects;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.core.NRepositoryConfig;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.repository.NRepositoryTagsListHelper;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.spi.NRepositoryDB;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.spi.NRepositorySelectorList;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;

public class NRepositorySelectorHelper {
    public static NAddRepositoryOptions createRepositoryOptions(String s, boolean requireName) {
        return NRepositorySelectorHelper.createRepositoryOptions(s, requireName, null);
    }

    public static NAddRepositoryOptions createRepositoryOptions(String s, boolean requireName, String[] tags) {
        NRepositorySelectorList r = NRepositorySelectorList.of(s, NRepositoryDB.of()).get();
        NRepositoryLocation[] all = r.resolve(null, NRepositoryDB.of());
        if (all.length != 1) {
            throw new IllegalArgumentException("unexpected");
        }
        return NRepositorySelectorHelper.createRepositoryOptions(all[0], requireName, tags);
    }

    public static NAddRepositoryOptions createRepositoryOptions(NRepositoryLocation loc, boolean requireName) {
        return NRepositorySelectorHelper.createRepositoryOptions(loc, requireName, null);
    }

    public static NAddRepositoryOptions createRepositoryOptions(NRepositoryLocation loc, boolean requireName, String[] tags) {
        String defaultName = null;
        NRepositoryDB db = NRepositoryDB.of();
        if (!db.findAllNamesByName(loc.getName()).isEmpty()) {
            defaultName = loc.getName();
        } else {
            String nn = db.getRepositoryOptionsByLocation(loc.getPath()).map(x -> x.getName()).orNull();
            if (nn != null) {
                defaultName = nn;
            }
        }
        if (defaultName != null) {
            NAddRepositoryOptions u = db.getRepositoryOptionsByName(defaultName).orNull();
            if (u != null && (loc.getPath().isEmpty() || Objects.equals(loc.getPath(), u.getConfig().getLocation().getPath()) || Objects.equals(loc.getFullLocation(), u.getConfig().getLocation().getFullLocation())) && !u.getName().equals(loc.getName())) {
                u.setName(loc.getName());
            }
            if (u != null) {
                if (u.getConfig() != null) {
                    u.getConfig().setTags(new NRepositoryTagsListHelper().add(u.getConfig().getTags()).add(tags).toArray());
                }
                return u;
            }
        }
        return NRepositorySelectorHelper.createCustomRepositoryOptions(loc.getName(), loc.getFullLocation(), requireName);
    }

    public static NAddRepositoryOptions createCustomRepositoryOptions(String name, String url, boolean requireName) {
        if ((name == null || name.isEmpty()) && requireName) {
            NAssert.requireNonBlank(name, "repository name (<name>=<url>)");
        }
        if (name == null || name.isEmpty()) {
            name = url;
            if (name.startsWith("http://")) {
                name = name.substring("http://".length());
            } else if (name.startsWith("https://")) {
                name = name.substring("https://".length());
            }
            name = name.replaceAll("[/\\\\:?.]", "-");
            while (name.endsWith("-")) {
                name = name.substring(0, name.length() - 1);
            }
            while (name.startsWith("-")) {
                name = name.substring(1);
            }
        }
        NAssert.requireNonBlank(name, "repository name (<name>=<url>)");
        NAssert.requireNonBlank(url, "repository url (<name>=<url>)");
        NRepositoryLocation loc = NRepositoryLocation.of(url);
        NPath nPath = NPath.of(loc.getPath());
        String sloc = nPath.isName() ? nPath.toAbsolute(NWorkspaceExt.of().getConfigModel().getRepositoriesRoot()).toString() : nPath.toAbsolute().toString();
        loc = loc.setPath(sloc);
        return new NAddRepositoryOptions().setName(name).setFailSafe(false).setCreate(true).setOrder(!NBlankable.isBlank(url) && NPath.of(url).isLocal() ? 1000 : 10000).setConfig(new NRepositoryConfig().setLocation(loc));
    }

    public static NAddRepositoryOptions createDefaultRepositoryOptions(String nameOrURL) {
        Objects.requireNonNull(nameOrURL);
        return null;
    }
}

