/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryRef;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigMain;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NPredicates;

public class NRepositoryRegistryHelper {
    private Map<String, RepoAndRef> repositoriesByName = new LinkedHashMap<String, RepoAndRef>();
    private Map<String, RepoAndRef> repositoriesByUuid = new LinkedHashMap<String, RepoAndRef>();

    public NRepository[] getRepositories() {
        return (NRepository[])this.repositoriesByUuid.values().stream().map(x -> x.repo).filter(NPredicates.nonNull()).toArray(NRepository[]::new);
    }

    public NRepositoryRef[] getRepositoryRefs() {
        return (NRepositoryRef[])this.repositoriesByUuid.values().stream().map(x -> x.ref).filter(NPredicates.nonNull()).toArray(NRepositoryRef[]::new);
    }

    public void addRepository(NRepository repository) {
        NWorkspaceConfigMain m;
        List<NRepositoryRef> repositoriesRefs;
        if (repository == null) {
            return;
        }
        NRepositoryRef repositoryRef = repository.config().getRepositoryRef();
        String uuid = repository.getUuid();
        String name = repository.getName();
        if (name == null) {
            return;
        }
        RepoAndRef ii = null;
        if (uuid != null && (ii = this.repositoriesByUuid.get(uuid)) != null) {
            throw new NIllegalArgumentException(NMsg.ofC("repository with the same uuid already exists % / %s", ii.repo.getUuid(), ii.repo.getName()));
        }
        ii = this.repositoriesByName.get(name);
        if (ii != null) {
            throw new NIllegalArgumentException(NMsg.ofC("repository with the same name already exists %s / %s", ii.repo.getUuid(), ii.repo.getName()));
        }
        if (!name.matches("[a-zA-Z][.a-zA-Z0-9_-]*")) {
            throw new NIllegalArgumentException(NMsg.ofC("invalid repository name %s", name));
        }
        RepoAndRef rr = new RepoAndRef(repository);
        rr.ref = repositoryRef;
        this.repositoriesByName.put(name, rr);
        if (uuid != null) {
            this.repositoriesByUuid.put(uuid, rr);
        }
        if ((repositoriesRefs = (m = NWorkspaceExt.of().getModel().configModel.getStoreModelMain()).getRepositories()) == null) {
            repositoriesRefs = new ArrayList<NRepositoryRef>();
            m.setRepositories(repositoriesRefs);
        }
        repositoriesRefs.add(repositoryRef);
        m.setRepositories(repositoriesRefs);
    }

    public NRepository removeRepository(String repository) {
        NRepository r = this.findRepository(repository);
        if (r != null) {
            this.repositoriesByName.remove(r.getName());
            this.repositoriesByUuid.remove(r.getUuid());
            NWorkspaceConfigMain m = NWorkspaceExt.of().getModel().configModel.getStoreModelMain();
            List<NRepositoryRef> repositoriesRefs = m.getRepositories();
            if (repositoriesRefs != null) {
                repositoriesRefs.removeIf(x -> x.getName().equals(r.getName()));
            }
            return r;
        }
        return null;
    }

    private RepoAndRef findRepositoryAndRefById(String repositoryNameOrId) {
        RepoAndRef y;
        if (!NBlankable.isBlank(repositoryNameOrId) && (y = this.repositoriesByUuid.get(repositoryNameOrId)) != null) {
            return y;
        }
        return null;
    }

    private RepoAndRef findRepositoryAndRef(String repositoryNameOrId) {
        if (!NBlankable.isBlank(repositoryNameOrId)) {
            RepoAndRef y = this.repositoriesByUuid.get(repositoryNameOrId);
            if (y != null) {
                return y;
            }
            y = this.repositoriesByName.get(repositoryNameOrId);
            if (y != null) {
                return y;
            }
        }
        return null;
    }

    private RepoAndRef findRepositoryAndRefByName(String repositoryNameOrId) {
        RepoAndRef y;
        if (!NBlankable.isBlank(repositoryNameOrId) && (y = this.repositoriesByName.get(repositoryNameOrId)) != null) {
            return y;
        }
        return null;
    }

    public NRepository findRepositoryById(String repositoryNameOrId) {
        RepoAndRef rr = this.findRepositoryAndRefById(repositoryNameOrId);
        if (rr == null) {
            return null;
        }
        return rr.repo;
    }

    public NRepository findRepositoryByName(String repositoryNameOrId) {
        RepoAndRef rr = this.findRepositoryAndRefByName(repositoryNameOrId);
        if (rr == null) {
            return null;
        }
        return rr.repo;
    }

    public NRepository findRepository(String repositoryNameOrId) {
        RepoAndRef rr = this.findRepositoryAndRef(repositoryNameOrId);
        if (rr == null) {
            return null;
        }
        return rr.repo;
    }

    public NRepositoryRef findRepositoryRef(String repositoryNameOrId) {
        RepoAndRef rr = this.findRepositoryAndRef(repositoryNameOrId);
        if (rr == null) {
            return null;
        }
        return rr.ref;
    }

    private static class RepoAndRef {
        NRepositoryRef ref;
        NRepository repo;

        public RepoAndRef(NRepository repo) {
            this.repo = repo;
        }
    }
}

