/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository;

import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.core.NContentEvent;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NRepositoryEvent;
import net.thevpc.nuts.core.NRepositoryListener;
import net.thevpc.nuts.core.NSpeedQualifier;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.repository.cmd.NRepositorySupportedAction;
import net.thevpc.nuts.runtime.standalone.repository.impl.NRepositoryExt;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NInstalledRepository;
import net.thevpc.nuts.runtime.standalone.util.NSpeedQualifiers;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NPositionType;
import net.thevpc.nuts.util.NStringUtils;

public class NRepositoryHelper {
    private final NRepository repo;

    private NRepositoryHelper(NRepository repo) {
        this.repo = repo;
    }

    public static NRepositoryHelper of(NRepository repo) {
        Map<String, Object> up = repo.getUserProperties();
        NRepositoryHelper wp = (NRepositoryHelper)up.get(NRepositoryHelper.class.getName());
        if (wp == null) {
            wp = new NRepositoryHelper(repo);
            up.put(NRepositoryHelper.class.getName(), wp);
        }
        return wp;
    }

    public static NSpeedQualifier getSupportSpeedLevel(NRepository repository, NRepositorySupportedAction supportedAction, NId id, NFetchMode mode, boolean transitive) {
        NSpeedQualifier r;
        if (repository instanceof NInstalledRepository) {
            return NSpeedQualifier.UNAVAILABLE;
        }
        NRepositoryExt xrepo = NRepositoryExt.of(repository);
        ArrayList<NSpeedQualifier> speeds = new ArrayList<NSpeedQualifier>();
        if (xrepo.acceptAction(id, supportedAction, mode) && (r = repository.config().getSpeed()) != NSpeedQualifier.UNAVAILABLE) {
            speeds.add(r);
        }
        if (transitive) {
            for (NRepository remote : repository.config().getMirrors()) {
                NSpeedQualifier r2 = NRepositoryHelper.getSupportSpeedLevel(remote, supportedAction, id, mode, transitive);
                if (r2 == NSpeedQualifier.UNAVAILABLE) continue;
                speeds.add(r2);
            }
        }
        if (speeds.size() == 0) {
            return NSpeedQualifier.UNAVAILABLE;
        }
        return NSpeedQualifiers.max(speeds.toArray(new NSpeedQualifier[0]));
    }

    public static int getSupportDeployLevel(NRepository repository, NRepositorySupportedAction supportedAction, NId id, NFetchMode mode, boolean transitive) {
        int r;
        if (repository instanceof NInstalledRepository) {
            return 0;
        }
        NRepositoryExt xrepo = NRepositoryExt.of(repository);
        int result = 0;
        if (xrepo.acceptAction(id, supportedAction, mode) && (r = repository.config().getDeployWeight()) > 0 && r > result) {
            result = r;
        }
        if (transitive) {
            for (NRepository remote : repository.config().getMirrors()) {
                int r2 = NRepositoryHelper.getSupportDeployLevel(remote, supportedAction, id, mode, transitive);
                if (r2 <= 0 || r2 <= result) continue;
                result = r2;
            }
        }
        return result;
    }

    protected NLog _LOG() {
        return NLog.of(NRepositoryHelper.class);
    }

    public Events events() {
        return new Events(this);
    }

    public static class Events {
        private final NRepositoryHelper u;

        public Events(NRepositoryHelper u) {
            this.u = u;
        }

        public void fireOnUndeploy(NContentEvent evt) {
            for (NRepositoryListener listener : this.u.repo.getRepositoryListeners()) {
                listener.onUndeploy(evt);
            }
            for (NRepositoryListener listener : this.u.repo.getWorkspace().getRepositoryListeners()) {
                listener.onUndeploy(evt);
            }
        }

        public void fireOnDeploy(NContentEvent event) {
            for (NRepositoryListener listener : this.u.repo.getRepositoryListeners()) {
                listener.onDeploy(event);
            }
            for (NRepositoryListener listener : this.u.repo.getWorkspace().getRepositoryListeners()) {
                listener.onDeploy(event);
            }
        }

        public void fireOnPush(NContentEvent event) {
            for (NRepositoryListener listener : this.u.repo.getRepositoryListeners()) {
                listener.onPush(event);
            }
            for (NRepositoryListener listener : this.u.repo.getWorkspace().getRepositoryListeners()) {
                listener.onPush(event);
            }
            for (NRepositoryListener listener : event.getSession().getListeners(NRepositoryListener.class)) {
                listener.onPush(event);
            }
        }

        public void fireOnAddRepository(NRepositoryEvent event) {
            if (this.u._LOG().isLoggable(Level.FINEST)) {
                this.u._LOG().log(NMsg.ofJ("{0} add    repo {1}", NStringUtils.formatAlign(this.u.repo.getName(), 20, NPositionType.FIRST), event.getRepository().getName()).withLevel(Level.FINEST).withIntent(NMsgIntent.ADD));
            }
            for (NRepositoryListener listener : this.u.repo.getRepositoryListeners()) {
                listener.onAddRepository(event);
            }
            for (NRepositoryListener listener : this.u.repo.getWorkspace().getRepositoryListeners()) {
                listener.onAddRepository(event);
            }
            for (NRepositoryListener listener : event.getSession().getListeners(NRepositoryListener.class)) {
                listener.onAddRepository(event);
            }
        }

        public void fireOnRemoveRepository(NRepositoryEvent event) {
            if (this.u._LOG().isLoggable(Level.FINEST)) {
                this.u._LOG().log(NMsg.ofJ("{0} remove repo {1}", NStringUtils.formatAlign(this.u.repo.getName(), 20, NPositionType.FIRST), event.getRepository().getName()).withLevel(Level.FINEST).withIntent(NMsgIntent.REMOVE));
            }
            for (NRepositoryListener listener : this.u.repo.getRepositoryListeners()) {
                listener.onRemoveRepository(event);
            }
            for (NRepositoryListener listener : this.u.repo.getWorkspace().getRepositoryListeners()) {
                listener.onRemoveRepository(event);
            }
            for (NRepositoryListener listener : event.getSession().getListeners(NRepositoryListener.class)) {
                listener.onRemoveRepository(event);
            }
        }
    }
}

