/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository;

import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NInputStreamMonitor;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.runtime.standalone.definition.NDefinitionHelper;
import net.thevpc.nuts.runtime.standalone.repository.NIdPathIteratorModel;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.text.NMsg;

public abstract class NIdPathIteratorBase
implements NIdPathIteratorModel {
    public abstract NWorkspace getWorkspace();

    public NId validate(NId id, NDescriptor descriptor, NPath pathname, NPath rootPath, NDefinitionFilter filter, NRepository repository) {
        if (descriptor != null) {
            if (!CoreNUtils.isEffectiveId(descriptor.getId())) {
                NDescriptor effectiveDescriptor = null;
                try {
                    effectiveDescriptor = NWorkspace.of().resolveEffectiveDescriptor(descriptor);
                }
                catch (Exception ex) {
                    NLog.of(NIdPathIteratorBase.class).log(NMsg.ofC("error resolving effective descriptor for %s in url %s : %s", descriptor.getId(), pathname, ex).asFineFail(ex));
                }
                if (effectiveDescriptor != null) {
                    descriptor = effectiveDescriptor;
                }
            }
            if (filter == null || filter.acceptDefinition(NDefinitionHelper.ofDescriptorOnly(descriptor))) {
                NId nutsId = descriptor.getId().builder().setRepository(repository.getName()).build();
                return nutsId;
            }
        }
        if (id != null && (filter == null || filter.acceptDefinition(NDefinitionHelper.ofIdOnlyFromRepo(id, repository, "NIdPathIteratorBase")))) {
            return id;
        }
        return null;
    }

    @Override
    public NId parseId(NPath pathname, NPath rootPath, NDefinitionFilter filter, NRepository repository) {
        NDescriptor t = null;
        try {
            t = this.parseDescriptor(pathname, NInputStreamMonitor.of().setSource(pathname).create(), NFetchMode.LOCAL, repository, rootPath);
        }
        catch (Exception ex) {
            NLog.of(NIdPathIteratorBase.class).log(NMsg.ofJ("error parsing url : {0} : {1}", pathname, this.toString()).asFineFail(ex));
        }
        if (t != null) {
            return this.validate(null, t, pathname, rootPath, filter, repository);
        }
        return null;
    }
}

