/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repository;

import java.util.LinkedList;
import java.util.Stack;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.elem.NElements;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.runtime.standalone.repository.NIdPathIteratorModel;
import net.thevpc.nuts.runtime.standalone.util.NCoreLogUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NIteratorBase;
import net.thevpc.nuts.util.NUnsupportedOperationException;

public class NIdPathIterator
extends NIteratorBase<NId> {
    private final NRepository repository;
    private final StackOrQueue<PathAndDepth> stack;
    private final NDefinitionFilter filter;
    private final NIdPathIteratorModel model;
    private final int maxDepth;
    private final NPath basePath;
    private final NPath rootFolder;
    private NId last;
    private long visitedFoldersCount;
    private long visitedFilesCount;
    private final NObjectElement extraProperties;
    private final String kind;

    public NIdPathIterator(NRepository repository, NPath rootFolder, NPath basePath, NDefinitionFilter filter, NIdPathIteratorModel model, int maxDepth, String kind, NObjectElement extraProperties, boolean bfs) {
        this.stack = bfs ? new OneQueue() : new OneStack();
        this.repository = repository;
        this.extraProperties = extraProperties;
        this.kind = kind;
        this.filter = filter;
        this.model = model;
        this.maxDepth = maxDepth;
        if (rootFolder == null) {
            throw new NIllegalArgumentException(NMsg.ofPlain("could not iterate over null rootFolder"));
        }
        this.basePath = basePath;
        this.rootFolder = rootFolder;
        NPath startUrl = rootFolder;
        if (basePath != null) {
            if (basePath.isAbsolute()) {
                throw new NIllegalArgumentException(NMsg.ofC("expected relative path : %s", basePath));
            }
            startUrl = startUrl.resolve(basePath);
        }
        this.stack.add(new PathAndDepth(startUrl, true, 0));
    }

    @Override
    public NElement describe() {
        return NElement.ofObjectBuilder().name("ScanPath").set("repository", this.repository == null ? null : this.repository.getName()).set("filter", NElementDescribables.describeResolveOrDestruct(this.filter)).add(this.basePath == null ? null : NElement.ofPair("path", NElements.of().toElement(this.basePath))).set("root", NElements.of().toElement(this.rootFolder)).add(this.maxDepth < 0 || this.maxDepth == Integer.MAX_VALUE ? null : NElement.ofPair("maxDepth", this.maxDepth)).addAll(this.extraProperties == null ? null : this.extraProperties.children()).build();
    }

    @Override
    public boolean hasNext() {
        this.last = null;
        while (!this.stack.isEmpty()) {
            PathAndDepth file = this.stack.remove();
            NSession session = this.repository.getWorkspace().currentSession();
            if (file.folder) {
                session.getTerminal().printProgress(NMsg.ofC("%-14s %-8s %-8s (for %s) in %s", this.repository.getName(), this.kind, "search folder", this.filter, NCoreLogUtils.forProgress(file.path)));
                ++this.visitedFoldersCount;
                NPath[] children = new NPath[]{};
                try {
                    children = (NPath[])file.path.stream().toArray(NPath[]::new);
                }
                catch (NIOException ex) {
                    session.getTerminal().printProgress(NMsg.ofC("%-14s %-8s %-8s %s (for %s) in %s", this.repository.getName(), this.kind, "search folder", NCoreLogUtils.forProgress(file.path), this.filter, NText.ofStyledError("failed!")));
                    NLog.of(NIdPathIterator.class).log(NMsg.ofJ("error listing : {0} : {1} : {2}", file.path, this.toString(), ex.toString()).asFine());
                }
                catch (Exception ex) {
                    session.getTerminal().printProgress(NMsg.ofC("%-14s %-8s %-8s %s (for %s) in %s", this.repository.getName(), this.kind, "search folder", NCoreLogUtils.forProgress(file.path), this.filter, NText.ofStyledError("failed!")));
                    NLog.of(NIdPathIterator.class).log(NMsg.ofJ("error listing : {0} : {1}", file.path, this.toString()).asFineFail(ex));
                }
                boolean deep = file.depth < this.maxDepth;
                for (NPath child : children) {
                    if (child.isDirectory()) {
                        if (!deep) continue;
                        this.stack.add(new PathAndDepth(child, true, file.depth + 1));
                        continue;
                    }
                    if (!this.model.isDescFile(child)) continue;
                    this.stack.add(new PathAndDepth(child, false, file.depth));
                }
                continue;
            }
            ++this.visitedFilesCount;
            NId t = null;
            try {
                t = this.model.parseId(file.path, this.rootFolder, this.filter, this.repository);
            }
            catch (Exception ex) {
                NLog.of(NIdPathIterator.class).log(NMsg.ofJ("error parsing : {0} : {1}", file.path, this.toString()).asFineFail(ex));
            }
            if (t == null) continue;
            this.last = t;
            return true;
        }
        return this.last != null;
    }

    @Override
    public NId next() {
        NId ret = this.last;
        this.last = null;
        return ret;
    }

    @Override
    public void remove() {
        if (this.last != null) {
            this.model.undeploy(this.last);
        }
        throw new NUnsupportedOperationException(NMsg.ofPlain("unsupported Remove"));
    }

    public long getVisitedFoldersCount() {
        return this.visitedFoldersCount;
    }

    public long getVisitedFilesCount() {
        return this.visitedFilesCount;
    }

    private static class OneQueue<T>
    implements StackOrQueue<T> {
        private LinkedList<T> all = new LinkedList();

        private OneQueue() {
        }

        @Override
        public void add(T t) {
            this.all.add(t);
        }

        @Override
        public T remove() {
            return this.all.removeFirst();
        }

        @Override
        public boolean isEmpty() {
            return this.all.isEmpty();
        }
    }

    private static class OneStack<T>
    implements StackOrQueue<T> {
        private Stack<T> all = new Stack();

        private OneStack() {
        }

        @Override
        public void add(T t) {
            this.all.push(t);
        }

        @Override
        public T remove() {
            return this.all.pop();
        }

        @Override
        public boolean isEmpty() {
            return this.all.isEmpty();
        }
    }

    private static interface StackOrQueue<T> {
        public void add(T var1);

        public T remove();

        public boolean isEmpty();
    }

    private static class PathAndDepth {
        private final NPath path;
        private final int depth;
        private final boolean folder;

        public PathAndDepth(NPath path, boolean folder, int depth) {
            this.path = path;
            this.folder = folder;
            this.depth = depth;
        }
    }
}

