/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.reflect.mapper;

import java.lang.reflect.Type;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.reflect.NReflectTypeMapper;
import net.thevpc.nuts.runtime.standalone.reflect.mapper.ArrayToArrayTypeMapper;
import net.thevpc.nuts.runtime.standalone.reflect.mapper.ArrayToCollectionTypeMapper;
import net.thevpc.nuts.runtime.standalone.reflect.mapper.CollectionToArrayTypeMapper;
import net.thevpc.nuts.runtime.standalone.reflect.mapper.CollectionToCollectionTypeMapper;
import net.thevpc.nuts.runtime.standalone.reflect.mapper.DataObjectTypeMapper;
import net.thevpc.nuts.runtime.standalone.reflect.mapper.IdentityTypeMapper;
import net.thevpc.nuts.runtime.standalone.reflect.mapper.MapToMapTypeMapper;
import net.thevpc.nuts.runtime.standalone.reflect.mapper.TypeHelper;
import net.thevpc.nuts.util.NOptional;

public class TypeMapperRepositoryDef {
    private final Map<Key, NReflectTypeMapper> definitions = new HashMap<Key, NReflectTypeMapper>();
    private final Map<Key, CacheItem> cache = new HashMap<Key, CacheItem>();
    private final TypeMapperRepositoryDef parent;

    public TypeMapperRepositoryDef(TypeMapperRepositoryDef parent) {
        this.parent = parent;
    }

    public NOptional<NReflectTypeMapper> findTypeMapper(Class from, Type to) {
        CacheItem cacheItem = this.findCacheItem(from, to);
        if (cacheItem.getMapper() == null) {
            return NOptional.ofNamedEmpty("mapper from " + from.getSimpleName() + " to " + to);
        }
        return NOptional.of(cacheItem.mapper);
    }

    private CacheItem findCacheItem(Class from, Type to) {
        NReflectTypeMapper typeMapper;
        Key k = new Key(from, to);
        CacheItem o = this.cache.get(k);
        if (o != null) {
            return o;
        }
        NReflectTypeMapper m = this.definitions.get(k);
        if (m != null) {
            o = new CacheItem(k, k, m, 0);
            this.cache.put(k, o);
            return o;
        }
        ArrayList<Class> fromList = new ArrayList<Class>();
        Class superclass = from.getSuperclass();
        fromList.add(from);
        fromList.add(superclass);
        fromList.addAll(Arrays.asList(from.getInterfaces()));
        fromList.removeIf(Objects::isNull);
        ArrayList<Type> toList = new ArrayList<Type>();
        Type superType = TypeHelper.getGenericSuperclass(to);
        toList.add(superType);
        toList.addAll(Arrays.asList(TypeHelper.getGenericInterfaces(to)));
        toList.removeIf(Objects::isNull);
        CacheItem found = null;
        for (Class a : fromList) {
            for (Type b : toList) {
                CacheItem cacheItem;
                Key k2 = new Key(from, to);
                if (k2.equals(k) || (cacheItem = this.findCacheItem(from, superclass)).mapper == null) continue;
                int farExtent = (a.equals(from) ? 1 : 0) + (b.equals(to) ? 1 : 0);
                int nextFar = cacheItem.far + farExtent;
                if (found != null && found.far <= nextFar) continue;
                found = new CacheItem(k, cacheItem.base, cacheItem.mapper, nextFar);
            }
        }
        if (found == null && (typeMapper = this.resolveDefaultMapper(from, to)) != null) {
            found = new CacheItem(k, k, typeMapper, 0);
        }
        if (found == null && this.parent != null && (found = this.parent.findCacheItem(from, to)).getMapper() == null) {
            found = null;
        }
        if (found == null) {
            found = new CacheItem(k, k, null, -1);
        }
        this.cache.put(k, found);
        return found;
    }

    public void dispose() {
    }

    public void invalidateCache() {
        this.cache.clear();
    }

    public void tryRegister(Class<?> from, Type to, NReflectTypeMapper mapper) {
        this.register(from, to, mapper);
    }

    public void register(Class<?> from, Type to, NReflectTypeMapper mapper) {
        this.invalidateCache();
        this.definitions.put(new Key(from, to), mapper);
    }

    private static boolean isImmutableType(Type type) {
        if (TypeHelper.isBoxedOrPrimitive(type)) {
            return true;
        }
        if (String.class.equals((Object)type)) {
            return true;
        }
        if (TypeHelper.isAssignableFrom(Temporal.class, type)) {
            return true;
        }
        if (TypeHelper.isAssignableFrom(Number.class, type)) {
            return true;
        }
        if (TypeHelper.isEnum(type)) {
            return true;
        }
        return TypeHelper.isAssignableFrom(Date.class, type);
    }

    private NReflectTypeMapper resolveDefaultMapper(Class from, Type to) {
        if (from.isArray()) {
            if (TypeHelper.isArray(to)) {
                return new ArrayToArrayTypeMapper(to);
            }
            if (TypeHelper.isAssignableFrom(Collection.class, to)) {
                return new ArrayToCollectionTypeMapper(to);
            }
        } else if (Collection.class.isAssignableFrom(from)) {
            if (TypeHelper.isArray(to)) {
                return new CollectionToArrayTypeMapper(to);
            }
            if (TypeHelper.isAssignableFrom(Collection.class, to)) {
                return new CollectionToCollectionTypeMapper(to);
            }
        }
        if (TypeHelper.isAssignableFrom(Map.class, from) && TypeHelper.isAssignableFrom(Map.class, to)) {
            return new MapToMapTypeMapper(to);
        }
        if (TypeHelper.isBoxedOrPrimitive(from) && Objects.equals(TypeHelper.toPrimitiveName(from), TypeHelper.toPrimitiveName(to))) {
            return IdentityTypeMapper.IDENTITY_TYPE_MAPPER;
        }
        if (TypeMapperRepositoryDef.isImmutableType(from) && Objects.equals(TypeHelper.toPrimitiveName(from), TypeHelper.toPrimitiveName(to))) {
            return IdentityTypeMapper.IDENTITY_TYPE_MAPPER;
        }
        if (!TypeHelper.isBoxedOrPrimitive(from) && !TypeHelper.isBoxedOrPrimitive(to)) {
            return new DataObjectTypeMapper(from, to);
        }
        return null;
    }

    public static class CacheItem {
        private final Key key;
        private final Key base;
        private final NReflectTypeMapper mapper;
        private final int far;

        public CacheItem(Key key, Key base, NReflectTypeMapper mapper, int far) {
            this.key = key;
            this.base = base;
            this.mapper = mapper;
            this.far = far;
        }

        public Key getKey() {
            return this.key;
        }

        public Key getBase() {
            return this.base;
        }

        public NReflectTypeMapper getMapper() {
            return this.mapper;
        }

        public int getFar() {
            return this.far;
        }
    }

    public static class Key {
        Class from;
        Type to;

        public Key(Class from, Type to) {
            this.from = from;
            this.to = to;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.from, key.from) && Objects.equals(this.to, key.to);
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to);
        }
    }
}

