/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.reflect.mapper;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;

public class TypeHelper {
    public static <T> ObjFactory<T> constructorOf(Class<T> t) {
        Constructor<T> c;
        try {
            c = t.getConstructor(new Class[0]);
            c.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return new ObjFactory<T>(){

            @Override
            public T newInstance() {
                try {
                    return c.newInstance(new Object[0]);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static boolean isLoadableClass(String className) {
        return TypeHelper.isLoadableClass(className, null);
    }

    public static boolean isLoadableClass(String className, ClassLoader cl) {
        try {
            if (cl == null) {
                Class.forName(className);
                return true;
            }
            Class.forName(className, true, cl);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static Object getFieldValue(Object obj, String name) {
        Field declaredField = null;
        try {
            declaredField = obj.getClass().getDeclaredField(name);
            declaredField.setAccessible(true);
            return declaredField.get(obj);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFieldValue(Object obj, String name, Object value) {
        Field declaredField = null;
        try {
            declaredField = obj.getClass().getDeclaredField(name);
            declaredField.setAccessible(true);
            declaredField.set(obj, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static GenericField[] getDeclaredFields(Type type) {
        Type rawType;
        if (type instanceof Class) {
            ArrayList<GenericField> fields = new ArrayList<GenericField>();
            for (Field declaredField : ((Class)type).getDeclaredFields()) {
                fields.add(new GenericField(declaredField, declaredField.getGenericType()));
            }
            return fields.toArray(new GenericField[0]);
        }
        if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class) {
            TypeVariable<Class<T>>[] typeParameters = ((Class)rawType).getTypeParameters();
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            ArrayList<GenericField> fields = new ArrayList<GenericField>();
            for (Field declaredField : ((Class)rawType).getDeclaredFields()) {
                if (!Modifier.isStatic(declaredField.getModifiers())) {
                    Type genericType = declaredField.getGenericType();
                    for (int i = 0; i < typeParameters.length; ++i) {
                        if (typeParameters[i] != genericType) continue;
                        genericType = actualTypeArguments[i];
                        break;
                    }
                    fields.add(new GenericField(declaredField, genericType));
                    continue;
                }
                fields.add(new GenericField(declaredField, declaredField.getGenericType()));
            }
            return fields.toArray(new GenericField[0]);
        }
        throw new IllegalArgumentException("Not supported");
    }

    public static Type getGenericParent(ParameterizedType childRawType, Type parent) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof Class) {
            return parent;
        }
        if (parent instanceof ParameterizedType) {
            ParameterizedType pParent = (ParameterizedType)parent;
            Type pParentRaw = pParent.getRawType();
            TypeVariable<Class<T>>[] parentTypeParameters = null;
            TypeVariable<Class<T>>[] childTypeParameters = null;
            Type[] parentActualTypeArguments = pParent.getActualTypeArguments();
            Type[] parentActualTypeArguments2 = new Type[parentActualTypeArguments.length];
            Type[] childActualTypeArguments = childRawType.getActualTypeArguments();
            Type childRaw = childRawType.getRawType();
            if (childRaw instanceof Class && pParentRaw instanceof Class) {
                Class cc = (Class)childRaw;
                childTypeParameters = cc.getTypeParameters();
                parentTypeParameters = ((Class)pParentRaw).getTypeParameters();
                for (int i = 0; i < parentActualTypeArguments2.length; ++i) {
                    Type e = parentActualTypeArguments[i];
                    if (e instanceof TypeVariable) {
                        for (int j = 0; j < childTypeParameters.length; ++j) {
                            TypeVariable t = childTypeParameters[j];
                            Type f = childActualTypeArguments[j];
                            if (t != e) continue;
                            e = f;
                        }
                    }
                    parentActualTypeArguments2[i] = e;
                }
                return new ParameterizedTypeImpl(parentActualTypeArguments2, (Class)pParentRaw, pParent);
            }
            throw new IllegalArgumentException("Not supported yet");
        }
        throw new IllegalArgumentException("Not supported yet");
    }

    public static Type getGenericSuperclass(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getGenericSuperclass();
        }
        if (type instanceof ParameterizedType) {
            return TypeHelper.getGenericParent((ParameterizedType)type, TypeHelper.getGenericSuperclass(((ParameterizedType)type).getRawType()));
        }
        throw new IllegalArgumentException("Not Supported yet");
    }

    public static TypeVariable[] getTypeArguments(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getTypeParameters();
        }
        return new TypeVariable[0];
    }

    public static Optional<Class> rawClass(Type type) {
        Type c = type;
        while (c != null) {
            if (c instanceof Class) {
                return Optional.of((Class)c);
            }
            if (!(c instanceof ParameterizedType)) break;
            c = ((ParameterizedType)c).getRawType();
        }
        return Optional.empty();
    }

    public static boolean isArray(Type a) {
        return a instanceof Class && ((Class)a).isArray();
    }

    public static boolean isEnum(Type a) {
        Class ac = TypeHelper.rawClass(a).orElse(null);
        return ac != null && ac.isEnum();
    }

    public static boolean isAssignableFrom(Type a, Type b) {
        Class ac = TypeHelper.rawClass(a).orElse(null);
        Class bc = TypeHelper.rawClass(b).orElse(null);
        return ac != null && bc != null && ac.isAssignableFrom(bc);
    }

    public static Type[] getGenericInterfaces(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getGenericInterfaces();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type rawType = pt.getRawType();
            Type[] g = TypeHelper.getGenericInterfaces(rawType);
            Type[] a = new Type[g.length];
            for (int i = 0; i < g.length; ++i) {
                a[i] = TypeHelper.getGenericParent(pt, g[i]);
            }
            return a;
        }
        throw new IllegalArgumentException("Not Supported yet");
    }

    public static Optional<Type[]> asTypeArgs(Type toCheck, Class against) {
        return TypeHelper.asType(toCheck, against).map(x -> {
            if (x instanceof Class) {
                TypeVariable<Class<T>>[] typeParameters = ((Class)x).getTypeParameters();
                Type[] a = new Type[typeParameters.length];
                for (int i = 0; i < a.length; ++i) {
                    if (typeParameters[i].getBounds().length == 0) {
                        a[i] = Object.class;
                        continue;
                    }
                    if (typeParameters[i].getBounds().length == 1) {
                        a[i] = typeParameters[i].getBounds()[0];
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported");
                }
            } else if (x instanceof ParameterizedType) {
                return ((ParameterizedType)x).getActualTypeArguments();
            }
            throw new IllegalArgumentException("unsupported");
        });
    }

    public static Optional<Type> asType(Type toCheck, Class against) {
        Stack<Type> stack = new Stack<Type>();
        HashSet<Type> visited = new HashSet<Type>();
        stack.push(toCheck);
        while (!stack.isEmpty()) {
            Type rawType;
            Type a = (Type)stack.pop();
            if (visited.contains(a)) continue;
            visited.add(a);
            if (a.equals(against)) {
                return Optional.of(a);
            }
            if (a instanceof ParameterizedType && (rawType = ((ParameterizedType)a).getRawType()).equals(against)) {
                return Optional.of(a);
            }
            Type s = TypeHelper.getGenericSuperclass(a);
            if (s != null && !visited.contains(s)) {
                stack.push(s);
            }
            for (Type i : TypeHelper.getGenericInterfaces(a)) {
                if (i == null || visited.contains(i)) continue;
                stack.push(i);
            }
        }
        return Optional.empty();
    }

    public static String toPrimitiveName(Type from) {
        if (!(from instanceof Class)) {
            return null;
        }
        Class cc = (Class)from;
        if (cc.isPrimitive()) {
            return cc.getName();
        }
        switch (cc.getName()) {
            case "java.lang.Boolean": {
                return "boolean";
            }
            case "java.lang.Byte": {
                return "byte";
            }
            case "java.lang.Short": {
                return "short";
            }
            case "java.lang.Integer": {
                return "int";
            }
            case "java.lang.Long": {
                return "long";
            }
            case "java.lang.Float": {
                return "float";
            }
            case "java.lang.Double": {
                return "double";
            }
            case "java.lang.Character": {
                return "char";
            }
        }
        return null;
    }

    public static boolean isBoxedOrPrimitive(Type from) {
        return TypeHelper.toPrimitiveName(from) != null;
    }

    public static class GenericField {
        private final Field field;
        private final Type type;

        public GenericField(Field field, Type type) {
            this.field = field;
            this.type = type;
        }

        public Field getField() {
            return this.field;
        }

        public Type getType() {
            return this.type;
        }

        public int getModifiers() {
            return this.field.getModifiers();
        }

        public String getName() {
            return this.field.getName();
        }

        public String toString() {
            return String.valueOf(this.field);
        }
    }

    private static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type[] actualTypeArguments;
        private final Class<?> rawType;
        private final Type ownerType;

        public ParameterizedTypeImpl(Type[] actualTypeArguments, Class<?> rawType, Type ownerType) {
            this.actualTypeArguments = actualTypeArguments;
            this.rawType = rawType;
            this.ownerType = ownerType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        public boolean equals(Object o) {
            if (o instanceof ParameterizedType) {
                ParameterizedType that = (ParameterizedType)o;
                if (this == that) {
                    return true;
                }
                Type thatOwner = that.getOwnerType();
                Type thatRawType = that.getRawType();
                return Objects.equals(this.ownerType, thatOwner) && Objects.equals(this.rawType, thatRawType) && Arrays.equals(this.actualTypeArguments, that.getActualTypeArguments());
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.actualTypeArguments) ^ Objects.hashCode(this.ownerType) ^ Objects.hashCode(this.rawType);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.ownerType != null) {
                if (this.ownerType instanceof Class) {
                    sb.append(((Class)this.ownerType).getName());
                } else {
                    sb.append(this.ownerType);
                }
                sb.append("$");
                sb.append(this.rawType.getSimpleName());
            } else {
                sb.append(this.rawType.getName());
            }
            if (this.actualTypeArguments != null && this.actualTypeArguments.length > 0) {
                sb.append("<");
                boolean first = true;
                for (Type t : this.actualTypeArguments) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(t.getTypeName());
                    first = false;
                }
                sb.append(">");
            }
            return sb.toString();
        }
    }

    public static interface ObjFactory<T> {
        public T newInstance();
    }
}

