/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.reflect.mapper;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.reflect.NReflectMapper;
import net.thevpc.nuts.reflect.NReflectMapperContext;
import net.thevpc.nuts.reflect.NReflectProperty;
import net.thevpc.nuts.reflect.NReflectRepository;
import net.thevpc.nuts.reflect.NReflectType;
import net.thevpc.nuts.reflect.NReflectTypeMapper;
import net.thevpc.nuts.runtime.standalone.reflect.DefaultConvertersByType;
import net.thevpc.nuts.runtime.standalone.reflect.NReflectMapperImpl;
import net.thevpc.nuts.runtime.standalone.reflect.mapper.TypeMapperRepositoryDef;
import net.thevpc.nuts.runtime.standalone.reflect.mapper.TypeMapperTraversedTreeImpl;
import net.thevpc.nuts.runtime.standalone.util.jclass.JavaClassUtils;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NEqualizer;
import net.thevpc.nuts.util.NMapSideStrategy;
import net.thevpc.nuts.util.NMapStrategy;
import net.thevpc.nuts.util.NOptional;

public class NReflectMapperContextImpl
implements NReflectMapperContext {
    private static NReflectMapper.Converter defaultConvertersByType = new DefaultConvertersByType();
    private TypeMapperRepositoryDef mapperRepositoryDef;
    private final NReflectMapper mapper;
    private final NReflectRepository repository;
    private final TypeMapperTraversedTreeImpl tree;
    private NMapStrategy mapStrategy = NMapStrategy.ANY;
    private NEqualizer<Object> eq = NEqualizer.ofDefault();
    private Set<NReflectMapperImpl.SPath> included = new HashSet<NReflectMapperImpl.SPath>();
    private Set<NReflectMapperImpl.SPath> excluded = new HashSet<NReflectMapperImpl.SPath>();
    private Map<NReflectMapperImpl.SPath, NReflectMapperImpl.SPath> renamed = new HashMap<NReflectMapperImpl.SPath, NReflectMapperImpl.SPath>();
    private Map<NReflectMapperImpl.TypeConverterKey, NReflectMapper.Converter> convertersByType = new HashMap<NReflectMapperImpl.TypeConverterKey, NReflectMapper.Converter>();
    private Map<NReflectMapperImpl.SPath, NReflectMapper.Converter> convertersByName = new HashMap<NReflectMapperImpl.SPath, NReflectMapper.Converter>();
    private NReflectMapperImpl.SPath root;
    private NReflectTypeMapper defaultMapper = new NReflectTypeMapper(){

        @Override
        public boolean copy(Object from, Object to, NReflectMapperContext context) {
            NReflectType fromType = NReflectMapperContextImpl.this.repository.getType(from.getClass());
            boolean v = false;
            for (NReflectProperty property : fromType.getProperties()) {
                v |= NReflectMapperContextImpl.this.doAction(NReflectMapperContextImpl.this.path(property), property, from, to);
            }
            return v;
        }

        @Override
        public Object mapToType(Object value, NReflectType fromType, NReflectType toType, NReflectMapperContext context) {
            if (value == null) {
                return null;
            }
            return NReflectMapperContextImpl.this.defaultMapToType(value, toType);
        }
    };

    public NReflectMapperContextImpl(NReflectMapper mapper, NReflectRepository reflectRepository, TypeMapperRepositoryDef mapperRepositoryDef) {
        this(mapper, reflectRepository, mapperRepositoryDef, null, null);
    }

    public NReflectMapperContextImpl(NReflectMapper mapper, NReflectRepository reflectRepository, TypeMapperRepositoryDef mapperRepositoryDef, NReflectMapperImpl.SPath root) {
        this(mapper, reflectRepository, mapperRepositoryDef, root, null);
    }

    public NReflectMapperContextImpl(NReflectMapper mapper, NReflectRepository reflectRepository, TypeMapperRepositoryDef mapperRepositoryDef, NReflectMapperImpl.SPath root, TypeMapperTraversedTreeImpl tree) {
        this.mapper = mapper;
        this.repository = reflectRepository == null ? NReflectRepository.of() : reflectRepository;
        this.mapperRepositoryDef = mapperRepositoryDef == null ? new TypeMapperRepositoryDef(NReflectMapperImpl.globalMapperRepositoryDef) : mapperRepositoryDef;
        this.root = root;
        this.tree = tree == null ? new TypeMapperTraversedTreeImpl() : tree;
    }

    @Override
    public void setPropertyConverter(String property, NReflectMapper.Converter converter) {
        if (converter == null) {
            this.convertersByName.remove(NReflectMapperImpl.SPath.parse(property));
        } else {
            this.convertersByName.put(NReflectMapperImpl.SPath.parse(property), converter);
        }
    }

    @Override
    public void setTypeConverter(NReflectType fromType, NReflectType toType, NReflectMapper.Converter converter) {
        if (converter == null) {
            this.convertersByType.remove(new NReflectMapperImpl.TypeConverterKey(fromType, toType));
        } else {
            this.convertersByType.put(new NReflectMapperImpl.TypeConverterKey(fromType, toType), converter);
        }
    }

    @Override
    public void include(String ... names) {
        for (String name : names) {
            this.included.add(NReflectMapperImpl.SPath.parse(name));
        }
    }

    @Override
    public void excludeProperty(String ... names) {
        for (String name : names) {
            this.excluded.add(NReflectMapperImpl.SPath.parse(name));
        }
    }

    @Override
    public void rename(String from, String to) {
        this.renamed.put(NReflectMapperImpl.SPath.parse(from), NReflectMapperImpl.SPath.parse(to));
    }

    @Override
    public Object get(Object a) {
        return this.tree.get(a);
    }

    @Override
    public Object put(Object a, Object b) {
        return this.tree.put(a, b);
    }

    @Override
    public NOptional<NReflectTypeMapper> findTypeMapper(NReflectType from, NReflectType to) {
        return this.mapperRepositoryDef.findTypeMapper(from.asJavaClass().get(), to.asJavaClass().get());
    }

    @Override
    public NEqualizer<Object> equalizer() {
        return this.eq;
    }

    @Override
    public NReflectMapperContext setEqualizer(NEqualizer<Object> eq) {
        this.eq = eq == null ? NEqualizer.ofDefault() : eq;
        return this;
    }

    @Override
    public NMapStrategy mapStrategy() {
        return this.mapStrategy;
    }

    @Override
    public NReflectMapperContextImpl setMapStrategy(NMapStrategy mapStrategy) {
        this.mapStrategy = mapStrategy == null ? NMapStrategy.ANY : mapStrategy;
        return this;
    }

    @Override
    public NReflectRepository repository() {
        return this.repository;
    }

    @Override
    public NReflectMapper mapper() {
        return this.mapper;
    }

    public NReflectMapperImpl.SPath path(NReflectMapperImpl.SPath path) {
        if (this.root == null) {
            return path;
        }
        return this.root.resolve(path);
    }

    public NReflectMapperImpl.SPath path(NReflectProperty p) {
        if (this.root == null) {
            return new NReflectMapperImpl.SPath(new String[]{p.getName()});
        }
        return this.root.resolve(p.getName());
    }

    boolean isIncludedPath(NReflectMapperImpl.SPath path) {
        NReflectMapperImpl.SPath a = this.getIncludedPath(path);
        NReflectMapperImpl.SPath b = this.getExcludedPath(path);
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return true;
        }
        if (a.elems.length == b.elems.length) {
            return false;
        }
        return a.elems.length > b.elems.length;
    }

    private boolean doAction(NReflectMapperImpl.SPath path, NReflectProperty property, Object fromInstance, Object toInstance) {
        if (this.isIncludedPath(path)) {
            Object sourceValue;
            NReflectMapperImpl.SPath fpath = this.path(path);
            NReflectMapperImpl.SPath n = this.renamed.get(fpath);
            NReflectType toType = this.repository.getType(toInstance.getClass());
            NOptional<NReflectProperty> toProp = toType.getProperty(n == null ? path.name() : n.name());
            if (toProp.isPresent() && this.acceptValue(sourceValue = property.read(fromInstance), this.mapStrategy.source())) {
                NReflectMapper.Converter c;
                Object toValue;
                switch (this.mapStrategy.target()) {
                    case ANY: {
                        NReflectMapper.Converter c2 = this.convertersByName.get(fpath);
                        if (c2 == null) {
                            toProp.get().write(toInstance, this.mapToType(sourceValue, toProp.get().getPropertyType()));
                        } else {
                            toProp.get().write(toInstance, c2.convert(sourceValue, path.toString(), property.getPropertyType(), toProp.get().getPropertyType(), this));
                        }
                        return true;
                    }
                }
                if (this.acceptValue(toProp.get().read(toInstance), this.mapStrategy.target()) && this.acceptValue(toValue = (c = this.convertersByName.get(fpath)) == null ? this.mapToType(sourceValue, toProp.get().getPropertyType()) : c.convert(sourceValue, path.toString(), property.getPropertyType(), toProp.get().getPropertyType(), this), this.mapStrategy.target())) {
                    toProp.get().write(toInstance, toValue);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean acceptValue(Object value, NMapSideStrategy filter) {
        switch (filter) {
            case BLANK: {
                return NBlankable.isBlank(value);
            }
            case NON_BLANK: {
                return !NBlankable.isBlank(value);
            }
            case NULL: {
                return value == null;
            }
            case NON_NULL: {
                return value != null;
            }
        }
        return true;
    }

    @Override
    public Object mapToType(Object value, NReflectType toType) {
        if (toType == null) {
            return value;
        }
        if (value == null) {
            return toType.getDefaultValue();
        }
        NReflectType u = this.repository().getType(value.getClass());
        if (u.equals(toType) || toType.isAssignableFrom(u)) {
            return value;
        }
        NOptional<NReflectTypeMapper> typeMapper = this.findTypeMapper(u, toType);
        if (!typeMapper.isPresent()) {
            return this.defaultMapper.mapToType(value, u, toType, this);
        }
        return typeMapper.get().mapToType(value, u, toType, this);
    }

    public void tryRegisterBean(Object bean) {
        Class baseClass = JavaClassUtils.unwrapCGLib(bean.getClass());
        Type genericSuperclass = baseClass.getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Invalid TypeMapper type " + bean.getClass());
        }
        Type[] actualTypeArguments = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
        this.tryRegister((Class)actualTypeArguments[0], (Class)actualTypeArguments[1], (NReflectTypeMapper)bean);
    }

    NReflectMapperImpl.SPath getIncludedPath(NReflectMapperImpl.SPath path) {
        while (path != null) {
            if (this.included.contains(path)) {
                return path;
            }
            path = path.parent();
        }
        return null;
    }

    NReflectMapperImpl.SPath getExcludedPath(NReflectMapperImpl.SPath path) {
        while (path != null) {
            if (this.excluded.contains(path)) {
                return path;
            }
            path = path.parent();
        }
        return null;
    }

    public Object defaultMapToType(Object value, NReflectType toType) {
        if (value == null) {
            return null;
        }
        Object ni = toType.newInstance();
        this.copy(value, ni);
        return ni;
    }

    @Override
    public boolean copy(Object from, Object to) {
        if (from == null) {
            return false;
        }
        if (to == null) {
            return false;
        }
        NOptional<NReflectTypeMapper> typeMapper = this.findTypeMapper(this.repository().getType(from.getClass()), this.repository.getType(to.getClass()));
        return typeMapper.get().copy(from, to, this);
    }

    public void tryRegister(Class<?> from, Type to, NReflectTypeMapper mapper) {
        this.mapperRepositoryDef.tryRegister(from, to, mapper);
    }

    public void tryRegister(Class<?> from, Class<?> to, NReflectTypeMapper mapper) {
        this.mapperRepositoryDef.tryRegister(from, to, mapper);
    }
}

