/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.reflect.mapper;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import net.thevpc.nuts.reflect.NReflectMapperContext;
import net.thevpc.nuts.reflect.NReflectType;
import net.thevpc.nuts.reflect.NReflectTypeMapper;

class MapToMapTypeMapper
implements NReflectTypeMapper {
    private final Type to;
    private final Type keyType;
    private final Type valueType;

    public MapToMapTypeMapper(Type to) {
        this.to = to;
        if (!(to instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Unexpected");
        }
        Type[] actualTypeArguments = ((ParameterizedType)to).getActualTypeArguments();
        this.keyType = actualTypeArguments[0];
        this.valueType = actualTypeArguments[1];
    }

    @Override
    public boolean copy(Object fromObj, Object toObj, NReflectMapperContext context) {
        Map fromColl = (Map)fromObj;
        Map toColl = (Map)toObj;
        boolean changed = false;
        for (Map.Entry e : fromColl.entrySet()) {
            Object k = context.mapToType(e.getKey(), context.repository().getType(this.keyType));
            Object v = context.mapToType(e.getValue(), context.repository().getType(this.valueType));
            if (toColl.containsKey(k)) {
                Object o = toColl.get(k);
                if (!context.equalizer().equals(o, v)) {
                    toColl.put(k, v);
                    changed = true;
                    continue;
                }
                toColl.put(k, v);
                changed = true;
                continue;
            }
            toColl.put(k, v);
            changed = true;
        }
        return changed;
    }

    @Override
    public Object mapToType(Object o, NReflectType fromType, NReflectType toType, NReflectMapperContext context) {
        Map c = (Map)context.repository().getType(this.to).newInstance();
        this.copy(o, c, context);
        return c;
    }
}

