/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.reflect.mapper;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.thevpc.nuts.reflect.NReflectMapperContext;
import net.thevpc.nuts.reflect.NReflectType;
import net.thevpc.nuts.reflect.NReflectTypeMapper;
import net.thevpc.nuts.runtime.standalone.reflect.mapper.ArrayToCollectionTypeMapper;
import net.thevpc.nuts.runtime.standalone.reflect.mapper.TypeHelper;

class CollectionToCollectionTypeMapper
implements NReflectTypeMapper {
    private final Type to;
    private final Type componentType;

    public CollectionToCollectionTypeMapper(Type to) {
        this.to = to;
        this.componentType = TypeHelper.asTypeArgs(to, Collection.class).get()[0];
    }

    @Override
    public boolean copy(Object fromObj, Object toObj, NReflectMapperContext context) {
        Collection fromColl = (Collection)fromObj;
        if (fromColl instanceof List) {
            return ArrayToCollectionTypeMapper.copyCollection((List)fromObj, (Collection)toObj, context, this.componentType);
        }
        return ArrayToCollectionTypeMapper.copyCollection(new ArrayList<Object>((Collection)fromObj), (Collection)toObj, context, this.componentType);
    }

    @Override
    public Object mapToType(Object o, NReflectType fromType, NReflectType toType, NReflectMapperContext context) {
        Collection c = (Collection)context.repository().getType(this.to).newInstance();
        this.copy(o, c, context);
        return c;
    }
}

