/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.reflect.mapper;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Collection;
import net.thevpc.nuts.reflect.NReflectMapperContext;
import net.thevpc.nuts.reflect.NReflectType;
import net.thevpc.nuts.reflect.NReflectTypeMapper;
import net.thevpc.nuts.runtime.standalone.reflect.mapper.TypeHelper;

class CollectionToArrayTypeMapper
implements NReflectTypeMapper {
    private final Type to;
    private final Type componentType;
    private final Class componentTypeRaw;

    public CollectionToArrayTypeMapper(Type to) {
        this.to = to;
        if (to instanceof GenericArrayType) {
            this.componentType = ((GenericArrayType)to).getGenericComponentType();
        } else if (to instanceof Class) {
            this.componentType = ((Class)to).getComponentType();
        } else {
            throw new IllegalArgumentException("Unsupported");
        }
        this.componentTypeRaw = TypeHelper.rawClass(this.componentType).get();
    }

    @Override
    public boolean copy(Object fromObj, Object o2, NReflectMapperContext context) {
        Collection fromColl = (Collection)fromObj;
        int i = 0;
        boolean changed = false;
        for (Object o : fromColl) {
            Object ov = Array.get(o2, i);
            Object nv = context.mapToType(o, context.repository().getType(this.componentType));
            if (!context.equalizer().equals(ov, nv)) {
                Array.set(o2, i, nv);
                changed = true;
            }
            ++i;
        }
        return changed;
    }

    @Override
    public Object mapToType(Object fromObj, NReflectType fromType, NReflectType toType, NReflectMapperContext context) {
        int len = ((Collection)fromObj).size();
        Object o2 = Array.newInstance(this.componentTypeRaw, len);
        this.copy(fromObj, o2, context);
        return o2;
    }
}

