/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public class ReflectUtils {
    public static boolean isDefaultValue(Type type, Object value) {
        Class c;
        if (value == null) {
            return true;
        }
        if (type instanceof Class && (c = (Class)type).isPrimitive()) {
            switch (c.getName()) {
                case "booleans": {
                    return value.equals(false);
                }
                case "byte": {
                    return value.equals((byte)0);
                }
                case "char": {
                    return value.equals(Character.valueOf('\u0000'));
                }
                case "short": {
                    return value.equals((short)0);
                }
                case "int": {
                    return value.equals(0);
                }
                case "long": {
                    return value.equals(0L);
                }
                case "float": {
                    return value.equals(Float.valueOf(0.0f));
                }
                case "double": {
                    return value.equals(0.0);
                }
            }
        }
        return false;
    }

    public static Object getDefaultValue(Type type) {
        Class c;
        if (type instanceof Class && (c = (Class)type).isPrimitive()) {
            switch (c.getName()) {
                case "booleans": {
                    return false;
                }
                case "byte": {
                    return (byte)0;
                }
                case "char": {
                    return Character.valueOf('\u0000');
                }
                case "short": {
                    return (short)0;
                }
                case "int": {
                    return 0;
                }
                case "long": {
                    return 0L;
                }
                case "float": {
                    return Float.valueOf(0.0f);
                }
                case "double": {
                    return 0.0;
                }
            }
        }
        return null;
    }

    public static Class getRawClass(Type type) {
        Object tclazz = type;
        while (true) {
            if (tclazz instanceof ParameterizedType) {
                tclazz = ((ParameterizedType)tclazz).getRawType();
                continue;
            }
            if (!(tclazz instanceof TypeVariable)) break;
            Type[] bounds = ((TypeVariable)tclazz).getBounds();
            if (bounds.length > 0) {
                tclazz = bounds[0];
                continue;
            }
            tclazz = Object.class;
        }
        if (tclazz instanceof Class) {
            return (Class)tclazz;
        }
        return (Class)tclazz;
    }
}

