/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.thevpc.nuts.reflect.NReflectPropertyDefaultValueStrategy;
import net.thevpc.nuts.reflect.NReflectType;
import net.thevpc.nuts.runtime.standalone.reflect.AbstractReflectProperty;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NExceptions;

public class MethodReflectProperty3
extends AbstractReflectProperty {
    private Field read;
    private Method write;
    private boolean readAccessible;
    private boolean writeAccessible;

    public MethodReflectProperty3(String name, Field read, Method write, Object cleanInstance, NReflectType type, NReflectPropertyDefaultValueStrategy defaultValueStrategy) {
        if (read != null) {
            this.read = read;
            try {
                this.read.setAccessible(true);
                this.readAccessible = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (write != null) {
            this.write = write;
            try {
                this.write.setAccessible(true);
                this.writeAccessible = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.init(name, type, cleanInstance, read.getGenericType(), defaultValueStrategy);
    }

    @Override
    public boolean isRead() {
        return this.readAccessible;
    }

    @Override
    public boolean isWrite() {
        return this.writeAccessible;
    }

    @Override
    public Object read(Object instance) {
        if (!this.readAccessible) {
            throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC("illegal-access in read mode (%s)", this.toString()));
        }
        try {
            return this.read.get(instance);
        }
        catch (IllegalAccessException ex) {
            throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC("illegal-access in read mode (%s) %s", this.toString(), NExceptions.getErrorMessage(ex)), ex);
        }
    }

    @Override
    public void write(Object instance, Object value) {
        if (!this.writeAccessible) {
            throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC("illegal-access in write mode (%s)", this.toString()));
        }
        try {
            this.write.invoke(instance, value);
        }
        catch (IllegalAccessException ex) {
            throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC("illegal-access in write mode (%s) %s", this.toString(), NExceptions.getErrorMessage(ex)), ex);
        }
        catch (InvocationTargetException ex) {
            throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC("illegal-invocation in write mode (%s) %s", this.toString(), NExceptions.getErrorMessage(ex)), ex);
        }
    }
}

