/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Objects;
import net.thevpc.nuts.reflect.NReflectMethod;
import net.thevpc.nuts.reflect.NReflectParameter;
import net.thevpc.nuts.reflect.NReflectType;
import net.thevpc.nuts.reflect.NSignature;
import net.thevpc.nuts.runtime.standalone.reflect.DefaultNReflectParameter;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NExceptions;

public class DefaultNReflectMethod
implements NReflectMethod {
    private Method method;
    private NReflectType declaringType;
    private NReflectParameter[] cachedParams;
    private NSignature signature;
    private boolean accessible;

    public DefaultNReflectMethod(Method method, NReflectType declaringType) {
        this.method = method;
        try {
            method.setAccessible(true);
            this.accessible = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.declaringType = declaringType;
    }

    @Override
    public boolean isAccessible() {
        return this.accessible;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public NReflectParameter[] getParameters() {
        if (this.cachedParams == null) {
            this.cachedParams = (NReflectParameter[])Arrays.stream(this.method.getParameters()).map(x -> new DefaultNReflectParameter((Parameter)x, this.declaringType.getRepository())).toArray(NReflectParameter[]::new);
        }
        return this.cachedParams;
    }

    @Override
    public Object invoke(Object instance, Object ... args) {
        try {
            return this.method.invoke(instance, args);
        }
        catch (IllegalAccessException ex) {
            throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC("illegal-access (%s) %s", this.toString(), NExceptions.getErrorMessage(ex)), ex);
        }
        catch (InvocationTargetException ex) {
            throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC("illegal-invocation (%s) %s", this.toString(), NExceptions.getErrorMessage(ex)), ex);
        }
    }

    @Override
    public NReflectType getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public boolean isVarArgs() {
        return this.getSignature().isVarArgs();
    }

    @Override
    public NSignature getSignature() {
        if (this.signature == null) {
            Parameter[] mp = this.method.getParameters();
            boolean varargs = mp.length > 0 && mp[mp.length - 1].isVarArgs();
            NReflectType[] p = (NReflectType[])Arrays.stream(this.getParameters()).map(x -> x.getParameterType()).toArray(NReflectType[]::new);
            this.signature = varargs ? NSignature.ofVarArgs(p) : NSignature.of(p);
        }
        return this.signature;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNReflectMethod that = (DefaultNReflectMethod)o;
        return Objects.equals(this.method, that.method) && Objects.equals(this.declaringType, that.declaringType) && Objects.deepEquals(this.cachedParams, that.cachedParams) && Objects.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.declaringType, Arrays.hashCode(this.cachedParams), this.signature);
    }

    public String toString() {
        return this.method.toString();
    }
}

