/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.log;

import java.time.Instant;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NErr;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.log.NLogConfig;
import net.thevpc.nuts.log.NLogSPI;
import net.thevpc.nuts.runtime.standalone.log.DefaultNLogModel;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.util.NStringUtils;

public class NLogConsoleHandler
implements NLogSPI {
    private final DefaultNLogModel model;
    private boolean suspendTerminalMode = false;
    private final LinkedList<Rec> suspendedTerminalRecords = new LinkedList();
    private int suspendedMax = 100;

    public NLogConsoleHandler(DefaultNLogModel model) {
        this.model = model;
    }

    @Override
    public boolean isLoggable(Level level) {
        int levelValue;
        int n = levelValue = this.model.getTermLevel() == null ? Level.INFO.intValue() : this.model.getTermLevel().intValue();
        if (level.intValue() < levelValue || levelValue == Level.OFF.intValue()) {
            return false;
        }
        NSession session = NSession.of();
        NLogConfig logConfig = NWorkspace.of().getBootOptions().getLogConfig().orElseGet(NLogConfig::new);
        Level sessionLogLevel = session.getLogTermLevel();
        if (sessionLogLevel == null) {
            if (logConfig != null) {
                sessionLogLevel = logConfig.getLogTermLevel();
            }
            if (sessionLogLevel == null) {
                sessionLogLevel = Level.OFF;
            }
        }
        int sessionLogLevelValue = sessionLogLevel.intValue();
        return level.intValue() >= sessionLogLevelValue && sessionLogLevelValue != Level.OFF.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void log(NMsg message) {
        if (!this.isLoggable(message.getLevel())) {
            return;
        }
        if (this.suspendTerminalMode) {
            LinkedList<Rec> linkedList = this.suspendedTerminalRecords;
            synchronized (linkedList) {
                this.suspendedTerminalRecords.add(new Rec(Instant.now(), message));
                if (this.suspendedTerminalRecords.size() > this.suspendedMax) {
                    Rec r = this.suspendedTerminalRecords.removeFirst();
                    this.log0(r);
                }
            }
        } else {
            this.log0(new Rec(Instant.now(), message));
        }
    }

    public void suspendTerminal() {
        this.suspendTerminalMode = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTerminal() {
        this.suspendTerminalMode = false;
        LinkedList<Rec> linkedList = this.suspendedTerminalRecords;
        synchronized (linkedList) {
            Iterator iterator = this.suspendedTerminalRecords.iterator();
            while (iterator.hasNext()) {
                Rec r = (Rec)iterator.next();
                iterator.remove();
                this.log0(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log0(Rec rec) {
        NPrintStream nPrintStream = NSession.of().err();
        synchronized (nPrintStream) {
            NErr.resetLine();
            NErr.println(NMsg.ofC("%s [%-6s] [%-7s] %s%s", rec.instant, rec.msg.getLevel(), rec.msg.getIntent(), rec.msg, rec.msg.getDurationNanos() <= 0L ? "" : NMsg.ofC(" (duration: %s)", NDuration.ofNanos(rec.msg.getDurationNanos()))));
            if (rec.msg.getThrowable() != null) {
                NErr.println(NStringUtils.stacktrace(rec.msg.getThrowable()));
            }
        }
    }

    private static class Rec {
        Instant instant;
        NMsg msg;

        public Rec(Instant instant, NMsg msg) {
            this.instant = instant;
            this.msg = msg;
        }
    }
}

