/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.log;

import java.util.function.Supplier;
import java.util.logging.Filter;
import java.util.logging.Level;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NLogContext;
import net.thevpc.nuts.log.NLogSPI;
import net.thevpc.nuts.log.NLogs;
import net.thevpc.nuts.runtime.standalone.log.DefaultNLogModel;
import net.thevpc.nuts.runtime.standalone.log.ScopedNLog;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NMsgBuilder;
import net.thevpc.nuts.util.NAssert;

public class DefaultNLog
implements NLog {
    private NLogSPI logSPI;
    private static final int offValue = Level.OFF.intValue();
    private String name;
    private NLog scoped;
    private DefaultNLogModel model;
    private boolean custom;

    public DefaultNLog(String name, NLogSPI logSPI, DefaultNLogModel model, boolean custom) {
        this.name = name;
        this.logSPI = logSPI;
        this.model = model;
        this.custom = custom;
    }

    public boolean isCustom() {
        return this.custom;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void updateSPI(NLogSPI logSPI) {
        this.logSPI = logSPI;
    }

    @Override
    public void log(NMsgBuilder msg) {
        if (msg != null) {
            this.log(msg.build());
        }
    }

    public Filter getFilter() {
        return null;
    }

    private boolean isLoggable(Level level, Level current) {
        int levelValue = current.intValue();
        return level.intValue() >= levelValue && levelValue != offValue;
    }

    @Override
    public boolean isLoggable(Level level) {
        DefaultNLogModel logModel = NWorkspaceExt.of().getModel().logModel;
        if (logModel.getTermHandler().isLoggable(level)) {
            return true;
        }
        if (logModel.getFileHandler() != null && logModel.getFileHandler().isLoggable(level)) {
            return true;
        }
        return this.logSPI.isLoggable(level);
    }

    @Override
    public void log(NMsg msg) {
        if (msg == null) {
            return;
        }
        DefaultNLogModel logModel = NWorkspaceExt.of().getModel().logModel;
        if (logModel.getTermHandler().isLoggable(msg.getLevel())) {
            logModel.getTermHandler().log(msg);
        }
        if (logModel.getFileHandler() != null && logModel.getFileHandler().isLoggable(msg.getLevel())) {
            logModel.getFileHandler().log(msg);
        }
        if (this.logSPI.isLoggable(msg.getLevel())) {
            this.logSPI.log(this.prepareMsg(msg));
        }
    }

    @Override
    public void log(Level level, Supplier<NMsg> msgSupplier) {
        NAssert.requireNonNull(level, "level");
        DefaultNLogModel logModel = NWorkspaceExt.of().getModel().logModel;
        boolean term = logModel.getTermHandler().isLoggable(level);
        boolean file = logModel.getFileHandler() != null && logModel.getFileHandler().isLoggable(level);
        boolean other = this.logSPI.isLoggable(level);
        if (!(term || file || other)) {
            return;
        }
        NMsg msg = msgSupplier.get();
        msg = msg == null ? this.prepareMsg(NMsg.ofPlain("").withLevel(level)) : this.prepareMsg(msg.withLevel(level));
        if (term) {
            logModel.getTermHandler().log(msg);
        }
        if (file) {
            logModel.getFileHandler().log(msg);
        }
        if (other) {
            this.logSPI.log(this.prepareMsg(msg));
        }
    }

    @Override
    public NLog scoped() {
        if (this.scoped == null) {
            this.scoped = new ScopedNLog(this.model, this);
        }
        return this.scoped;
    }

    private NMsg prepareMsg(NMsg other) {
        NLogContext c = NLogs.of().getContext();
        return other.withPrefix(c.getMessagePrefix()).withSuffix(c.getMessageSuffix()).withPlaceholders(c::getPlaceholder);
    }
}

