/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.runtime.standalone.io.util.InputStreamVisitor;
import net.thevpc.nuts.runtime.standalone.io.util.UnzipOptions;
import net.thevpc.nuts.runtime.standalone.io.util.ZipOptions;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NVisitResult;

public class ZipUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(String target, ZipOptions options, String ... source) throws IOException {
        File f;
        File targetFile;
        block16: {
            if (options == null) {
                options = new ZipOptions();
            }
            targetFile = new File(target);
            f = options.isTempFile() ? File.createTempFile("zip", ".zip") : targetFile;
            f.getParentFile().mkdirs();
            ZipOutputStream zip = null;
            try (FileOutputStream fW = null;){
                fW = new FileOutputStream(f);
                try {
                    zip = new ZipOutputStream(fW);
                    if (options.isSkipRoot()) {
                        for (String s : source) {
                            File file1 = new File(s);
                            if (file1.isDirectory()) {
                                for (File file : file1.listFiles()) {
                                    ZipUtils.add("", file.getPath(), zip);
                                }
                                continue;
                            }
                            ZipUtils.add("", file1.getPath(), zip);
                        }
                        break block16;
                    }
                    for (String s : source) {
                        ZipUtils.add("", s, zip);
                    }
                }
                finally {
                    if (zip != null) {
                        zip.close();
                    }
                }
            }
        }
        if (options.isTempFile()) {
            targetFile.getParentFile().mkdirs();
            if (!f.renameTo(targetFile)) {
                Files.copy(f.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private static void add(String path, String srcFolder, ZipOutputStream zip) throws IOException {
        File folder = new File(srcFolder);
        if (folder.isDirectory()) {
            ZipUtils.addFolderToZip(path, srcFolder, zip);
        } else {
            ZipUtils.addFileToZip(path, srcFolder, zip, false);
        }
    }

    private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws IOException {
        File folder = new File(srcFolder);
        if (folder.list().length == 0) {
            ZipUtils.addFileToZip(path, srcFolder, zip, true);
        } else {
            for (String fileName : folder.list()) {
                if (path.equals("")) {
                    ZipUtils.addFileToZip(folder.getName(), ZipUtils.concatPath(srcFolder, fileName), zip, false);
                    continue;
                }
                ZipUtils.addFileToZip(ZipUtils.concatPath(path, folder.getName()), srcFolder + "/" + fileName, zip, false);
            }
        }
    }

    private static String concatPath(String a, String b) {
        if (a.endsWith("/")) {
            if (b.startsWith("/")) {
                return a + b.substring(1);
            }
            return a + b;
        }
        if (b.startsWith("/")) {
            return a + b;
        }
        return a + "/" + b;
    }

    private static void addFileToZip(String path, String srcFile, ZipOutputStream zip, boolean flag) throws IOException {
        File folder = new File(srcFile);
        String pathPrefix = path;
        if (!pathPrefix.endsWith("/")) {
            pathPrefix = pathPrefix + "/";
        }
        if (!pathPrefix.startsWith("/")) {
            pathPrefix = "/" + pathPrefix;
        }
        if (flag) {
            zip.putNextEntry(new ZipEntry(pathPrefix + folder.getName() + "/"));
        } else if (folder.isDirectory()) {
            ZipUtils.addFolderToZip(pathPrefix, srcFile, zip);
        } else {
            int len;
            byte[] buf = new byte[1024];
            FileInputStream in = new FileInputStream(srcFile);
            zip.putNextEntry(new ZipEntry(pathPrefix + folder.getName()));
            while ((len = in.read(buf)) > 0) {
                zip.write(buf, 0, len);
            }
        }
    }

    public static void unzip(String zipFile, String outputFolder, UnzipOptions options) throws IOException {
        if (options == null) {
            options = new UnzipOptions();
        }
        byte[] buffer = new byte[1024];
        File folder = new File(outputFolder);
        if (!folder.exists()) {
            folder.mkdir();
        }
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(new File(zipFile)));){
            ZipEntry ze = zis.getNextEntry();
            String root = null;
            while (ze != null) {
                File newFile;
                String fileName = ze.getName();
                if (options.isSkipRoot()) {
                    if (root == null) {
                        if (fileName.endsWith("/")) {
                            root = fileName;
                            ze = zis.getNextEntry();
                            continue;
                        }
                        throw new IOException("not a single root zip");
                    }
                    if (fileName.startsWith(root)) {
                        fileName = fileName.substring(root.length());
                    } else {
                        throw new IOException("not a single root zip");
                    }
                }
                if (fileName.endsWith("/")) {
                    newFile = new File(outputFolder + File.separator + fileName);
                    newFile.mkdirs();
                } else {
                    int len;
                    newFile = new File(outputFolder + File.separator + fileName);
                    NLog.of(ZipUtils.class).log(NMsg.ofC("file unzip : %s", newFile.getAbsoluteFile()).asFinestAlert());
                    newFile.getParentFile().mkdirs();
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractFirstPath(InputStream zipFile, Set<String> possiblePaths, OutputStream output, boolean closeOutput) throws IOException {
        byte[] buffer = new byte[4096];
        try (ZipInputStream zis = null;){
            zis = new ZipInputStream(zipFile);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                if (!fileName.endsWith("/") && possiblePaths.contains(fileName)) {
                    try {
                        int len;
                        while ((len = zis.read(buffer)) > 0) {
                            output.write(buffer, 0, len);
                        }
                        zis.closeEntry();
                    }
                    finally {
                        if (closeOutput) {
                            output.close();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                ze = zis.getNextEntry();
            }
        }
        return false;
    }

    public static boolean visitZipStream(NPath zipFile, InputStreamVisitor visitor) {
        boolean bl;
        block8: {
            InputStream is = zipFile.getInputStream();
            try {
                bl = ZipUtils.visitZipStream(is, visitor);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                }
            }
            is.close();
        }
        return bl;
    }

    public static boolean visitZipStream(Path zipFile, InputStreamVisitor visitor) {
        boolean bl;
        block8: {
            InputStream is = Files.newInputStream(zipFile, new OpenOption[0]);
            try {
                bl = ZipUtils.visitZipStream(is, visitor);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                }
            }
            is.close();
        }
        return bl;
    }

    public static boolean visitZipStream(InputStream zipFile, InputStreamVisitor visitor) {
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(zipFile);
            ZipEntry ze = zis.getNextEntry();
            final String eFileName = ze.getName();
            final ZipInputStream finalZis = zis;
            InputStream entryInputStream = new InputStream(){

                @Override
                public int read() throws IOException {
                    return finalZis.read();
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return finalZis.read(b);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return finalZis.read(b, off, len);
                }

                @Override
                public void close() throws IOException {
                    finalZis.closeEntry();
                }

                public String toString() {
                    return eFileName + " Zip Entry InputStream";
                }
            };
            while (ze != null) {
                NVisitResult v;
                String fileName = ze.getName();
                if (!fileName.equals("/") && fileName.startsWith("/")) {
                    fileName = fileName.substring(1);
                }
                if (!fileName.endsWith("/") && (v = visitor.visit(fileName, entryInputStream)) == NVisitResult.TERMINATE) {
                    break;
                }
                ze = zis.getNextEntry();
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                }
            }
        }
        return false;
    }
}

